/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.page.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.page.dao.PageThemeDAO;
import com.kingdee.portal.biz.module.page.entity.PageTheme;
import com.kingdee.portal.biz.module.page.service.PageThemeService;
import java.util.List;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PageThemeServiceImpl
implements PageThemeService {
    private PageThemeDAO pageThemeDAO;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PageTheme> findEnablePageThemeList(PortalContext ctx) throws PortalBizException {
        PageTheme entity = new PageTheme();
        entity.setStatus(StatusEnum.ENABLE);
        try {
            return this.pageThemeDAO.findList(entity, new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    public void setPageThemeDAO(PageThemeDAO pageThemeDAO) {
        this.pageThemeDAO = pageThemeDAO;
    }
}

