/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.perm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.util.ParamHelper;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.query.util.ConstDataType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.module.perm.dto.OrgAdminDTO;
import com.kingdee.portal.biz.module.perm.service.OrgAdminService;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.UuidException;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class OrgAdminServiceImpl
implements OrgAdminService {
    private Uuid uuid = null;
    private int totalCount = 0;
    private EntityViewInfo entityViewInfo;
    private OrgAdminDTO param;
    private Context ctx;

    @Override
    public Map<String, Object> getSearchData(PortalContext ctx, PagingParam pagingParam, OrgAdminDTO param) {
        this.init(ctx, param);
        this.entityViewInfo = this.getQuickFilterEntityViewInfo(param.getAdminOrgId(), param.isShowSub(), param.isShowAllOrg(), param.getSearchWords());
        this.calcTotalCount();
        List<Map<String, Object>> data = this.getData(pagingParam.getPageSize() * (pagingParam.getPageNo() - 1), pagingParam.getPageSize());
        ArrayList<Map<String, Object>> jsArray = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> jsObject = new HashMap<String, Object>();
        for (Map<String, Object> map : data) {
            jsArray.add(map);
        }
        jsObject.put("list", jsArray);
        jsObject.put("totalCount", this.totalCount);
        return jsObject;
    }

    @Override
    public Map<String, Object> getSelectedData(PortalContext ctx, String selectedIds) {
        this.init(ctx, this.param);
        if (!StringUtils.isEmpty((String)selectedIds)) {
            String[] idArray = selectedIds.split(";");
            HashSet<String> parentDataSet = new HashSet<String>();
            for (String id : idArray) {
                parentDataSet.add(id);
            }
            FilterInfo parentDataFilter = new FilterInfo();
            parentDataFilter.getFilterItems().add(new FilterItemInfo("id", parentDataSet, CompareType.INCLUDE));
            EntityViewInfo parentDataViewInfo = new EntityViewInfo();
            parentDataViewInfo.setFilter(parentDataFilter);
            List<HashMap<String, Object>> list = this.getAdminData(parentDataViewInfo);
            this.clearRepeatRows(list, new HashSet<String>());
            ArrayList<Map> jsArray = new ArrayList<Map>();
            HashMap<String, Object> jsObject = new HashMap<String, Object>();
            for (Map map : list) {
                jsArray.add(map);
            }
            jsObject.put("list", jsArray);
            return jsObject;
        }
        return new HashMap<String, Object>();
    }

    @Override
    public Map<String, Object> getJsonData(PortalContext ctx, PagingParam pagingParam, OrgAdminDTO param) {
        this.init(ctx, param);
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        this.entityViewInfo = this.getTree_ClickFilter(context, param.getAdminOrgId(), param.isShowSub(), param.isShowAllOrg());
        this.calcTotalCount();
        List<Map<String, Object>> data = this.getData(pagingParam.getPageSize() * (pagingParam.getPageNo() - 1), pagingParam.getPageSize());
        ArrayList<Map<String, Object>> jsArray = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> jsObject = new HashMap<String, Object>();
        for (Map<String, Object> map : data) {
            jsArray.add(map);
        }
        jsObject.put("list", jsArray);
        jsObject.put("totalCount", this.totalCount);
        return jsObject;
    }

    @Override
    public Map<String, Object> getAddAllData(PortalContext ctx, PagingParam pagingParam, OrgAdminDTO param) {
        this.init(ctx, param);
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (StringUtils.isEmpty((String)param.getSearchWords())) {
            this.entityViewInfo = this.getTree_ClickFilter(context, param.getAdminOrgId(), param.isShowSub(), param.isShowAllOrg());
        } else {
            param.setShowSub(true);
            param.setShowAllOrg(true);
            this.entityViewInfo = this.getQuickFilterEntityViewInfo(param.getAdminOrgId(), param.isShowSub(), param.isShowAllOrg(), param.getSearchWords());
        }
        this.calcTotalCount();
        List<HashMap<String, Object>> data = this.getAdminData(this.entityViewInfo);
        this.clearRepeatRows(data, new HashSet<String>());
        ArrayList<Map> jsArray = new ArrayList<Map>();
        HashMap<String, Object> jsObject = new HashMap<String, Object>();
        for (Map map : data) {
            jsArray.add(map);
        }
        jsObject.put("list", jsArray);
        jsObject.put("totalCount", this.totalCount);
        return jsObject;
    }

    private void init(PortalContext ctx, OrgAdminDTO param) {
        Context context;
        this.ctx = context = (Context)ctx.getMetaInfo().get("eas_context");
        this.param = param;
    }

    private List<HashMap<String, Object>> getAdminData(EntityViewInfo innerViewInfo) {
        ArrayList<HashMap<String, Object>> mainGridDatas = new ArrayList<HashMap<String, Object>>();
        try {
            if (innerViewInfo != null && !innerViewInfo.containsKey("nodata")) {
                mainGridDatas = this.query((IMetaDataPK)this.getQueryPK(), innerViewInfo);
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
        return mainGridDatas;
    }

    private ArrayList<HashMap<String, Object>> query(IMetaDataPK queryPK, EntityViewInfo evi) throws SQLException, BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        exec.setObjectView(evi);
        exec.option().isAutoTranslateEnum = true;
        exec.option().isIgnorePermissionCheck = false;
        IRowSet set = exec.executeQuery();
        return OrgAdminServiceImpl.recordSet2ArrayList(set);
    }

    public static ArrayList<HashMap<String, Object>> recordSet2ArrayList(IRowSet set) throws SQLException {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>(set.size());
        if (set.first()) {
            ResultSetMetaData meta = set.getMetaData();
            do {
                int count = meta.getColumnCount();
                HashMap<String, Object> item = new HashMap<String, Object>(count);
                for (int i = 1; i <= count; ++i) {
                    item.put(meta.getColumnName(i), set.getObject(i));
                }
                list.add(item);
            } while (set.next());
        }
        return list;
    }

    private EntityViewInfo getTree_ClickFilter(Context ctx, String adminOrgId, boolean includeSubOrg, boolean isChkShowAllOrg) {
        EntityViewInfo innerViewInfo = new EntityViewInfo();
        try {
            if (!StringUtils.isEmpty((String)adminOrgId)) {
                AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId));
                if (this.param.isDisable()) {
                    adminInfo.put("disable", (Object)this.param.isDisable());
                }
                FilterInfo filterAdmin = new FilterInfo();
                if (adminInfo != null) {
                    if (null != adminInfo.get("disable") && ((Boolean)adminInfo.get("disable")).booleanValue()) {
                        filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)"nodata"));
                    } else if (includeSubOrg) {
                        filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminInfo.getId().toString()));
                        filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longnumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                        if (!isChkShowAllOrg) {
                            if ("true".equals(this.param.getMultiCU())) {
                                Vector vector = null != ctx.get((Object)"cuadminids") ? (Vector)ctx.get((Object)"cuadminids") : null;
                                HashSet cuSet = new HashSet();
                                if (null != vector) {
                                    Iterator it = vector.iterator();
                                    while (it.hasNext()) {
                                        cuSet.add(it.next());
                                    }
                                }
                                filterAdmin.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", cuSet, CompareType.INCLUDE));
                            } else {
                                filterAdmin.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)adminInfo.getCU().getId().toString(), CompareType.EQUALS));
                            }
                            if (!StringUtils.isEmpty((String)this.param.getFilterInfo())) {
                                filterAdmin.getFilterItems().add(new FilterItemInfo(this.param.getFilterInfo()));
                                filterAdmin.setMaskString("(#0 or #1) and #2 and #3");
                            } else {
                                filterAdmin.setMaskString("(#0 or #1) and #2");
                            }
                        } else if (!StringUtils.isEmpty((String)this.param.getFilterInfo())) {
                            filterAdmin.getFilterItems().add(new FilterItemInfo(this.param.getFilterInfo()));
                            filterAdmin.setMaskString("(#0 or #1) and #2");
                        } else {
                            filterAdmin.setMaskString("#0 or #1");
                        }
                    } else {
                        filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)adminInfo.getId().toString()));
                        filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.longnumber", (Object)(adminInfo.getLongNumber() + "!%"), CompareType.LIKE));
                        filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.level", (Object)new Integer(adminInfo.getLevel() + 1)));
                        if ("true".equals(this.param.getMultiCU())) {
                            Vector vector = null != ctx.get((Object)"cuadminids") ? (Vector)ctx.get((Object)"cuadminids") : null;
                            HashSet cuSet = new HashSet();
                            if (null != vector) {
                                Iterator it = vector.iterator();
                                while (it.hasNext()) {
                                    cuSet.add(it.next());
                                }
                            }
                            filterAdmin.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", cuSet, CompareType.INCLUDE));
                        } else {
                            filterAdmin.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)adminInfo.getCU().getId().toString(), CompareType.EQUALS));
                        }
                        if (!StringUtils.isEmpty((String)this.param.getFilterInfo())) {
                            filterAdmin.getFilterItems().add(new FilterItemInfo(this.param.getFilterInfo()));
                            filterAdmin.setMaskString("(#0 or (#1 and #2)) and #3 and #4");
                        } else {
                            filterAdmin.setMaskString("(#0 or (#1 and #2)) and #3");
                        }
                    }
                } else {
                    filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)"nodata"));
                }
                innerViewInfo.setFilter(filterAdmin);
            } else {
                FilterInfo filterAdmin = new FilterInfo();
                filterAdmin.getFilterItems().add(new FilterItemInfo("AdminOrgUnit.id", (Object)"nodata"));
                innerViewInfo.setFilter(filterAdmin);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return innerViewInfo;
    }

    private EntityViewInfo getQuickFilterEntityViewInfo(String adminOrgId, boolean includeSubOrg, boolean isChkShowAllOrg, String filterValue) {
        String filterQueryValue = filterValue;
        EntityViewInfo viewInfo = null;
        try {
            AdminOrgUnitInfo adminInfo = AdminOrgUnitFactory.getLocalInstance((Context)this.ctx).getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(adminOrgId));
            String theValue = null != filterQueryValue ? filterQueryValue.trim() : null;
            String theCompareString = "=";
            theCompareString = "like";
            StringBuffer oql = new StringBuffer("where ");
            String adminInfoLongNumber = adminInfo.getLongNumber();
            String adminInfoId = adminInfo.getId().toString();
            if (this.param.isDisable()) {
                adminInfo.put("disable", (Object)this.param.isDisable());
            }
            if (!this.param.isSearchInAllOrg() && !isChkShowAllOrg) {
                if (null != adminInfo.get("disable") && ((Boolean)adminInfo.get("disable")).booleanValue()) {
                    oql.append("AdminOrgUnit.id = ").append("'nodata'");
                } else {
                    if (includeSubOrg) {
                        if ("true".equals(this.param.getMultiCU())) {
                            Vector vector = null != this.ctx.get((Object)"cuadminids") ? (Vector)this.ctx.get((Object)"cuadminids") : null;
                            String cuids = "";
                            if (null != vector) {
                                Iterator it = vector.iterator();
                                while (it.hasNext()) {
                                    cuids = cuids + "'" + it.next() + "',";
                                }
                            }
                            cuids = cuids.substring(0, cuids.length() - 1);
                            oql.append("CtrlUnit.id in ").append("(" + cuids + ")");
                        } else {
                            oql.append("(AdminOrgUnit.id = '").append(adminInfoId).append("' or (").append("AdminOrgUnit.longnumber like '").append(adminInfoLongNumber).append("%' ))");
                            if (null != adminInfo) {
                                oql.append("and CtrlUnit.id = '").append(adminInfo.getCU().getId().toString()).append("'");
                            }
                        }
                    } else if (null != adminInfo) {
                        oql.append(" CtrlUnit.id = '").append(adminInfo.getCU().getId().toString()).append("'");
                    }
                    if (!StringUtils.isEmpty((String)filterQueryValue)) {
                        oql.append(" and (");
                        oql.append(this.getQuickFilterOql("number", ConstDataType.STRING, theCompareString, theValue));
                        oql.append(" or ");
                        oql.append(this.getQuickFilterOql("name", ConstDataType.STRING, theCompareString, theValue));
                        oql.append(")");
                    }
                }
            } else if (null != adminInfo.get("disable") && ((Boolean)adminInfo.get("disable")).booleanValue()) {
                oql.append("AdminOrgUnit.id = ").append("'nodata'");
            } else if ("true".equals(this.param.getMultiCU())) {
                Vector vector = null != this.ctx.get((Object)"cuadminids") ? (Vector)this.ctx.get((Object)"cuadminids") : null;
                String cuids = "";
                if (null != vector) {
                    Iterator it = vector.iterator();
                    while (it.hasNext()) {
                        cuids = cuids + "'" + it.next() + "',";
                    }
                }
                cuids = cuids.substring(0, cuids.length() - 1);
                oql.append("CtrlUnit.id in ").append("(" + cuids + ")");
                oql.append(" and (");
                oql.append(this.getQuickFilterOql("number", ConstDataType.STRING, theCompareString, theValue));
                oql.append(" or ");
                oql.append(this.getQuickFilterOql("name", ConstDataType.STRING, theCompareString, theValue));
                oql.append(")");
            } else {
                oql.append("(");
                oql.append(this.getQuickFilterOql("number", ConstDataType.STRING, theCompareString, theValue));
                oql.append(" or ");
                oql.append(this.getQuickFilterOql("name", ConstDataType.STRING, theCompareString, theValue));
                oql.append(")");
            }
            if (!StringUtils.isEmpty((String)this.param.getFilterInfo())) {
                oql.append(" and " + this.param.getFilterInfo());
            }
            System.out.println("\u7ec4\u7ec7------\u67e5\u8be2\u6761\u4ef6sql====" + oql.toString());
            try {
                viewInfo = new EntityViewInfo(oql.toString());
            }
            catch (Exception e) {
                viewInfo = null;
            }
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        return viewInfo;
    }

    private String getQuickFilterOql(String fieldName, ConstDataType theFieldType, String compareStr, String value) {
        String theValue = value;
        theValue = ParamHelper.getMatchString((String)fieldName, (String)theValue, (String)this.getQueryPK().getFullName());
        if (theFieldType.equals((Object)ConstDataType.STRING)) {
            theValue = "'" + theValue + "'";
        }
        return fieldName + " " + compareStr + " " + theValue;
    }

    private MetaDataPK getQueryPK() {
        return new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
    }

    private void clearUUid() {
        try {
            IQueryExecutor QueryExecutor = this.getQueryExecutor();
            if (this.uuid != null) {
                QueryExecutor.releaseQueryCache(this.uuid);
            }
            this.uuid = QueryExecutor.openQuery();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void calcTotalCount() {
        try {
            this.clearUUid();
            this.totalCount = this.getQueryExecutor().getRowCount(this.uuid);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.totalCount = 0;
        }
    }

    private IQueryExecutor getQueryExecutor() throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.getQueryPK());
        exec.setObjectView(this.getEntityViewInfo());
        exec.option().isIgnoreOrder = false;
        exec.option().isAutoIgnoreZero = true;
        exec.option().isAutoTranslateBoolean = true;
        exec.option().isAutoTranslateEnum = true;
        return exec;
    }

    private EntityViewInfo getEntityViewInfo() {
        return this.entityViewInfo;
    }

    private List<Map<String, Object>> getData(int start, int limit) {
        LinkedList<Map<String, Object>> listModel = new LinkedList<Map<String, Object>>();
        if (start < 0 || start > this.totalCount) {
            throw new IllegalArgumentException("out of bound, start:" + start);
        }
        if (start + limit > this.totalCount) {
            limit = this.totalCount - start;
        }
        if (this.totalCount == 0) {
            if (listModel != null) {
                listModel.clear();
            }
            return listModel;
        }
        try {
            IQueryExecutor QueryExecutor = this.getQueryExecutor();
            QueryExecutor.option().pageCount = limit;
            IRowSet row = QueryExecutor.executeQuery(start, limit);
            while (row.next()) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("id", row.getString("id"));
                map.put("name", row.getString("name") == null ? "" : row.getString("name"));
                map.put("number", row.getString("number"));
                map.put("longNumber", row.getString("longNumber"));
                map.put("displayName", row.getString("displayName") == null ? "" : row.getString("displayName"));
                listModel.add(map);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return listModel;
    }

    protected void clearRepeatRows(List<HashMap<String, Object>> selectedGridDatas, Set<String> selectedIdSet) {
        ArrayList<HashMap<String, Object>> newGridDatas = new ArrayList<HashMap<String, Object>>();
        String id = "";
        String position = "";
        for (HashMap<String, Object> item : selectedGridDatas) {
            id = (String)item.get("id");
            if (!selectedIdSet.contains(id)) {
                selectedIdSet.add(id);
                newGridDatas.add(item);
                continue;
            }
            for (HashMap hashMap : newGridDatas) {
                position = (String)item.get("Position.name");
                if (!id.equals(hashMap.get("id").toString())) continue;
                hashMap.put("Position.name", hashMap.get("Position.name") + ";" + position);
            }
        }
        selectedGridDatas.clear();
        for (HashMap<String, Object> newItem : newGridDatas) {
            selectedGridDatas.add(newItem);
        }
    }

    private AdminObjInfo createAdminUnitInfo(IRowSet row) throws UuidException, SQLException {
        AdminObjInfo adminInfo = new AdminObjInfo();
        adminInfo.setId(row.getString("id"));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setDisplayName(row.getString("displayName"));
        return adminInfo;
    }

    class AdminObjInfo {
        private String id;
        private String name;
        private String number;
        private String longNumber;
        private String displayName;

        AdminObjInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }
    }
}

