/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.perm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.module.perm.dto.OrgAdminDTO;
import com.kingdee.portal.biz.module.perm.service.OrgAdminTreeService;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONException;

public class OrgAdminTreeServiceImpl
implements OrgAdminTreeService {
    private boolean showAllOrg = false;
    private boolean _showAllOrg_chkBox_visible = true;
    private boolean _showSub_chkBox_visible = true;
    private String cuId;
    private boolean isSub;
    private Context ctx;

    private void init(PortalContext ctx, OrgAdminDTO param) {
        Context context;
        this.ctx = context = (Context)ctx.getMetaInfo().get("eas_context");
        this.showAllOrg = param.isShowAllOrg();
        this.cuId = param.getCuId();
        this.isSub = param.isSub();
        this._showAllOrg_chkBox_visible = this.getChkBoxVisibleParam("checkAllOrg");
        this._showSub_chkBox_visible = this.getChkBoxVisibleParam("containSub");
    }

    @Override
    public Map<String, Object> getJsonData(PortalContext context, OrgAdminDTO oaDto) {
        this.init(context, oaDto);
        HashMap<String, Object> jsObject = new HashMap<String, Object>();
        List jsArray = new ArrayList();
        jsObject.put("data", jsArray);
        if (StringUtils.isEmpty((String)this.cuId)) {
            this.cuId = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
        }
        Map<String, List<AdminObjInfo>> data = this.createMapTreeData(this.cuId);
        String key = this.getRootKey(data);
        jsArray = this.getTree(key, data);
        jsObject.put("treeData", jsArray);
        jsObject.put("defaultSelectNode", this.getDefaultLongNumber());
        jsObject.put("showAllOrgChkBoxVisible", this._showAllOrg_chkBox_visible);
        jsObject.put("showSubChkBoxVisible", this._showSub_chkBox_visible);
        return jsObject;
    }

    private boolean getChkBoxVisibleParam(String key) {
        boolean paramValue = true;
        try {
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)this.ctx);
            IParamControl iParam = ParamControlFactory.getLocalInstance((Context)this.ctx);
            String strParam = iParam.getParamValueIgnoreGroupControl(key, (IObjectPK)new ObjectUuidPK(cu.getId()), false);
            paramValue = strParam != null ? new Boolean(strParam) : true;
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return paramValue;
    }

    private String getDefaultLongNumber() {
        String adminUnitLongNumber = ContextUtil.getCurrentAdminUnit((Context)this.ctx).getLongNumber();
        return adminUnitLongNumber;
    }

    private List getTree(String key, Map<String, List<AdminObjInfo>> data) {
        ArrayList<HashMap<String, Object>> jsArray = new ArrayList<HashMap<String, Object>>();
        List<Object> list = new ArrayList();
        list = data.get(key);
        for (int i = 0; list != null && i < list.size(); ++i) {
            AdminObjInfo info = (AdminObjInfo)list.get(i);
            HashMap<String, Object> jsObject = new HashMap<String, Object>();
            this.fillAdminJson(jsObject, info);
            String subNodeKey = info.getLongNumber() + "!";
            if (data.containsKey(subNodeKey)) {
                List child = this.getTree(subNodeKey, data);
                jsObject.put("children", child);
            }
            jsArray.add(jsObject);
        }
        return jsArray;
    }

    private void fillAdminJson(Map<String, Object> jsObject, AdminObjInfo info) {
        try {
            jsObject.put("id", info.getId());
            jsObject.put("name", info.getName());
            jsObject.put("number", info.getNumber());
            jsObject.put("longNumber", info.getLongNumber());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    private String getRootKey(Map<String, List<AdminObjInfo>> data) {
        String rootkey = "";
        Iterator<String> iter = data.keySet().iterator();
        if (iter.hasNext()) {
            rootkey = iter.next();
        }
        return rootkey;
    }

    private Map<String, List<AdminObjInfo>> createMapTreeData(String cuId) {
        LinkedHashMap<String, List<AdminObjInfo>> adminForTreeMap = new LinkedHashMap<String, List<AdminObjInfo>>();
        try {
            IRowSet rs = this.getAdminRowSet(cuId, null, this.showAllOrg);
            String key = null;
            AdminObjInfo admin = null;
            List value = null;
            while (rs.next()) {
                key = rs.getString("longNumber").substring(0, rs.getString("longNumber").length() - rs.getString("number").length());
                admin = this.createAdminUnitInfo(rs);
                value = adminForTreeMap.get(key) == null ? new ArrayList() : (List)adminForTreeMap.get(key);
                value.add(admin);
                adminForTreeMap.put(key, value);
            }
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (UuidException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return adminForTreeMap;
    }

    private Map<String, List<AdminObjInfo>> getAdminForTreeMap(AdminObjInfo rootInfo, boolean showAllOrg) throws EASBizException, BOSException, UuidException, SQLException {
        String cuId = ContextUtil.getCurrentCtrlUnit((Context)this.ctx).getId().toString();
        LinkedHashMap<String, List<AdminObjInfo>> adminForTreeMap = new LinkedHashMap<String, List<AdminObjInfo>>();
        IRowSet rs = this.getAdminRowSet(cuId, rootInfo, showAllOrg);
        String key = null;
        AdminObjInfo admin = null;
        List value = null;
        while (rs.next()) {
            key = rs.getString("longNumber").substring(0, rs.getString("longNumber").length() - rs.getString("number").length());
            admin = this.createAdminUnitInfo(rs);
            value = adminForTreeMap.get(key) == null ? new ArrayList() : (List)adminForTreeMap.get(key);
            value.add(admin);
            adminForTreeMap.put(key, value);
        }
        return adminForTreeMap;
    }

    private IRowSet getAdminRowSet(String cuID, AdminObjInfo rootInfo, boolean showAllOrg) throws EASBizException, BOSException, UuidException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (rootInfo != null) {
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)rootInfo.getLongNumber()));
            fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(rootInfo.getLongNumber() + "!%"), CompareType.LIKE));
            if (showAllOrg) {
                fi.setMaskString("#0 or #1");
            } else if (cuID != null) {
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
                fi.setMaskString("(#0 or #1) and #2");
            }
        } else if (!showAllOrg) {
            if (this.isSub) {
                try {
                    String longNumber = null;
                    String sqlLongNumber = "select FLongNumber from T_ORG_CtrlUnit where FID='" + cuID + "'";
                    IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sqlLongNumber);
                    while (rowSet.next()) {
                        longNumber = rowSet.getString("FLongNumber");
                    }
                    fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
                    fi.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
                    fi.setMaskString("#0 or #1");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                fi.getFilterItems().add(new FilterItemInfo("CtrlUnit.id", (Object)cuID));
            }
        }
        viewInfo.setFilter(fi);
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.basedata.org.app.NewAdminTreeQuery");
        IQueryExecutor queryExcu = QueryExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)queryPK);
        queryExcu.setObjectView(viewInfo);
        return queryExcu.executeQuery();
    }

    private AdminObjInfo createAdminUnitInfo(IRowSet row) throws UuidException, SQLException {
        AdminObjInfo adminInfo = new AdminObjInfo();
        adminInfo.setId(row.getString("id"));
        adminInfo.setName(row.getString("name") == null ? "" : row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        return adminInfo;
    }

    class AdminObjInfo {
        private String id;
        private String name;
        private String number;
        private String longNumber;

        AdminObjInfo() {
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public void setNumber(String number) {
            this.number = number;
        }

        public String getLongNumber() {
            return this.longNumber;
        }

        public void setLongNumber(String longNumber) {
            this.longNumber = longNumber;
        }
    }
}

