/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.perm.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.IRole;
import com.kingdee.eas.base.permission.RoleCollection;
import com.kingdee.eas.base.permission.RoleFactory;
import com.kingdee.eas.base.permission.RoleInfo;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.facade.portal.facade.PortalCacheFacade;
import com.kingdee.portal.biz.module.perm.common.enums.PermTypeEnum;
import com.kingdee.portal.biz.module.perm.common.json.PermInfo;
import com.kingdee.portal.biz.module.perm.dao.PermRefResDAO;
import com.kingdee.portal.biz.module.perm.dto.EASRoleDTO;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.perm.dto.UserDTO;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.entity.Role;
import com.kingdee.portal.biz.module.perm.service.GroupService;
import com.kingdee.portal.biz.module.perm.service.PermRefResService;
import com.kingdee.portal.biz.module.perm.service.RoleService;
import com.kingdee.portal.biz.module.perm.service.UserService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PermRefResServiceImpl
implements PermRefResService {
    private PermRefResDAO permRefResDAO;
    private GroupService groupService;
    private UserService userService;
    private RoleService roleService;
    private static final Logger logger = LoggerFactory.getLogger(PermRefResServiceImpl.class);

    private boolean updatePrem(PermRefRes perm, PermRefRes pr) throws DataAccessException {
        PermInfo pi = new PermInfo(pr.getPermInfo());
        if ("VIEW".equals(perm.getPermInfo())) {
            pi.setView(true);
        } else {
            pi.setEdit(true);
        }
        pr.setPermInfo(pi.toString());
        pr.setSourceType(perm.getSourceType());
        this.permRefResDAO.update(pr);
        return true;
    }

    private void updatePremInfo(PermRefRes perm, PermRefRes pr) throws DataAccessException {
        PermInfo pi = new PermInfo(pr.getPermInfo());
        if ("VIEW".equals(perm.getPermInfo())) {
            pi.setView(false);
        } else {
            pi.setEdit(false);
        }
        if (!pi.isEdit() && !pi.isView()) {
            this.permRefResDAO.delete(pr);
        } else {
            pr.setPermInfo(pi.toString());
            this.permRefResDAO.update(pr);
        }
    }

    private void addPerm(PortalContext ctx, PermRefRes perm, String permId) throws DataAccessException {
        PermInfo pi = new PermInfo();
        if ("VIEW".equals(perm.getPermInfo())) {
            pi.setView(true);
        } else if ("saveAs".equals(perm.getPermInfo())) {
            pi.setSaveAs(true);
        } else if ("canCustomer".equals(perm.getPermInfo())) {
            pi.setCanCustomer(true);
        } else {
            pi.setEdit(true);
        }
        PermRefRes permref = new PermRefRes();
        permref.setPortalContext(ctx);
        permref.setResType(perm.getResType());
        permref.setResId(perm.getResId());
        permref.setPermType(perm.getPermType());
        permref.setPermId(permId);
        permref.setPermInfo(pi.toString());
        permref.setSourceType(perm.getSourceType());
        this.permRefResDAO.create(permref);
    }

    @Override
    public List<PermRefRes> batchCreatePermRefRes(PortalContext ctx, PermRefRes perm, String[] permIds, String[] delIds) throws PortalBizException {
        try {
            ArrayList<PermRefRes> perms = new ArrayList<PermRefRes>();
            PermRefRes prp = new PermRefRes();
            prp.setResId(perm.getResId());
            prp.setPermType(perm.getPermType());
            List<PermRefRes> permList = this.permRefResDAO.findList(prp, new Filter[0]);
            for (String permId : permIds) {
                boolean iresult = false;
                for (PermRefRes pr : permList) {
                    if (!permId.equals(pr.getPermId())) continue;
                    iresult = this.updatePrem(perm, pr);
                    break;
                }
                if (iresult) continue;
                this.addPerm(ctx, perm, permId);
            }
            block6: for (PermRefRes pr : permList) {
                for (String delId : delIds) {
                    if (!delId.equals(pr.getPermId())) continue;
                    this.updatePremInfo(perm, pr);
                    perms.add(pr);
                    continue block6;
                }
            }
            try {
                Context context = (Context)ctx.getMetaInfo().get("eas_context");
                PortalCacheFacade.updateCacheFlag(context, "FPageFlag");
            }
            catch (Exception e) {
                logger.error("batchCreatePermRefRes updateCacheFlag error ==", (Throwable)e);
            }
            return perms;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private PermRefRes findAuthorizeByPerm(PermRefRes perm) throws PortalBizException {
        try {
            return this.permRefResDAO.findObject(perm, new Filter[0]);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, Object> findAuthorizeByPageId(PortalContext ctx, PermRefRes perm) throws PortalBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            perm.setPermType(PermTypeEnum.ROLE);
            map.put("roleList", this.getPermRoleList(ctx, perm));
            perm.setPermType(PermTypeEnum.USER);
            map.put("userList", this.getPermUserList(ctx, perm));
            perm.setPermType(PermTypeEnum.GROUP);
            map.put("groupList", this.getPermGroupList(ctx, perm));
            perm.setPermType(PermTypeEnum.EAS_ROLE);
            map.put("easRoleList", this.getPermEasRoleList(ctx, perm));
        }
        catch (DataAccessException e) {
            logger.error("findAuthorizeByPageId====Error=========", (Throwable)e);
            throw new PortalBizException("300", e);
        }
        return map;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<UserDTO> getPermUserList(PortalContext ctx, PermRefRes perm) throws DataAccessException, PortalBizException {
        List<PermRefRes> permUserLlist = this.getPermList(ctx, perm);
        List<UserDTO> userList = this.getUserInfoList(ctx, this.getUserIdArr(permUserLlist));
        return userList;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<EASRoleDTO> getPermEasRoleList(PortalContext ctx, PermRefRes perm) throws DataAccessException, PortalBizException {
        List<PermRefRes> permEasRoleList = this.getPermList(ctx, perm);
        String[] easRoleIdArr = this.getGroupIdArr(permEasRoleList);
        ArrayList<EASRoleDTO> easRoleList = new ArrayList<EASRoleDTO>();
        if (easRoleIdArr.length <= 0) {
            return new ArrayList<EASRoleDTO>();
        }
        try {
            IRole iRole = RoleFactory.getRemoteInstance();
            StringBuilder builder = new StringBuilder(100);
            builder.append("''");
            for (String id : easRoleIdArr) {
                builder.append(",'").append(id).append("'");
            }
            StringBuilder jpql = new StringBuilder(100);
            jpql.append("where id in (").append(builder.toString()).append(")");
            RoleCollection roles = iRole.getRoleCollection(jpql.toString());
            for (int i = 0; i < roles.size(); ++i) {
                EASRoleDTO roleDto = new EASRoleDTO();
                RoleInfo info = roles.get(i);
                roleDto.setId(info.getId().toString());
                roleDto.setName(info.getName());
                roleDto.setCode(info.getNumber());
                easRoleList.add(roleDto);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return easRoleList;
    }

    private List<PermRefRes> getPermList(PortalContext ctx, PermRefRes perm) throws DataAccessException, PortalBizException {
        PermRefRes prp = new PermRefRes();
        prp.setResId(perm.getResId());
        prp.setPermType(perm.getPermType());
        List<PermRefRes> permList = this.permRefResDAO.findList(prp, new Filter[0]);
        ArrayList<PermRefRes> returnList = new ArrayList<PermRefRes>();
        for (PermRefRes pr : permList) {
            PermInfo pi = new PermInfo(pr.getPermInfo());
            if ("VIEW".equals(perm.getPermInfo())) {
                if (!pi.isView()) continue;
                returnList.add(pr);
                continue;
            }
            if ("saveAs".equals(perm.getPermInfo())) {
                if (!pi.isSaveAs()) continue;
                returnList.add(pr);
                continue;
            }
            if ("canCustomer".equals(perm.getPermInfo())) {
                if (!pi.isCanCustomer()) continue;
                returnList.add(pr);
                continue;
            }
            if (!pi.isEdit()) continue;
            returnList.add(pr);
        }
        return returnList;
    }

    private String[] getUserIdArr(List<PermRefRes> permUserLlist) {
        ArrayList<String> userIdArr = new ArrayList<String>();
        for (PermRefRes refUser : permUserLlist) {
            userIdArr.add(refUser.getPermId());
        }
        return userIdArr.toArray(new String[0]);
    }

    private List<UserDTO> getUserInfoList(PortalContext ctx, String[] userIdArr) throws PortalBizException {
        if (userIdArr.length <= 0) {
            return new ArrayList<UserDTO>();
        }
        return this.userService.findUserListByIds(ctx, userIdArr);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Role> getPermRoleList(PortalContext ctx, PermRefRes perm) throws DataAccessException, PortalBizException {
        List<PermRefRes> permRoleLlist = this.getPermList(ctx, perm);
        if (permRoleLlist != null) {
            String[] roleIDList = new String[permRoleLlist.size()];
            for (int i = 0; i < permRoleLlist.size(); ++i) {
                roleIDList[i] = permRoleLlist.get(i).getPermId();
            }
            List<Role> roleList = this.roleService.findRoleByIds(ctx, roleIDList);
            return roleList;
        }
        return null;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<GroupDTO> getPermGroupList(PortalContext ctx, PermRefRes perm) throws DataAccessException, PortalBizException {
        List<PermRefRes> permGroupLlist = this.getPermList(ctx, perm);
        String[] groupIdArr = this.getGroupIdArr(permGroupLlist);
        if (groupIdArr.length <= 0) {
            return new ArrayList<GroupDTO>();
        }
        List<GroupDTO> groupList = this.groupService.findGroupListByIds(ctx, groupIdArr);
        return groupList;
    }

    private String[] getGroupIdArr(List<PermRefRes> permGroupLlist) {
        ArrayList<String> groupIdArr = new ArrayList<String>();
        for (PermRefRes group : permGroupLlist) {
            groupIdArr.add(group.getPermId());
        }
        return groupIdArr.toArray(new String[0]);
    }

    @Override
    public void delPermRefRes(PortalContext ctx, PermRefRes perm) throws PortalBizException {
        try {
            PermRefRes findPerm = new PermRefRes();
            findPerm.setResType(perm.getResType());
            findPerm.setResId(perm.getResId());
            findPerm.setPermType(perm.getPermType());
            findPerm.setPermId(perm.getPermId());
            PermRefRes exitPerm = this.findAuthorizeByPerm(findPerm);
            if (exitPerm != null) {
                PermInfo pi = new PermInfo(exitPerm.getPermInfo());
                if ("VIEW".equals(perm.getPermInfo())) {
                    pi.setView(false);
                } else {
                    pi.setEdit(false);
                }
                if (!pi.isEdit() && !pi.isView()) {
                    this.permRefResDAO.delete(exitPerm);
                } else {
                    exitPerm.setPermInfo(pi.toString());
                    this.permRefResDAO.update(exitPerm);
                }
                try {
                    Context context = (Context)ctx.getMetaInfo().get("eas_context");
                    PortalCacheFacade.updateCacheFlag(context, "FPageFlag");
                }
                catch (Exception e) {
                    logger.error("batchCreatePermRefRes delPermRefRes error ==", (Throwable)e);
                }
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void delPermRefResAll(PortalContext ctx, PermRefRes perm) throws PortalBizException {
        try {
            List<PermRefRes> permList = this.getPermDelList(ctx, perm);
            ArrayList<PermRefRes> updateList = new ArrayList<PermRefRes>();
            ArrayList<PermRefRes> delList = new ArrayList<PermRefRes>();
            if (permList != null) {
                for (PermRefRes pr : permList) {
                    PermInfo pi = new PermInfo(pr.getPermInfo());
                    if ("VIEW".equals(perm.getPermInfo())) {
                        pi.setView(false);
                    } else {
                        pi.setEdit(false);
                    }
                    if (!pi.isEdit() && !pi.isView()) {
                        delList.add(pr);
                        continue;
                    }
                    pr.setPermInfo(pi.toString());
                    updateList.add(pr);
                }
                this.permRefResDAO.update(updateList);
                if (delList != null && delList.size() > 0) {
                    String[] delIds = new String[delList.size()];
                    for (int i = 0; i < delList.size(); ++i) {
                        delIds[i] = ((PermRefRes)delList.get(i)).getId();
                    }
                    this.permRefResDAO.deleteByIds(delIds);
                }
                try {
                    Context context = (Context)ctx.getMetaInfo().get("eas_context");
                    PortalCacheFacade.updateCacheFlag(context, "FPageFlag");
                }
                catch (Exception e) {
                    logger.error("batchCreatePermRefRes delPermRefResAll error ==", (Throwable)e);
                }
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private List<PermRefRes> getPermDelList(PortalContext ctx, PermRefRes perm) throws DataAccessException, PortalBizException {
        PermRefRes findPerm = new PermRefRes();
        findPerm.setResId(perm.getResId());
        findPerm.setPermType(perm.getPermType());
        List<PermRefRes> permList = this.permRefResDAO.findList(findPerm, new Filter[0]);
        ArrayList<PermRefRes> returnList = new ArrayList<PermRefRes>();
        for (PermRefRes pr : permList) {
            PermInfo pi = new PermInfo(pr.getPermInfo());
            if ("VIEW".equals(perm.getPermInfo())) {
                if (!pi.isView()) continue;
                returnList.add(pr);
                continue;
            }
            if (!pi.isEdit()) continue;
            returnList.add(pr);
        }
        return returnList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PermRefRes> findPermLlist(PortalContext ctx, String[] ids) throws PortalBizException {
        try {
            List<PermRefRes> permList;
            int totalLength = ids.length;
            int subLength = 990;
            if (totalLength < subLength) {
                permList = this.permRefResDAO.findPermRefResByPermIds(ids);
            } else {
                int findDbCount = (int)Math.floor(totalLength / subLength);
                permList = new ArrayList<PermRefRes>();
                for (int i = 0; i < findDbCount; ++i) {
                    int firstCount = i * subLength;
                    String[] findIds = new String[subLength];
                    for (int j = 0; j < subLength; ++j) {
                        findIds[j] = ids[j + firstCount];
                    }
                    List<PermRefRes> list = this.permRefResDAO.findPermRefResByPermIds(findIds);
                    if (list == null) continue;
                    for (int k = 0; k < list.size(); ++k) {
                        permList.add(list.get(k));
                    }
                }
                if (findDbCount * subLength < totalLength) {
                    String[] findIds = new String[totalLength - findDbCount * subLength];
                    for (int z = 0; z < findIds.length; ++z) {
                        findIds[z] = ids[findDbCount * subLength + z];
                    }
                    List<PermRefRes> list = this.permRefResDAO.findPermRefResByPermIds(findIds);
                    if (list != null) {
                        for (int k = 0; k < list.size(); ++k) {
                            permList.add(list.get(k));
                        }
                    }
                }
            }
            return this.isPermDuplicate(permList);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private List<PermRefRes> isPermDuplicate(List<PermRefRes> permList) throws PortalBizException {
        ArrayList<PermRefRes> newList = new ArrayList<PermRefRes>();
        for (PermRefRes perm : permList) {
            boolean result = false;
            PermInfo pi = new PermInfo(perm.getPermInfo());
            if (!pi.isEdit() && !pi.isView()) continue;
            for (PermRefRes newPerm : newList) {
                if (!perm.getResId().equals(newPerm.getResId())) continue;
                PermInfo newPi = new PermInfo(newPerm.getPermInfo());
                if (pi.isEdit() || newPi.isEdit()) {
                    newPi.setEdit(true);
                    newPerm.setPermInfo(newPi.toString());
                }
                result = true;
                break;
            }
            if (result) continue;
            newList.add(perm);
        }
        return newList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PermRefRes> findPermUserLlist(PortalContext ctx, PermRefRes perm) throws PortalBizException {
        return null;
    }

    public void setPermRefResDAO(PermRefResDAO permRefResDAO) {
        this.permRefResDAO = permRefResDAO;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }
}

