/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.perm.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.enums.ResTypeEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.frame.entity.PortalCacheFlag;
import com.kingdee.portal.biz.module.frame.service.PortalCacheFlagService;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.LinkNodeExt;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.perm.common.enums.PermTypeEnum;
import com.kingdee.portal.biz.module.perm.common.json.PermInfo;
import com.kingdee.portal.biz.module.perm.dto.CuInfoDTO;
import com.kingdee.portal.biz.module.perm.entity.PermRefRes;
import com.kingdee.portal.biz.module.perm.service.GroupService;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.common.util.StringUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PermServiceImpl
implements PermService {
    private GroupService groupService;
    private EASService easService;
    private PortalCacheFlagService portalCacheFlagService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String[] getPermIds(PortalContext ctx, String userId) throws PortalBizException {
        try {
            int ilength = 0;
            IRowSet rs = this.groupService.findPermIdByUserId(ctx, userId, "20");
            String[] permIds = new String[rs.size() + 2];
            if (rs != null) {
                while (rs.next()) {
                    permIds[ilength] = rs.getString("fid");
                    ++ilength;
                }
            }
            permIds[ilength] = userId;
            permIds[++ilength] = "da276ac7-95b4-46a6-b6dd-737a2373b7e9";
            return permIds;
        }
        catch (PortalBizException e) {
            throw new PortalBizException("300", e);
        }
        catch (SQLException se) {
            throw new PortalBizException("300", se);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Page> selectPermPageList(PortalContext ctx, List<Page> pageList, Map<String, Object> permMap, String userId) throws PortalBizException {
        ArrayList<Page> newList = new ArrayList<Page>();
        List<PermRefRes> permList = PortalCache.getPortalPagePerm(ctx);
        Map<String, String> easLinkList = PortalCache.getEasWebListPerm(ctx);
        Map<String, String> oaLinkList = PortalCache.getOADynamicListPerm(ctx);
        Map<String, String> shrLinkList = PortalCache.getSHRWebListPerm(ctx);
        for (Page page : pageList) {
            Object newPage;
            Page newPage2;
            String pageId;
            ELinkNodeExt nodeExt;
            boolean result = false;
            if (page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK) || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_G)) {
                try {
                    nodeExt = new ELinkNodeExt(page.getNodeExt().toString());
                    pageId = easLinkList.get(nodeExt.getExternalId());
                    if (pageId == null) continue;
                    newPage2 = this.setPage4Perm(page, true, false);
                    newList.add(newPage2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u83dc\u5355\u89e3\u6790\u5f02\u5e38\uff1a" + page.getId());
                }
                continue;
            }
            if (page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_OA)) {
                try {
                    nodeExt = new ELinkNodeExt(page.getNodeExt().toString());
                    pageId = oaLinkList.get(nodeExt.getExternalId());
                    if (pageId == null) continue;
                    newPage2 = this.setPage4Perm(page, true, false);
                    newList.add(newPage2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u83dc\u5355\u89e3\u6790\u5f02\u5e38\uff1a" + page.getId());
                }
                continue;
            }
            if (page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_SHR)) {
                try {
                    nodeExt = new ELinkNodeExt(page.getNodeExt().toString());
                    pageId = shrLinkList.get(nodeExt.getExternalId());
                    if (pageId == null) continue;
                    newPage2 = this.setPage4Perm(page, true, false);
                    newList.add(newPage2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("\u83dc\u5355\u89e3\u6790\u5f02\u5e38\uff1a" + page.getId());
                }
                continue;
            }
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            if (!PortalCache.getLicenseFlag(context) && !page.getNodeType().equals((Object)NodeTypeEnum.PLAN)) {
                if (!this.needAddToPageList(page.getId())) continue;
                newPage = this.setPage4Perm(page, true, false);
                newList.add((Page)newPage);
                continue;
            }
            for (PermRefRes ref : permList) {
                if (!page.getId().equals(ref.getResId()) || !page.getNodeType().toString().equals(ref.getResType().toString())) continue;
                PermInfo pi = new PermInfo(ref.getPermInfo());
                Page newPage3 = this.setPage4Perm(page, true, pi.isEdit());
                newList.add(newPage3);
                result = true;
                break;
            }
            if (result || page.getPermViewCtrl().booleanValue()) continue;
            newPage = this.setPage4Perm(page, true, false);
            newList.add((Page)newPage);
        }
        return newList;
    }

    private boolean needAddToPageList(String id) {
        boolean result = false;
        Map<String, String> map = this.getNolicenseDisplayPageList();
        if (!StringUtil.isEmpty((String)map.get(id))) {
            result = true;
        }
        return result;
    }

    private Map<String, String> getNolicenseDisplayPageList() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("9c404817-9a16-49a6-8fd6-20dfe8b4ea4d", "9c404817-9a16-49a6-8fd6-20dfe8b4ea4d");
        map.put("794be440-6c72-4de7-9ee2-4125795e3005", "794be440-6c72-4de7-9ee2-4125795e3005");
        map.put("eb64cf78-1a55-4e67-bb04-b81c96010a89", "eb64cf78-1a55-4e67-bb04-b81c96010a89");
        map.put("19911d49-3f9a-45f0-8408-ca0d0da6c8de", "19911d49-3f9a-45f0-8408-ca0d0da6c8de");
        return map;
    }

    private Page setPage4Perm(Page page, boolean viewCtrl, boolean editCtrl) {
        LinkNodeExt ext;
        Page newPage = new Page();
        newPage.setDescription(page.getDescription());
        newPage.setDisplayName(page.getDisplayName());
        newPage.setHidden(page.getHidden());
        newPage.setIcon(page.getIcon());
        newPage.setId(page.getId());
        newPage.setNodeLevel(page.getNodeLevel());
        newPage.setNodeOrder(page.getNodeOrder());
        newPage.setNodePath(page.getNodePath());
        newPage.setNodeType(page.getNodeType());
        newPage.setPageNumber(page.getPageNumber());
        newPage.setParentNodeId(page.getParentNodeId());
        newPage.setResLevel(page.getResLevel());
        newPage.setSettingInfo(page.getSettingInfo());
        newPage.setStatus(page.getStatus());
        newPage.setUserId(page.getUserId());
        newPage.setPermViewCtrl(viewCtrl);
        newPage.setPermEditCtrl(editCtrl);
        newPage.setPreferences(page.getPreferences());
        String nodeExt = page.getNodeExt();
        if (page.getNodeType().equals((Object)NodeTypeEnum.LINK) && page.getNodeExt() != null && (ext = new LinkNodeExt(nodeExt)).getSso() != null && ext.getSso().booleanValue()) {
            ext.setUrl("/portal/openSSOUrlServlet?url=" + ext.getUrl());
            nodeExt = ext.toString();
        }
        newPage.setPageUrl(page.getPageUrl());
        newPage.setNodeExt(nodeExt);
        return newPage;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletDefinition> findPermPortletList(PortalContext ctx, List<PortletDefinition> pltList, String userId) throws PortalBizException {
        List<PermRefRes> permList = PortalCache.getPortalPagePerm(ctx);
        List<PortletDefinition> resultList = this.matchPltIDAndPermId(ctx, pltList, permList);
        return resultList;
    }

    private List<PortletDefinition> matchPltIDAndPermId(PortalContext ctx, List<PortletDefinition> pltList, List<PermRefRes> permList) throws PortalBizException {
        ArrayList<PortletDefinition> newList = new ArrayList<PortletDefinition>();
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        if (!PortalCache.getLicenseFlag(context)) {
            Map<String, String> map = this.getPermPortletMap();
            for (PortletDefinition pd : pltList) {
                if (StringUtil.isEmpty((String)map.get(pd.getId()))) continue;
                newList.add(pd);
            }
            return newList;
        }
        block1: for (PortletDefinition pd : pltList) {
            if (!pd.getPermViewCtrl().booleanValue()) {
                newList.add(pd);
                continue;
            }
            for (PermRefRes ref : permList) {
                if (!pd.getId().equals(ref.getResId())) continue;
                newList.add(pd);
                continue block1;
            }
        }
        return newList;
    }

    private Map<String, String> getPermPortletMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("45f8796f-470b-4599-bd04-31224fc76433", "45f8796f-470b-4599-bd04-31224fc76433");
        map.put("1ce03e54-19e6-4eb4-8d2f-b06be0f7038b", "1ce03e54-19e6-4eb4-8d2f-b06be0f7038b");
        return map;
    }

    @Override
    public void findPermSession(PortalContext ctx, boolean hasLicence) throws PortalBizException {
        String userId = ctx.getLoginUser().getId();
        PortalCacheFlag pcFlag = this.portalCacheFlagService.findPortalCacheFlagByUserId(ctx, userId);
        if (pcFlag.getClientFlag().booleanValue()) {
            this.getPermEasWebList(ctx);
            this.getPermSHRWebList(ctx);
        }
        if (pcFlag.getOaFlag().booleanValue()) {
            this.getPermOADynamicList(ctx);
        }
        if (pcFlag.getPageFlag().booleanValue()) {
            this.getPermLlist(ctx, hasLicence);
        }
    }

    @Override
    public void refreshMenu(PortalContext ctx, boolean hasLicence) throws PortalBizException {
        this.getPermLlist(ctx, hasLicence);
        this.getPermEasWebList(ctx);
        this.getPermOADynamicList(ctx);
        this.getPermSHRWebList(ctx);
    }

    @Override
    public List<PermRefRes> getPermLlist(PortalContext ctx, boolean hasLicence) throws PortalBizException {
        String userId = ctx.getLoginUser().getId();
        ArrayList<PermRefRes> permList = new ArrayList<PermRefRes>();
        try {
            IRowSet rs = null;
            rs = hasLicence ? this.groupService.findPermIdByUserId(ctx, userId, "20") : this.groupService.findPermIdByUserIdNoLicense(ctx, userId, "20");
            if (rs != null) {
                while (rs.next()) {
                    PermRefRes ref = new PermRefRes();
                    ref.setResType(ResTypeEnum.valueOf(rs.getString("FResType")));
                    ref.setResId(rs.getString("FResId"));
                    ref.setPermType(PermTypeEnum.valueOf(rs.getString("FPermType")));
                    ref.setPermId(rs.getString("FPermId"));
                    ref.setPermInfo(rs.getString("FPermInfo"));
                    permList.add(ref);
                }
            }
            PortalCache.setPortalPagePerm(ctx, permList);
            this.portalCacheFlagService.updatePageCacheFlag(ctx, userId, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalBizException("216", e);
        }
        return permList;
    }

    @Override
    public Map<String, String> getPermGUILinkList(PortalContext ctx) {
        Map<String, String> guiList = new HashMap<String, String>();
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            guiList = this.easService.getPermessionArrayExt(context, NodeTypeEnum.EXTERNAL_LINK_G, false);
            PortalCache.setGUIListPerm(ctx, guiList);
            String userId = ctx.getLoginUser().getId();
            this.portalCacheFlagService.updateClientCacheFlag(ctx, userId, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                throw new PortalBizException("214", e);
            }
            catch (PortalBizException portalBizException) {
                // empty catch block
            }
        }
        return guiList;
    }

    @Override
    public Map<String, String> getPermEasWebList(PortalContext ctx) {
        Map<String, String> easWebList = new HashMap<String, String>();
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            easWebList = this.easService.getPermessionArrayExt(context, NodeTypeEnum.EXTERNAL_LINK, true);
            PortalCache.setEasWebListPerm(ctx, easWebList);
            String userId = ctx.getLoginUser().getId();
            this.portalCacheFlagService.updateClientCacheFlag(ctx, userId, false);
            PortalCache.setFavoriteList(ctx, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                throw new PortalBizException("213", e);
            }
            catch (PortalBizException portalBizException) {
                // empty catch block
            }
        }
        return easWebList;
    }

    @Override
    public Map<String, String> getPermOADynamicList(PortalContext ctx) {
        Map<String, String> oaList = new HashMap<String, String>();
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            oaList = this.easService.getPermessionArrayExt(context, NodeTypeEnum.EXTERNAL_LINK_OA, false);
            PortalCache.setOADynamicListPerm(ctx, oaList);
            String userId = ctx.getLoginUser().getId();
            this.portalCacheFlagService.updateOACacheFlag(ctx, userId, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                throw new PortalBizException("215", e);
            }
            catch (PortalBizException portalBizException) {
                // empty catch block
            }
        }
        return oaList;
    }

    @Override
    public Map<String, String> getPermSHRWebList(PortalContext ctx) {
        Map<String, String> shrList = new HashMap<String, String>();
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            shrList = this.easService.getPermessionArrayExt(context, NodeTypeEnum.EXTERNAL_LINK_SHR, false);
            PortalCache.setSHRWebListPerm(ctx, shrList);
            String userId = ctx.getLoginUser().getId();
            this.portalCacheFlagService.updateSHRCacheFlag(ctx, userId, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                throw new PortalBizException("215", e);
            }
            catch (PortalBizException portalBizException) {
                // empty catch block
            }
        }
        return shrList;
    }

    @Override
    public List<CuInfoDTO> getCuF7List(Context ctx, String pId) throws Exception {
        ArrayList<CuInfoDTO> cuList = new ArrayList<CuInfoDTO>();
        CtrlUnitCollection cc = null;
        cc = StringUtil.isEmpty((String)pId) ? CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection("where level = 1 and parent is null") : CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection("where parent='" + pId + "'");
        for (int i = 0; i < cc.size(); ++i) {
            CtrlUnitInfo ui = cc.get(i);
            CuInfoDTO cu = new CuInfoDTO();
            cu.setId(ui.getId().toString());
            cu.setName(ui.getName());
            cu.setDisplayname(ui.getDisplayName());
            cu.setIsParent("true");
            cuList.add(cu);
        }
        return cuList;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    public void setEasService(EASService easService) {
        this.easService = easService;
    }

    public void setPortalCacheFlagService(PortalCacheFlagService portalCacheFlagService) {
        this.portalCacheFlagService = portalCacheFlagService;
    }
}

