/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.perm.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.facade.portal.facade.PortalCacheFacade;
import com.kingdee.portal.biz.module.perm.common.enums.PermBlackTypeEnum;
import com.kingdee.portal.biz.module.perm.dao.BlackDAO;
import com.kingdee.portal.biz.module.perm.dao.RefRoleGroupDAO;
import com.kingdee.portal.biz.module.perm.dao.RefRoleUserDAO;
import com.kingdee.portal.biz.module.perm.dao.RoleDAO;
import com.kingdee.portal.biz.module.perm.dto.GroupDTO;
import com.kingdee.portal.biz.module.perm.dto.UserDTO;
import com.kingdee.portal.biz.module.perm.entity.Black;
import com.kingdee.portal.biz.module.perm.entity.RefRoleGroup;
import com.kingdee.portal.biz.module.perm.entity.RefRoleUser;
import com.kingdee.portal.biz.module.perm.entity.Role;
import com.kingdee.portal.biz.module.perm.service.GroupService;
import com.kingdee.portal.biz.module.perm.service.RoleService;
import com.kingdee.portal.biz.module.perm.service.UserService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class RoleServiceImpl
implements RoleService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RoleDAO roleDAO;
    private RefRoleUserDAO refRoleUserDAO;
    private RefRoleGroupDAO refRoleGroupDAO;
    private BlackDAO blackDAO;
    private UserService userService;
    private GroupService groupService;

    public void setRoleDAO(RoleDAO roleDAO) {
        this.roleDAO = roleDAO;
    }

    public void setRefRoleUserDAO(RefRoleUserDAO refRoleUserDAO) {
        this.refRoleUserDAO = refRoleUserDAO;
    }

    public void setRefRoleGroupDAO(RefRoleGroupDAO refRoleGroupDAO) {
        this.refRoleGroupDAO = refRoleGroupDAO;
    }

    public void setBlackDAO(BlackDAO blackDAO) {
        this.blackDAO = blackDAO;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setGroupService(GroupService groupService) {
        this.groupService = groupService;
    }

    @Override
    public Role createRole(PortalContext ctx, Role role) throws PortalBizException {
        role.setPortalContext(ctx);
        role.setResLevel(ResLevelEnum.EXT);
        try {
            return this.roleDAO.create(role);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("701", e);
        }
    }

    @Override
    public Role updateRole(PortalContext ctx, Role role) throws PortalBizException {
        try {
            Role ori = (Role)this.roleDAO.findById(role.getId());
            ori.setName(role.getName());
            ori.setDescription(role.getDescription());
            return this.roleDAO.update(ori);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("703", e);
        }
    }

    @Override
    public void deleteRoleById(PortalContext ctx, String roleId) throws PortalBizException {
        try {
            this.roleDAO.deleteById(roleId);
            this.deleteRelatedRef(ctx, roleId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("704", e);
        }
    }

    private void deleteRelatedRef(PortalContext ctx, String roleId) throws DataAccessException {
        this.deleteRefRoleUser(ctx, roleId);
        this.deleteRefRoleGroup(ctx, roleId);
    }

    private void deleteRefRoleUser(PortalContext ctx, String roleId) throws DataAccessException {
        this.refRoleUserDAO.deleteRefRoleUserByRoleId(roleId);
        this.updateCacheFlag(ctx);
    }

    private void updateCacheFlag(PortalContext ctx) {
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            PortalCacheFacade.updateCacheFlag(context, "FPageFlag");
        }
        catch (Exception e) {
            this.logger.error("batchCreatePermRefRes updateCacheFlag error ==", (Throwable)e);
        }
    }

    private void deleteRefRoleGroup(PortalContext ctx, String roleId) throws DataAccessException {
        this.refRoleGroupDAO.deleteRefRoleGroupByRoleId(roleId);
        this.updateCacheFlag(ctx);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<Role> findRoleList(PortalContext ctx, PagingParam pagingParam, String name) throws PortalBizException {
        try {
            return this.roleDAO.findList(new Role(), pagingParam, this.getWildcardNameFilter(ctx, name), new OrderFilter("createTime", OrderEnum.DESC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("702", e);
        }
    }

    private Filter getWildcardNameFilter(PortalContext ctx, String name) {
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        String locale = ctx.getLocale().toString();
        return new FieldFilter("name", "like", this.getLocalWildcardName(name, locale));
    }

    private String getLocalWildcardName(String name, String locale) {
        return "%\"" + locale + "\":\"%" + name + "%\"%";
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Role findRoleById(PortalContext ctx, String roleId) throws PortalBizException {
        try {
            return (Role)this.roleDAO.findById(roleId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("702", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, Object> findRoleMember(PortalContext ctx, String roleId) throws PortalBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            map.put("userList", this.getRefUserList(ctx, roleId));
            map.put("groupList", this.getRefGroupList(ctx, roleId));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return map;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<UserDTO> getRefUserList(PortalContext ctx, String roleId) throws DataAccessException, PortalBizException {
        RefRoleUser entity = new RefRoleUser();
        entity.setRoleId(roleId);
        List<RefRoleUser> refUserList = this.refRoleUserDAO.findList(entity, new Filter[0]);
        return this.getUserInfoList(ctx, this.getUserIdArr(refUserList));
    }

    private String[] getUserIdArr(List<RefRoleUser> refUserList) {
        ArrayList<String> userIdArr = new ArrayList<String>();
        for (RefRoleUser refUser : refUserList) {
            userIdArr.add(refUser.getUserId());
        }
        return userIdArr.toArray(new String[0]);
    }

    private List<UserDTO> getUserInfoList(PortalContext ctx, String[] userIdArr) throws PortalBizException {
        if (userIdArr.length <= 0) {
            return new ArrayList<UserDTO>();
        }
        return this.userService.findUserListByIds(ctx, userIdArr);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<GroupDTO> getRefGroupList(PortalContext ctx, String roleId) throws DataAccessException, PortalBizException {
        RefRoleGroup group = new RefRoleGroup();
        group.setRoleId(roleId);
        List<RefRoleGroup> refGroupList = this.refRoleGroupDAO.findList(group, new Filter[0]);
        return this.getGroupInfoList(ctx, this.getGroupIdArr(refGroupList));
    }

    private String[] getGroupIdArr(List<RefRoleGroup> refGroupList) {
        ArrayList<String> groupIdArr = new ArrayList<String>();
        for (RefRoleGroup group : refGroupList) {
            groupIdArr.add(group.getGroupId());
        }
        return groupIdArr.toArray(new String[0]);
    }

    private List<GroupDTO> getGroupInfoList(PortalContext ctx, String[] groupIdArr) throws PortalBizException {
        if (groupIdArr.length <= 0) {
            return new ArrayList<GroupDTO>();
        }
        return this.groupService.findGroupListByIds(ctx, groupIdArr);
    }

    @Override
    public void createRefRoleUser(PortalContext ctx, String roleId, String[] userIds) throws PortalBizException {
        RefRoleUser refRoleUser = null;
        for (String userId : userIds) {
            refRoleUser = new RefRoleUser();
            refRoleUser.setRoleId(roleId);
            refRoleUser.setUserId(userId);
            refRoleUser.setPortalContext(ctx);
            try {
                this.refRoleUserDAO.create(refRoleUser);
                this.updateCacheFlag(ctx);
            }
            catch (DataAccessException e) {
                throw new PortalBizException("\u521b\u5efa\u89d2\u8272\u5173\u8054\u7528\u6237\u5931\u8d25");
            }
        }
    }

    @Override
    public void deleteRefRoleUser(PortalContext ctx, String roleId, String[] userIds) throws PortalBizException {
        try {
            this.refRoleUserDAO.deleteRefRoleUser(roleId, userIds);
            this.updateCacheFlag(ctx);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u5220\u9664\u89d2\u8272\u5173\u8054\u7528\u6237\u5931\u8d25");
        }
    }

    @Override
    public void createRefRoleGroup(PortalContext ctx, String roleId, String[] groupIds) throws PortalBizException {
        RefRoleGroup group = null;
        for (String groupId : groupIds) {
            group = new RefRoleGroup();
            group.setRoleId(roleId);
            group.setGroupId(groupId);
            group.setPortalContext(ctx);
            try {
                this.refRoleGroupDAO.create(group);
                this.updateCacheFlag(ctx);
            }
            catch (DataAccessException e) {
                throw new PortalBizException("\u521b\u5efa\u89d2\u8272\u5173\u8054\u7ec4\u7ec7\u5931\u8d25");
            }
        }
    }

    @Override
    public void deleteRefRoleGroup(PortalContext ctx, String roleId, String[] groupIds) throws PortalBizException {
        try {
            this.refRoleGroupDAO.deleteRefRoleGroup(roleId, groupIds);
            this.updateCacheFlag(ctx);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u5220\u9664\u89d2\u8272\u5173\u8054\u7ec4\u7ec7\u5931\u8d25");
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Black> findBlackListByIds(PortalContext ctx, String[] roleIds) throws PortalBizException {
        try {
            return this.blackDAO.findBlackListByIds(ctx, roleIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u83b7\u53d6\u89d2\u8272\u9ed1\u540d\u5355\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, Object> findBlackList(PortalContext ctx, String roleId) throws PortalBizException {
        try {
            return this.getBlackList(ctx, roleId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u83b7\u53d6\u89d2\u8272\u9ed1\u540d\u5355\u6570\u636e\u5931\u8d25");
        }
    }

    private Map<String, Object> getBlackList(PortalContext ctx, String roleId) throws DataAccessException, PortalBizException {
        Black black = new Black();
        black.setResId(roleId);
        List<Black> blackList = this.blackDAO.findList(black, new Filter[0]);
        return this.buildBlackList(ctx, blackList);
    }

    private Map<String, Object> buildBlackList(PortalContext ctx, List<Black> blackList) throws PortalBizException {
        ArrayList<String> userIdArr = new ArrayList<String>();
        ArrayList<String> groupIdArr = new ArrayList<String>();
        for (Black b : blackList) {
            if (b.getBlackType() == PermBlackTypeEnum.ROLE_BLACK_USER) {
                userIdArr.add(b.getBlackId());
            }
            if (b.getBlackType() != PermBlackTypeEnum.ROLE_BLACK_GROUP) continue;
            groupIdArr.add(b.getBlackId());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userList", this.getUserInfoList(ctx, userIdArr.toArray(new String[0])));
        map.put("groupList", this.getGroupInfoList(ctx, groupIdArr.toArray(new String[0])));
        return map;
    }

    @Override
    public void createBlack(PortalContext ctx, String roleId, String[] blackIds, PermBlackTypeEnum blackType) throws PortalBizException {
        Black black = null;
        for (String blackId : blackIds) {
            black = new Black();
            black.setBlackId(blackId);
            black.setBlackType(blackType);
            black.setResId(roleId);
            black.setPortalContext(ctx);
            try {
                this.blackDAO.create(black);
            }
            catch (DataAccessException e) {
                throw new PortalBizException("\u521b\u5efa\u89d2\u8272\u5173\u8054\u7ec4\u7ec7\u5931\u8d25");
            }
        }
    }

    @Override
    public void deleteBlack(PortalContext ctx, String roleId, String[] blackIds) throws PortalBizException {
        try {
            this.blackDAO.deleteBlack(roleId, blackIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u5220\u9664\u89d2\u8272\u9ed1\u540d\u5355\u6570\u636e\u5931\u8d25");
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean isAdminRole(PortalContext ctx, String userId) throws PortalBizException {
        RefRoleUser refUser = new RefRoleUser();
        refUser.setUserId(userId);
        refUser.setRoleId("745bd3fd-6974-4216-ab95-29a17e16bd0d");
        RefRoleUser ref = null;
        try {
            ref = this.refRoleUserDAO.findObject(refUser, new Filter[0]);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u5224\u65ad\u662f\u5426\u7ba1\u7406\u5458\u89d2\u8272\u5931\u8d25");
        }
        return ref != null;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<Role> findRoleByIds(PortalContext ctx, String[] ids) throws PortalBizException {
        try {
            return this.roleDAO.findRoleByIds(ids);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<RefRoleUser> findRoleByUserId(PortalContext ctx, String userId) throws PortalBizException {
        try {
            return this.refRoleUserDAO.findList(new FieldFilter("userId", "=", userId));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<RefRoleGroup> findRoleByOrgIds(PortalContext ctx, String[] ids) throws PortalBizException {
        try {
            List<RefRoleGroup> roleList;
            int totalLength = ids.length;
            int subLength = 990;
            this.logger.error("totalLength===============" + totalLength);
            if (totalLength < subLength) {
                roleList = this.refRoleGroupDAO.findRoleByOrgIds(ids);
            } else {
                int findDbCount = (int)Math.floor(totalLength / subLength);
                roleList = new ArrayList<RefRoleGroup>();
                for (int i = 0; i < findDbCount; ++i) {
                    int firstCount = i * subLength;
                    String[] findIds = new String[subLength];
                    for (int j = 0; j < subLength; ++j) {
                        findIds[j] = ids[j + firstCount];
                    }
                    this.logger.error("findIds.length===============" + findIds.length);
                    List<RefRoleGroup> list = this.refRoleGroupDAO.findRoleByOrgIds(findIds);
                    if (list == null) continue;
                    for (int k = 0; k < list.size(); ++k) {
                        roleList.add(list.get(k));
                    }
                }
                if (findDbCount * subLength < totalLength) {
                    String[] findIds = new String[totalLength - findDbCount * subLength];
                    for (int z = 0; z < findIds.length; ++z) {
                        findIds[z] = ids[z + findDbCount * subLength];
                    }
                    List<RefRoleGroup> list = this.refRoleGroupDAO.findRoleByOrgIds(findIds);
                    if (list != null) {
                        for (int k = 0; k < list.size(); ++k) {
                            roleList.add(list.get(k));
                        }
                    }
                }
            }
            return roleList;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }
}

