/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.personal.dao.PersonalCountClickDAO;
import com.kingdee.portal.biz.module.personal.entity.PersonalCountClick;
import com.kingdee.portal.biz.module.personal.service.PersonalCountClickService;
import com.kingdee.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
@Service
public class PersonalCountClickServiceImpl
implements PersonalCountClickService {
    @Autowired
    PersonalCountClickDAO personalCountClickDAO;

    @Override
    public PersonalCountClick findClickByUserIdOrgId(String userId, String id) throws DataAccessException {
        List list = this.personalCountClickDAO.findList(new Filter[]{new FieldFilter("userId", "=", userId), new FieldFilter("comFunctionId", "=", id)});
        if (list != null && list.size() > 0) {
            return (PersonalCountClick)list.get(0);
        }
        return null;
    }

    @Override
    public void savePersonalCountClick(String userId, String id) throws DataAccessException {
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)id)) {
            return;
        }
        PersonalCountClick oldClick = this.findClickByUserIdOrgId(userId, id);
        if (oldClick == null || oldClick.getId() == null) {
            PersonalCountClick newClick = new PersonalCountClick();
            newClick.setHits(1);
            newClick.setUserId(userId);
            newClick.setComFunctionId(id);
            this.personalCountClickDAO.create(newClick);
        } else {
            oldClick.setHits(oldClick.getHits() + 1);
            this.personalCountClickDAO.update(oldClick);
        }
    }
}

