/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.myeas.ComMenuFunctionInfo;
import com.kingdee.eas.base.permission.IMainMenuItem;
import com.kingdee.eas.base.permission.MainMenuItemFactory;
import com.kingdee.eas.base.permission.MainMenuItemInfo;
import com.kingdee.eas.base.uiframe.IMyComFunctionFacade;
import com.kingdee.eas.base.uiframe.MainFunctionMenuFactory;
import com.kingdee.eas.base.uiframe.MyComFunctionFacadeFactory;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.GuiPreferences;
import com.kingdee.portal.biz.module.page.common.json.LinkNodeExt;
import com.kingdee.portal.biz.module.page.common.json.PageNodeExt;
import com.kingdee.portal.biz.module.page.dao.OpenedPageRecentlyDAO;
import com.kingdee.portal.biz.module.page.dto.MenuItemInfo;
import com.kingdee.portal.biz.module.page.entity.OpenedPageRecently;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.personal.dao.PersonalCountClickDAO;
import com.kingdee.portal.biz.module.personal.dao.PersonalFavoriteDAO;
import com.kingdee.portal.biz.module.personal.dto.PersonalCountClickDTO;
import com.kingdee.portal.biz.module.personal.dto.PersonalFavoriteDTO;
import com.kingdee.portal.biz.module.personal.entity.PersonalCountClick;
import com.kingdee.portal.biz.module.personal.entity.PersonalFavorite;
import com.kingdee.portal.biz.module.personal.service.PersonalFavoriteService;
import com.kingdee.portal.biz.module.personal.service.PresetService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PersonalFavoriteServiceImpl
implements PersonalFavoriteService {
    private PersonalFavoriteDAO personalFavoriteDAO;
    private OpenedPageRecentlyDAO openedPageRecentlyDAO;
    private PageService pageService;
    private PermService permService;
    private EASService easService;
    private PresetService presetService;
    @Autowired
    private PersonalCountClickDAO personalCountClickDAO;
    private static final Logger logger = LoggerFactory.getLogger(PersonalFavoriteServiceImpl.class);

    @Override
    public List<PersonalFavoriteDTO> findPersonalFavoriteList(PortalContext ctx, Map<String, Object> permMap) throws PortalBizException {
        return PortalCache.getFavoriteList(ctx);
    }

    @Override
    public List<PersonalFavoriteDTO> findFavoriteListFromDB(PortalContext ctx) throws PortalBizException {
        List<PersonalFavoriteDTO> dtoList = null;
        try {
            List<PersonalFavorite> list = this.getPersonalFavoriteList(ctx.getLoginUser().getId());
            Map<String, String[]> resMap = this.getFavoriteResMap(ctx, list, null);
            dtoList = this.buildPersonalFavoriteList(list, resMap);
            PortalCache.setFavoriteList(ctx, dtoList);
        }
        catch (Exception e) {
            throw new PortalBizException("602", e);
        }
        return dtoList;
    }

    private NodeTypeEnum getNodeTypeEnum(String nodeType) {
        if ("PAGE".equals(nodeType)) {
            return NodeTypeEnum.PAGE;
        }
        if ("EXTERNAL_LINK".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK;
        }
        if ("EXTERNAL_LINK_G".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_G;
        }
        if ("EXTERNAL_LINK_OA".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_OA;
        }
        if ("LINK".equals(nodeType)) {
            return NodeTypeEnum.LINK;
        }
        return null;
    }

    private List<PersonalFavorite> getPersonalFavoriteList(String userId) throws DataAccessException {
        PersonalFavorite fav = new PersonalFavorite();
        fav.setUserId(userId);
        fav.setIsLeaf(true);
        return this.personalFavoriteDAO.findList(fav, new OrderFilter("orderNum", OrderEnum.ASC));
    }

    private Map<String, String[]> getFavoriteResMap(PortalContext ctx, List<PersonalFavorite> list, Map<String, Object> permMap) throws PortalBizException {
        List<Page> pages = this.pageService.findFavPageList(ctx);
        List<Page> pageList = this.permService.selectPermPageList(ctx, pages, permMap, ctx.getLoginUser().getId());
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        for (Page page : pageList) {
            if (!page.getStatus().toString().equals("ENABLE")) continue;
            String pageId = page.getId();
            if (NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)page.getNodeType())) {
                ELinkNodeExt ext = new ELinkNodeExt(page.getNodeExt());
                pageId = ext.getExternalId();
            }
            map.put(pageId, this.getPageInfoArray(page));
        }
        return map;
    }

    private void setGuiInfoArray(PortalContext ctx, Map<String, String[]> map, List<String> guiIds, Map<String, Object> permMap) {
        try {
            HashMap guiList = (HashMap)permMap.get("guiList");
            List<MenuItemInfo> items = this.easService.getGuiListByIds(ctx, guiIds, false);
            for (MenuItemInfo menu : items) {
                String pageId = (String)guiList.get(menu.getId());
                if (pageId == null) continue;
                String[] info = new String[]{menu.getName(), menu.getUiClassName(), "", "False", menu.getImagePath() != null ? "sys_" + menu.getImagePath() + ".png" : "", this.buildGuiPre(menu).toString()};
                map.put(menu.getId(), info);
            }
        }
        catch (PortalBizException e) {
            logger.error("\u83b7\u53d6\u5916\u90e8\u83dc\u5355\u5f02\u5e38\uff0c\u7ee7\u7eed\u629b\u51faPortal\u4e1a\u52a1\u5f02\u5e38", (Throwable)e);
            try {
                throw new PortalBizException("\u83b7\u53d6EAS\u83dc\u5355\u5931\u8d25\uff01");
            }
            catch (PortalBizException portalBizException) {
                // empty catch block
            }
        }
    }

    private GuiPreferences buildGuiPre(MenuItemInfo info) {
        GuiPreferences gp = new GuiPreferences();
        gp.setOpenMethod(info.getOpenMethod());
        gp.setUiClassParam(info.getUiClassParam());
        gp.setUiOprt(info.getUiOprt());
        return gp;
    }

    private String[] getPageInfoArray(Page page) {
        String[] infos = new String[7];
        infos[0] = page.getDisplayName();
        switch (page.getNodeType()) {
            case LINK: {
                LinkNodeExt ext = new LinkNodeExt(page.getNodeExt());
                infos[1] = ext.getUrl();
                infos[2] = this.getFixedTarget(ext.getTarget());
                infos[3] = page.getPermEditCtrl().toString();
                infos[4] = page.getIcon();
                infos[5] = page.getPreferences();
                infos[6] = page.getNodePath();
                break;
            }
            case EXTERNAL_LINK: 
            case EXTERNAL_LINK_OA: 
            case EXTERNAL_LINK_SHR: {
                ELinkNodeExt eext = new ELinkNodeExt(page.getNodeExt());
                infos[1] = eext.getUrl();
                infos[2] = this.getFixedTarget(eext.getTarget());
                infos[3] = page.getPermEditCtrl().toString();
                infos[4] = page.getIcon();
                infos[5] = page.getPreferences();
                infos[6] = page.getNodePath();
                break;
            }
            case EXTERNAL_LINK_G: {
                ELinkNodeExt en = new ELinkNodeExt(page.getNodeExt());
                infos[1] = en.getUrl();
                infos[2] = "";
                infos[3] = page.getPermEditCtrl().toString();
                infos[4] = page.getIcon();
                infos[5] = page.getPreferences();
                infos[6] = page.getNodePath();
                break;
            }
            default: {
                infos[1] = "";
                infos[2] = this.getFixedTarget(null);
                infos[3] = page.getPermEditCtrl().toString();
                infos[4] = page.getIcon();
                infos[5] = page.getPreferences();
                infos[6] = page.getNodePath();
            }
        }
        return infos;
    }

    private String getFixedTarget(String target) {
        if (target == null || "DYNAMIC_CONTENT".equals(target)) {
            return "TAB";
        }
        return target;
    }

    private List<PersonalFavoriteDTO> buildPersonalFavoriteList(List<PersonalFavorite> list, Map<String, String[]> resMap) {
        ArrayList<PersonalFavoriteDTO> dtoList = new ArrayList<PersonalFavoriteDTO>();
        PersonalFavoriteDTO dto = null;
        String[] res = null;
        ArrayList<String> pageIdList = new ArrayList<String>();
        for (PersonalFavorite fav : list) {
            String pageId = fav.getPageId();
            if (pageIdList.contains(pageId)) continue;
            pageIdList.add(pageId);
            res = resMap.get(fav.getPageId());
            if (res == null || res.length <= 0) continue;
            boolean bl = false;
            if (res[3].equals("true")) {
                bl = true;
            }
            dto = new PersonalFavoriteDTO(fav, res[0], res[1], res[2], bl, res[4], res[5], res[6]);
            dto.setIcon(res[4]);
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    public PersonalFavoriteDTO createPersonalFavorite(PortalContext ctx, PersonalFavorite fav, String spermEditCtrl) throws PortalBizException {
        PersonalFavorite fav1 = null;
        PersonalFavoriteDTO favDto = null;
        fav.setUserId(ctx.getLoginUser().getId());
        fav.setPortalContext(ctx);
        try {
            Page page = this.pageService.findPageById(ctx, fav.getPageId());
            fav1 = this.createFavoriteForPresetFav(ctx, page);
            if (fav1 == null) {
                throw new PortalBizException("604");
            }
            String url = "";
            String target = "";
            Boolean permEditCtrl = false;
            PageNodeExt nodeExt = new PageNodeExt(page.getNodeExt());
            if (nodeExt != null) {
                url = nodeExt.getUrl();
                target = nodeExt.getTarget();
            }
            if (spermEditCtrl != null && spermEditCtrl.equals("true")) {
                permEditCtrl = true;
            }
            favDto = new PersonalFavoriteDTO(fav1, page.getDisplayName(), url, target, permEditCtrl, page.getIcon(), page.getPreferences(), "");
            PortalCache.setFavoriteList(ctx, null);
        }
        catch (Exception e) {
            throw new PortalBizException("601", e);
        }
        return favDto;
    }

    @Override
    public void deletePersonalFavoriteById(PortalContext ctx, String id) throws PortalBizException {
        try {
            this.personalFavoriteDAO.deleteById(id);
            PortalCache.setFavoriteList(ctx, null);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("603", e);
        }
    }

    @Override
    public void sortPersonalFavorite(PortalContext ctx, String[] sortInfo) throws PortalBizException {
        try {
            this.updateFavOrder(sortInfo);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("601", e);
        }
    }

    private void updateFavOrder(String[] sortInfo) throws DataAccessException {
        PersonalFavorite fav = null;
        for (String info : sortInfo) {
            String[] favInfo = info.split("_");
            fav = (PersonalFavorite)this.personalFavoriteDAO.findById(favInfo[0]);
            fav.setOrderNum(Integer.valueOf(favInfo[1]));
            this.personalFavoriteDAO.update(fav);
        }
    }

    @Override
    public PersonalFavorite createFavoriteForPresetFav(PortalContext ctx, Page page) throws PortalBizException {
        PersonalFavorite fav1 = null;
        try {
            String pageId = "";
            if (NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)page.getNodeType())) {
                ELinkNodeExt ext = new ELinkNodeExt(page.getNodeExt());
                pageId = ext.getExternalId();
            } else {
                pageId = page.getId();
            }
            PersonalFavorite oldFav = this.personalFavoriteDAO.findFavByPageId(pageId, ctx.getLoginUser().getId());
            if (oldFav != null) {
                return oldFav;
            }
            MainMenuItemInfo menuInfo = new MainMenuItemInfo();
            Context ctx2 = (Context)ctx.getMetaInfo().get("eas_context");
            IMainMenuItem iMainMenuItem = MainMenuItemFactory.getLocalInstance((Context)ctx2);
            IMyComFunctionFacade iMyComFunctionFacade = MyComFunctionFacadeFactory.getLocalInstance((Context)ctx2);
            if (NodeTypeEnum.EXTERNAL_LINK_G.equals((Object)page.getNodeType())) {
                menuInfo = (MainMenuItemInfo)iMainMenuItem.getValue((IObjectPK)new ObjectStringPK(pageId));
                IObjectPK opk = MainFunctionMenuFactory.getLocalInstance((Context)ctx2).saveMenuToComFunction(menuInfo);
                fav1 = (PersonalFavorite)this.personalFavoriteDAO.findById(opk.toString());
            } else {
                PersonalFavorite fav = new PersonalFavorite();
                fav.setId(BOSUuid.create((String)"B75723F0").toString());
                String pageNumber = page.getPageNumber();
                if (pageNumber == null) {
                    pageNumber = "1";
                }
                fav.setNumber(pageNumber);
                fav.setNodePath("portal");
                ComMenuFunctionInfo parentComMenu = iMyComFunctionFacade.getFunctionRoot();
                fav.setIsLeaf(true);
                fav.setFavLevel(2);
                fav.setPortalContext(ctx);
                fav.setUserId(ctx.getLoginUser().getId());
                fav.setPageId(pageId);
                fav.setPageType(page.getNodeType());
                fav.setFavExtInfo("");
                fav.setOrderNum(iMyComFunctionFacade.getChildMaxOrder(parentComMenu.getId().toString()) + 1);
                fav1 = this.personalFavoriteDAO.create(fav);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return fav1;
    }

    @Override
    public Map<String, Object> findFavMapForTopFav(PortalContext ctx, Map<String, Object> permMap) throws PortalBizException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List<PersonalFavoriteDTO> favList = this.findPersonalFavoriteList(ctx, permMap);
            List<Page> pageList = this.pageService.findAppSecondPageList(ctx);
            ArrayList<Page> secondList = new ArrayList<Page>();
            if (pageList != null) {
                for (Page page : pageList) {
                    ArrayList<PersonalFavoriteDTO> tempList = new ArrayList<PersonalFavoriteDTO>();
                    for (PersonalFavoriteDTO favDto : favList) {
                        if (favDto.getNodePath().indexOf(page.getId()) <= 0) continue;
                        tempList.add(favDto);
                        favDto.setHasFind(true);
                    }
                    if (tempList.size() <= 0) continue;
                    map.put(page.getId(), tempList);
                    secondList.add(page);
                }
                ArrayList<PersonalFavoriteDTO> otherList = new ArrayList<PersonalFavoriteDTO>();
                for (PersonalFavoriteDTO favDto : favList) {
                    if (favDto.isHasFind()) continue;
                    otherList.add(favDto);
                }
                if (otherList.size() > 0) {
                    map.put("other", otherList);
                    Page page = new Page();
                    page.setDisplayName(this.setDisplayName());
                    page.setId("other");
                    secondList.add(page);
                }
            }
            map.put("secondList", secondList);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return map;
    }

    @Override
    public Map<String, Object> findFavForTopFav(PortalContext ctx, Context ct, String userId, Map<String, Object> permMap) throws PortalBizException {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List<PersonalCountClick> findList = this.personalCountClickDAO.findFavByHits(ct, userId);
            List<PersonalFavoriteDTO> favList = this.findPersonalFavoriteList(ctx, permMap);
            ArrayList<Object> clickDTOList = new ArrayList<Object>();
            for (PersonalFavoriteDTO favDto : favList) {
                String nodePath = favDto.getNodePath();
                PersonalCountClickDTO clickDTO = new PersonalCountClickDTO();
                clickDTO.setFavorite(favDto.getFavorite());
                clickDTO.setHasFind(favDto.isHasFind());
                clickDTO.setName(favDto.getName());
                clickDTO.setPermEditCtrl(favDto.getPermEditCtrl());
                clickDTO.setPreferences(favDto.getPreferences());
                clickDTO.setTarget(favDto.getTarget());
                clickDTO.setUrl(favDto.getUrl());
                clickDTO.setNodePath(nodePath);
                PersonalCountClick newClick = new PersonalCountClick();
                newClick.setComFunctionId(favDto.getFavorite().getPageId());
                newClick.setUserId(favDto.getFavorite().getUserId());
                newClick.setHits(0);
                clickDTO.setClick(newClick);
                clickDTOList.add(clickDTO);
            }
            for (PersonalCountClick click : findList) {
                String comFunctionId = click.getComFunctionId();
                for (PersonalFavoriteDTO favDto : favList) {
                    String menuFunctionId = favDto.getFavorite().getPageId();
                    if (!comFunctionId.equals(menuFunctionId)) continue;
                    for (PersonalCountClickDTO personalCountClickDTO : clickDTOList) {
                        if (!personalCountClickDTO.getClick().getComFunctionId().equals(comFunctionId)) continue;
                        personalCountClickDTO.getClick().setHits(click.getHits());
                    }
                }
            }
            List<Page> pageList = this.pageService.findAppSecondPageList(ctx);
            ArrayList<Page> secondList = new ArrayList<Page>();
            if (pageList != null) {
                for (Page page : pageList) {
                    ArrayList<PersonalCountClickDTO> tempList = new ArrayList<PersonalCountClickDTO>();
                    for (PersonalCountClickDTO personalCountClickDTO : clickDTOList) {
                        if (personalCountClickDTO.getNodePath().indexOf(page.getId()) <= 0) continue;
                        tempList.add(personalCountClickDTO);
                        personalCountClickDTO.setHasFind(true);
                    }
                    if (tempList.size() <= 0) continue;
                    map.put(page.getId(), tempList);
                    secondList.add(page);
                }
            }
            for (Page value : map.values()) {
                List valList = (List)((Object)value);
                Collections.sort(valList, new Comparator<PersonalCountClickDTO>(){

                    @Override
                    public int compare(PersonalCountClickDTO A, PersonalCountClickDTO B) {
                        return B.getClick().getHits() - A.getClick().getHits();
                    }
                });
            }
            Collections.sort(secondList, new Comparator<Page>(){

                @Override
                public int compare(Page A, Page B) {
                    List list1 = (List)map.get(A.getId());
                    List list2 = (List)map.get(B.getId());
                    return ((PersonalCountClickDTO)list2.get(0)).getClick().getHits() - ((PersonalCountClickDTO)list1.get(0)).getClick().getHits();
                }
            });
            map.put("secondList", secondList);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return map;
    }

    private String setDisplayName() {
        DisplayName dn = new DisplayName();
        dn.setEn("Other");
        dn.setZh_CN("\u5176\u5b83");
        dn.setZh_TW("\u5176\u5b83");
        return dn.toString();
    }

    public void setPermService(PermService permService) {
        this.permService = permService;
    }

    public void setPersonalFavoriteDAO(PersonalFavoriteDAO personalFavoriteDAO) {
        this.personalFavoriteDAO = personalFavoriteDAO;
    }

    public OpenedPageRecentlyDAO getOpenedPageRecentlyDAO() {
        return this.openedPageRecentlyDAO;
    }

    public void setOpenedPageRecentlyDAO(OpenedPageRecentlyDAO openedPageRecentlyDAO) {
        this.openedPageRecentlyDAO = openedPageRecentlyDAO;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public void setEasService(EASService easService) {
        this.easService = easService;
    }

    public void setPresetService(PresetService presetService) {
        this.presetService = presetService;
    }

    @Override
    public String[] findOpenedPagesRecently(Context context, String userId) {
        String[] pageIdArray = new String[]{};
        try {
            pageIdArray = this.openedPageRecentlyDAO.findPageIdArray(context, userId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pageIdArray;
    }

    @Override
    public void updateOpenedPagesRecently(PortalContext portalContext, Context context, String userId, String pageId) {
        try {
            OpenedPageRecently entity = new OpenedPageRecently();
            entity.setUserId(userId);
            entity.setPageIdRecently(pageId);
            OpenedPageRecently findObject = this.openedPageRecentlyDAO.findObject(entity, new Filter[0]);
            if (findObject == null) {
                entity.setPortalContext(portalContext);
                this.openedPageRecentlyDAO.create(entity);
            } else {
                Timestamp lastUpdateTime = new Timestamp(new Date().getTime());
                findObject.setLastUpdateTime(lastUpdateTime);
                findObject.setPortalContext(portalContext);
                OpenedPageRecently openedPageRecently = this.openedPageRecentlyDAO.update(findObject);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }
}

