/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.personal.dao.PersonalProfileDAO;
import com.kingdee.portal.biz.module.personal.entity.PersonalProfile;
import com.kingdee.portal.biz.module.personal.service.PersonalProfileService;
import com.kingdee.portal.biz.module.pub.service.PubFileService;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PersonalProfileServiceImpl
implements PersonalProfileService {
    private PersonalProfileDAO personalProfileDAO;
    private PubFileService pubFileService;

    @Override
    public void createPersonalProfile(PortalContext portalContext, PersonalProfile personalProfile) throws PortalBizException {
        try {
            personalProfile.setUserId(portalContext.getLoginUser().getId());
            personalProfile.setPortalContext(portalContext);
            this.personalProfileDAO.create(personalProfile);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    public void deletePersonalProfileById(PortalContext portalContext, String id) throws PortalBizException {
        try {
            this.personalProfileDAO.deleteById(id);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    public void updatePersonalProfileById(PortalContext portalContext, PersonalProfile personalProfile) throws PortalBizException {
        try {
            PersonalProfile temp = (PersonalProfile)this.personalProfileDAO.findById(personalProfile.getId());
            temp.setConfigItem(personalProfile.getConfigItem());
            temp.setConfigValue(personalProfile.getConfigValue());
            temp.setPortalContext(portalContext);
            this.personalProfileDAO.update(temp);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    public void savePersonalProfile(PortalContext portalContext, String configItem, String configValue) throws PortalBizException {
        try {
            PersonalProfile personalProfile = new PersonalProfile();
            personalProfile.setConfigItem(configItem);
            personalProfile.setUserId(portalContext.getLoginUser().getId());
            PersonalProfile personalProfile4DB = this.personalProfileDAO.findObject(personalProfile, new Filter[0]);
            if (personalProfile4DB == null) {
                personalProfile.setPortalContext(portalContext);
                personalProfile.setConfigValue(configValue);
                this.personalProfileDAO.create(personalProfile);
            } else {
                personalProfile4DB.setConfigValue(configValue);
                personalProfile4DB.setPortalContext(portalContext);
                this.personalProfileDAO.update(personalProfile4DB);
            }
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    public void savePersonalProfile4UserLogo(PortalContext portalContext, String configValue) throws PortalBizException {
        String configItem = "login_user_logo";
        try {
            PersonalProfile personalProfile = new PersonalProfile();
            personalProfile.setConfigItem(configItem);
            personalProfile.setUserId(portalContext.getLoginUser().getId());
            PersonalProfile temp = this.personalProfileDAO.findObject(personalProfile, new Filter[0]);
            if (temp == null) {
                personalProfile.setPortalContext(portalContext);
                personalProfile.setConfigValue(configValue);
                this.personalProfileDAO.create(personalProfile);
            } else {
                String oldUserLogoId = temp.getConfigValue();
                this.pubFileService.deletePubFileById(portalContext, oldUserLogoId);
                temp.setConfigValue(configValue);
                temp.setPortalContext(portalContext);
                this.personalProfileDAO.update(temp);
            }
        }
        catch (Exception ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PersonalProfile findPersonalProfile(PortalContext portalContext, PersonalProfile personalProfile) throws PortalBizException {
        try {
            return this.personalProfileDAO.findObject(personalProfile, new Filter[0]);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PersonalProfile findLoginUserLogo(PortalContext portalContext) throws PortalBizException {
        try {
            PersonalProfile personalProfile = new PersonalProfile();
            personalProfile.setUserId(portalContext.getLoginUser().getId());
            personalProfile.setConfigItem("login_user_logo");
            return this.personalProfileDAO.findObject(personalProfile, new Filter[0]);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    @Override
    public String findOrgDisplayNameByPosition(PortalContext portalContext) throws PortalBizException {
        try {
            return this.personalProfileDAO.findOrgDisplayNameByPosition(portalContext);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("002", ex);
        }
    }

    public PersonalProfileDAO getPersonalProfileDAO() {
        return this.personalProfileDAO;
    }

    public void setPersonalProfileDAO(PersonalProfileDAO personalProfileDAO) {
        this.personalProfileDAO = personalProfileDAO;
    }

    public PubFileService getPubFileService() {
        return this.pubFileService;
    }

    public void setPubFileService(PubFileService pubFileService) {
        this.pubFileService = pubFileService;
    }
}

