/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.personal.dao.AddedPageListDAO;
import com.kingdee.portal.biz.module.personal.dao.PresetFavPageListDAO;
import com.kingdee.portal.biz.module.personal.entity.PresetFavPageList;
import com.kingdee.portal.biz.module.personal.service.PresetFavPageListService;
import com.kingdee.portal.biz.module.pub.dto.AddedPageDTO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PresetFavPageListServiceImpl
implements PresetFavPageListService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PresetFavPageListDAO presetFavPageListDAO;
    private AddedPageListDAO addedPageListDAO;

    @Override
    public void savePresetFavPageList(PortalContext ctx, String pid, List<PresetFavPageList> pageList) throws PortalBizException {
        try {
            this.presetFavPageListDAO.deletePresetFavPageList(ctx, pid);
            this.presetFavPageListDAO.create(pageList);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException(e.getMessage());
        }
    }

    @Override
    public List<AddedPageDTO> findPresetFavPageList(PortalContext ctx, String presetId) throws PortalBizException {
        try {
            return this.addedPageListDAO.findPresetFavPageList(ctx, presetId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("308", e);
        }
    }

    public void setPresetFavPageListDAO(PresetFavPageListDAO presetFavPageListDAO) {
        this.presetFavPageListDAO = presetFavPageListDAO;
    }

    public void setAddedPageListDAO(AddedPageListDAO addedPageListDAO) {
        this.addedPageListDAO = addedPageListDAO;
    }
}

