/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.entity.Role;
import com.kingdee.portal.biz.module.perm.service.RoleService;
import com.kingdee.portal.biz.module.personal.dao.PresetFavDAO;
import com.kingdee.portal.biz.module.personal.dto.PresetInfoDTO;
import com.kingdee.portal.biz.module.personal.entity.PresetFav;
import com.kingdee.portal.biz.module.personal.entity.PresetFavPageList;
import com.kingdee.portal.biz.module.personal.entity.PresetUpdate;
import com.kingdee.portal.biz.module.personal.service.PersonalFavoriteService;
import com.kingdee.portal.biz.module.personal.service.PresetFavPageListService;
import com.kingdee.portal.biz.module.personal.service.PresetService;
import com.kingdee.portal.biz.module.personal.service.PresetUpdateService;
import com.kingdee.portal.biz.module.pub.dto.AddedPageDTO;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PresetServiceImpl
implements PresetService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private RoleService roleService;
    private PageService pageService;
    private PresetFavDAO presetFavDAO;
    private PresetFavPageListService presetFavPageListService;
    private PresetUpdateService presetUpdateService;
    private PersonalFavoriteService personalFavoriteService;

    @Override
    public Map<String, Object> findPresetMap(PortalContext ctx, PresetInfoDTO presetInfoDTO) throws PortalBizException {
        HashMap<String, Object> presetMap = new HashMap<String, Object>();
        ArrayList<AddedPageDTO> addList = new ArrayList<AddedPageDTO>();
        if ("function".equals(presetInfoDTO.getPresetFav().getFavType())) {
            try {
                IRowSet rs;
                PresetFav entity = new PresetFav();
                entity.setRoleId(presetInfoDTO.getPresetFav().getRoleId());
                PresetFav pf = this.presetFavDAO.findObject(entity, new Filter[0]);
                if (pf != null && (rs = this.pageService.findPresetFavPageList(ctx, pf.getId())) != null) {
                    while (rs.next()) {
                        AddedPageDTO ap = new AddedPageDTO();
                        ap.setId(rs.getString("fid"));
                        ap.setDisplayName(this.getLocaleDisplayName(ctx, rs.getString("displayName")));
                        ap.setSourceName(this.getLocaleDisplayName(ctx, rs.getString("description")));
                        ap.setSourceId(rs.getString("sourceId"));
                        addList.add(ap);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
            presetMap.put("treeList", this.getTreeList(ctx, presetInfoDTO));
        }
        presetMap.put("addList", addList);
        return presetMap;
    }

    @Override
    public String getTreeList(PortalContext ctx, PresetInfoDTO presetInfoDTO) throws PortalBizException {
        List<Page> treeList = this.pageService.findBizTreeByPId(ctx, presetInfoDTO.getSourceId());
        return this.getJSON4BizPage(ctx, treeList, "tree");
    }

    private String getJSON4BizPage(PortalContext ctx, List<Page> pages, String getBizType) {
        JSONArray arr = new JSONArray();
        JSONObject obj = null;
        for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            obj = new JSONObject();
            obj.put((Object)"id", (Object)page.getId());
            obj.put((Object)"pId", (Object)page.getParentNodeId());
            obj.put((Object)"t", (Object)page.getNodeType().toString());
            obj.put((Object)"nodeExt", (Object)page.getNodeExt());
            obj.put((Object)"name", (Object)this.getLocaleDisplayName(ctx, page.getDisplayName()));
            obj.put((Object)"permEditCtrl", (Object)page.getPermEditCtrl());
            obj.put((Object)"pathInfo", (Object)page.getNodePath());
            if (getBizType != null && getBizType.equals("tree")) {
                obj.put((Object)"icon", (Object)this.getIconByType(page.getNodeType()));
            } else {
                obj.put((Object)"icon", (Object)page.getIcon());
            }
            obj.put((Object)"preferences", (Object)page.getPreferences());
            boolean bl = false;
            if (page.getNodeType().equals((Object)NodeTypeEnum.PAGE) || page.getNodeType().equals((Object)NodeTypeEnum.LINK) || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == true || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_G) && new ELinkNodeExt(page.getNodeExt()).getLeaf() == true || page.getNodeType().equals((Object)NodeTypeEnum.EXTERNAL_LINK_OA) && new ELinkNodeExt(page.getNodeExt()).getLeaf().booleanValue()) {
                bl = true;
            }
            obj.put((Object)"canSelect", (Object)bl);
            arr.add((Object)obj);
        }
        return arr.toString();
    }

    private String getIconByType(NodeTypeEnum t) {
        String iconName = "page.gif";
        switch (t) {
            case PAGE: {
                iconName = "page.gif";
                break;
            }
            case SPACE: 
            case BIZ_PAGE: 
            case SYS_NAV: 
            case FOLDER: {
                iconName = "folder_Open.gif";
                break;
            }
            case EXTERNAL_LINK: 
            case EXTERNAL_LINK_G: 
            case EXTERNAL_LINK_OA: {
                iconName = "icon_menu.png";
                break;
            }
            case LINK: {
                iconName = "icon_link.png";
            }
        }
        return "/portal/res/img/ui/ztree/" + iconName;
    }

    private String getLocaleDisplayName(PortalContext ctx, String displayName) {
        String locale = ctx.getLocale().toString();
        DisplayName dn = new DisplayName(displayName, locale);
        return dn.getLocaleText();
    }

    @Override
    public Map<String, Object> findRoleAndSource(PortalContext ctx, PresetInfoDTO presetInfoDTO) throws PortalBizException {
        HashMap<String, Object> presetMap = new HashMap<String, Object>();
        presetMap.put("roleList", this.getRoleList(ctx));
        if ("function".equals(presetInfoDTO.getPresetFav().getFavType())) {
            List<Page> pageList = this.pageService.findBizList4PresetFav(ctx);
            presetMap.put("sourceList", pageList);
        } else {
            try {
                Class<?> sv = Class.forName("com.kingdee.portal.plt.iservice.module.service.service.impl.ServiceDefinitionServiceImpl");
                Object obj = sv.newInstance();
                Class<?> sd = Class.forName("com.kingdee.portal.plt.iservice.module.service.dao.impl.ServiceDefinitionDAOImpl");
                Field field = sv.getDeclaredField("serviceDefinitionDAO");
                field.setAccessible(true);
                field.set(obj, sd.newInstance());
                Method method = sv.getMethod("findServiceList4Tree", PortalContext.class, String.class);
                presetMap.put("sourceList", method.invoke(obj, ctx, ""));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
            }
        }
        return presetMap;
    }

    private List<Role> getRoleList(PortalContext ctx) {
        PagingParam pagingParam = new PagingParam();
        pagingParam.setPageNo(1);
        pagingParam.setPageSize(1000);
        try {
            return this.roleService.findRoleList(ctx, pagingParam, null).getRecords();
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    @Override
    public PresetFav savePresetFav(PortalContext ctx, PresetFav pf, List<PresetFavPageList> pageList) throws PortalBizException {
        PresetFav newPf = null;
        if (pf != null) {
            try {
                if (pf.getFavType() != null && !pf.getFavType().equalsIgnoreCase("function") && !pf.getFavType().equalsIgnoreCase("service")) {
                    return null;
                }
                newPf = this.savePresetFavBasic(ctx, pf);
                boolean bl = false;
                for (PresetFavPageList pp : pageList) {
                    pp.setpFId(newPf.getId());
                    if (!pp.getIsNew().booleanValue()) continue;
                    bl = true;
                }
                this.presetFavPageListService.savePresetFavPageList(ctx, newPf.getId(), pageList);
                if (bl && "alluser".equals(pf.getActiveType())) {
                    this.presetUpdateService.updateIsNewFlag(pf.getFavType());
                }
            }
            catch (Exception e) {
                this.logger.error(e.getMessage());
                throw new PortalBizException(e.getMessage());
            }
        }
        return newPf;
    }

    private PresetFav savePresetFavBasic(PortalContext ctx, PresetFav pf) throws PortalBizException {
        try {
            PresetFav entity = new PresetFav();
            entity.setRoleId(pf.getRoleId());
            entity.setFavType(pf.getFavType());
            PresetFav oldPf = this.presetFavDAO.findObject(entity, new Filter[0]);
            if (oldPf == null) {
                pf.setPortalContext(ctx);
                return this.presetFavDAO.create(pf);
            }
            oldPf.setActiveType(pf.getActiveType());
            oldPf.setFavType(pf.getFavType());
            oldPf.setModifyType(pf.getModifyType());
            oldPf.setPortalContext(ctx);
            return this.presetFavDAO.update(oldPf);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException(e.getMessage());
        }
    }

    @Override
    public void createPresetFav(PortalContext ctx, PresetFav pf) throws PortalBizException {
    }

    @Override
    public IRowSet configPresetFav(PortalContext ctx, Map<String, Object> permMap, String favType) throws PortalBizException {
        IRowSet rs = null;
        String userId = ctx.getLoginUser().getId();
        PresetUpdate pu = this.presetUpdateService.findPresetUpdateByUserId(userId, favType);
        if (pu == null) {
            rs = this.findPageListForPresetFav(ctx, userId, "newUser", favType);
            PresetUpdate newPu = new PresetUpdate();
            newPu.setNeedUpdateFlag(false);
            newPu.setPortalContext(ctx);
            newPu.setUserId(userId);
            newPu.setFavType(favType);
            this.presetUpdateService.createPresetUpdate(newPu);
        } else if (pu.getNeedUpdateFlag().booleanValue()) {
            rs = this.findPageListForPresetFav(ctx, userId, "", favType);
            pu.setNeedUpdateFlag(false);
            this.presetUpdateService.updatePresetUpdate(pu);
        }
        try {
            if (rs != null) {
                while (rs.next()) {
                    Page page = new Page();
                    page.setNodeType(this.getNodeTypeEnum(rs.getString("FNodeType")));
                    page.setNodeExt(rs.getString("FNodeExt"));
                    page.setPageNumber(rs.getString("FPageNumber"));
                    page.setId(rs.getString("FId"));
                    this.personalFavoriteService.createFavoriteForPresetFav(ctx, page);
                }
                PortalCache.setFavoriteList(ctx, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rs;
    }

    private NodeTypeEnum getNodeTypeEnum(String nodeType) {
        if ("PAGE".equals(nodeType)) {
            return NodeTypeEnum.PAGE;
        }
        if ("EXTERNAL_LINK".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK;
        }
        if ("EXTERNAL_LINK_G".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_G;
        }
        if ("EXTERNAL_LINK_OA".equals(nodeType)) {
            return NodeTypeEnum.EXTERNAL_LINK_OA;
        }
        if ("LINK".equals(nodeType)) {
            return NodeTypeEnum.LINK;
        }
        return null;
    }

    private IRowSet findPageListForPresetFav(PortalContext ctx, String userId, String userType, String favType) throws PortalBizException {
        Context context = (Context)ctx.getMetaInfo().get("eas_context");
        StringBuilder permSql = new StringBuilder();
        StringBuilder userOrgRangeSql = new StringBuilder(100);
        StringBuilder orgBaseSql = new StringBuilder(50);
        boolean isHasUserOrgRange = false;
        try {
            String userSql = "";
            String sourceTable = "T_JP_Page";
            if ("service".equals(favType)) {
                sourceTable = "T_JP_ServiceDefinition";
            }
            userOrgRangeSql.append("SELECT DISTINCT forgid, flongnumber FROM t_pm_orgrange RANGE,t_org_admin ORG").append(" WHERE (RANGE.fuserid ='").append(userId).append("' ").append("and RANGE.ftype=20  AND org.fid = range.forgid)");
            orgBaseSql.append("select ORG.Fid,ORG.flongnumber from T_JP_PermRefRoleGroup RGROUP,").append("t_org_admin ORG where RGROUP.FGroupId=ORG.fid");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)userOrgRangeSql.toString());
            IRowSet rs2 = DbUtil.executeQuery((Context)context, (String)orgBaseSql.toString());
            StringBuilder flongnumbers = new StringBuilder();
            if (rs != null) {
                while (rs.next()) {
                    String flongnumber = rs.getString("flongnumber");
                    if (flongnumber == null) continue;
                    flongnumbers.append(flongnumber).append(",");
                }
            }
            StringBuilder Fids = new StringBuilder();
            Fids.append("''");
            if (rs2 != null) {
                while (rs2.next()) {
                    String flongnumber2 = rs2.getString("flongnumber");
                    if (flongnumber2 == null || !flongnumbers.toString().contains(flongnumber2)) continue;
                    isHasUserOrgRange = true;
                    Fids.append(",'").append(rs2.getString("Fid")).append("'");
                }
            }
            if ("".equals(userType)) {
                userSql = " and pf.FActiveType='alluser' and pfp.FIsNew=1 ";
            }
            permSql.append("select p.* from ").append(sourceTable).append(" p,T_JP_PresetFavPageList pfp,T_JP_PresetFav pf,T_JP_PermRefRoleUser ru ").append("where pf.FRoleId=ru.FRoleId and ru.FUserId='").append(userId).append("' and pf.FId=pfp.FPFId ").append(userSql).append(" and pfp.FPageId=p.FId ").append(" union all ").append(" select p.* from ").append(sourceTable).append(" p,T_JP_PresetFavPageList pfp,T_JP_PresetFav pf ").append("where pf.FRoleId = 'da276ac7-95b4-46a6-b6dd-737a2373b7e9' and pf.FId=pfp.FPFId and pfp.FPageId=p.FId");
            if (isHasUserOrgRange) {
                permSql.append(" union all ").append("select p.* from ").append(sourceTable).append(" p,T_JP_PresetFavPageList pfp,T_JP_PresetFav pf,T_JP_PermRefRoleGroup RGROUP").append(" where pf.FRoleId=RGROUP.FRoleId  and pf.FId=pfp.FPFId ").append(userSql).append(" and pfp.FPageId=p.FId AND RGROUP.FGroupId IN (").append((CharSequence)Fids).append(")");
            }
            return DbUtil.executeQuery((Context)context, (String)permSql.toString());
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public PresetFav findPresetFav(PortalContext ctx, PresetFav pf) throws PortalBizException {
        try {
            return this.presetFavDAO.findObject(pf, new Filter[0]);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public void setPresetFavDAO(PresetFavDAO presetFavDAO) {
        this.presetFavDAO = presetFavDAO;
    }

    public void setPresetFavPageListService(PresetFavPageListService presetFavPageListService) {
        this.presetFavPageListService = presetFavPageListService;
    }

    public void setPresetUpdateService(PresetUpdateService presetUpdateService) {
        this.presetUpdateService = presetUpdateService;
    }

    public void setPersonalFavoriteService(PersonalFavoriteService personalFavoriteService) {
        this.personalFavoriteService = personalFavoriteService;
    }
}

