/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.personal.dao.PresetUpdateDAO;
import com.kingdee.portal.biz.module.personal.entity.PresetUpdate;
import com.kingdee.portal.biz.module.personal.service.PresetUpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PresetUpdateServiceImpl
implements PresetUpdateService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PresetUpdateDAO presetUpdateDAO;

    @Override
    public PresetUpdate findPresetUpdateByUserId(String userId, String favType) throws PortalBizException {
        try {
            return this.presetUpdateDAO.findPresetUpdateByUserId(userId, favType);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException(e.getMessage());
        }
    }

    @Override
    public PresetUpdate createPresetUpdate(PresetUpdate pu) throws PortalBizException {
        try {
            return this.presetUpdateDAO.create(pu);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException(e.getMessage());
        }
    }

    @Override
    public PresetUpdate updatePresetUpdate(PresetUpdate pu) throws PortalBizException {
        try {
            return this.presetUpdateDAO.update(pu);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException(e.getMessage());
        }
    }

    @Override
    public void updateIsNewFlag(String favType) throws PortalBizException {
        try {
            this.presetUpdateDAO.updateIsNewFlag(favType);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException(e.getMessage());
        }
    }

    public void setPresetUpdateDAO(PresetUpdateDAO presetUpdateDAO) {
        this.presetUpdateDAO = presetUpdateDAO;
    }
}

