/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.personal.service.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.myeas.PrivacyStatementCustomFactory;
import com.kingdee.eas.base.myeas.PrivacyStatementFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.personal.dao.PrivacyStatementCustomDAO;
import com.kingdee.portal.biz.module.personal.dao.PrivacyStatementCustomNoHtmlDAO;
import com.kingdee.portal.biz.module.personal.entity.PrivacyStatementCustom;
import com.kingdee.portal.biz.module.personal.entity.PrivacyStatementCustomNoHtml;
import com.kingdee.portal.biz.module.personal.service.PrivacyStatementCustomService;
import com.kingdee.portal.common.util.StringUtil;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.springframework.transaction.annotation.Transactional;

public class PrivacyStatementCustomServiceImpl
implements PrivacyStatementCustomService {
    private PrivacyStatementCustomDAO privacyStatementCustomDAO;
    private PrivacyStatementCustomNoHtmlDAO privacyStatementCustomNoHtmlDAO;

    @Override
    @Transactional(rollbackFor={BizException.class})
    public void addPrivacyContent(PrivacyStatementCustom entity) throws DataAccessException {
        this.privacyStatementCustomDAO.create(entity);
    }

    @Override
    @Transactional(rollbackFor={BizException.class})
    public String addPrivacyContent2(PrivacyStatementCustom entity) throws DataAccessException {
        return this.privacyStatementCustomDAO.create(entity).getId();
    }

    @Override
    public void updatePrivacyHTML(Context context, String contentId, String content_) throws Exception {
        this.privacyStatementCustomDAO.updatePrivacyHTML(context, contentId, content_);
    }

    @Override
    public PrivacyStatementCustom findPrivacyContent(String id) throws DataAccessException {
        return (PrivacyStatementCustom)this.privacyStatementCustomDAO.findById(id);
    }

    @Override
    public PagingResult<PrivacyStatementCustomNoHtml> findPrivacyContentList(Context context, String numberORdisplayName) throws DataAccessException {
        PagingResult<PrivacyStatementCustomNoHtml> pagingResult = new PagingResult<PrivacyStatementCustomNoHtml>();
        try {
            IRowSet set = null;
            StringBuilder sql = new StringBuilder("SELECT a.FId,a.FNumber,a.FDisplayName,a.FStatus,a.FVersion,");
            sql.append(" a.FEnableTime,a.FDisableTime,a.FDescription,a.FCreateTime,a.FLastUpdateTime ");
            sql.append(" FROM T_MY_PrivacyStatementCustom a ");
            sql.append(" where a.FId <> 'Bjf/+yTQQsGuLPXnEjSKvTmwZE1=' ");
            if (!StringUtil.isEmpty((String)numberORdisplayName)) {
                sql.append(" and ( a.FDisplayName like '%" + numberORdisplayName + "%' or a.FNumber like '%" + numberORdisplayName + "%' )");
            }
            sql.append(" ORDER BY a.FENableTime DESC,a.FNumber ");
            set = DbUtil.executeQuery((Context)context, (String)sql.toString());
            PrivacyStatementCustomNoHtml pscHtml = null;
            ArrayList<PrivacyStatementCustomNoHtml> newRecords = new ArrayList<PrivacyStatementCustomNoHtml>();
            String aOnclik = "<a href='javascript:;'>";
            int i = 0;
            while (set.next()) {
                aOnclik = "<a href=\"javascript:;\" onclick=\"viewPrivacy('" + set.getString("FId") + "');\">";
                pscHtml = new PrivacyStatementCustomNoHtml();
                pscHtml.setId(set.getString("FId"));
                pscHtml.setNumber(aOnclik + set.getString("FNumber") + "</a>");
                pscHtml.setDisplayName(aOnclik + set.getString("FDisplayName") + "</a>");
                pscHtml.setStatus(set.getString("FStatus"));
                pscHtml.setVersion(set.getString("FVersion"));
                pscHtml.setEnableTime(this.strToTimeStamp(set.getString("FEnableTime")));
                pscHtml.setDisableTime(this.strToTimeStamp(set.getString("FDisableTime")));
                pscHtml.setDescription(set.getString("FDescription"));
                pscHtml.setCreateTime(this.strToTimeStamp(set.getString("FCreateTime")));
                pscHtml.setLastUpdateTime(this.strToTimeStamp(set.getString("FLastUpdateTime")));
                newRecords.add(pscHtml);
                ++i;
            }
            pagingResult.setPagingParam(new PagingParam(1));
            pagingResult.setTotalCount(i);
            pagingResult.setRecords(newRecords);
        }
        catch (Exception ex) {
            throw new DataAccessException(ex.getCause());
        }
        return pagingResult;
    }

    private Timestamp strToTimeStamp(String strTime) {
        try {
            Timestamp strTimeStamp = Timestamp.valueOf(strTime);
            return strTimeStamp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Timestamp.valueOf("1970-01-01 00:00:00");
        }
    }

    public void setPrivacyStatementCustomDAO(PrivacyStatementCustomDAO privacyStatementCustomDAO) {
        this.privacyStatementCustomDAO = privacyStatementCustomDAO;
    }

    @Override
    public PrivacyStatementCustom findPrivacyContent(String number, String version) throws DataAccessException {
        PrivacyStatementCustom entity = new PrivacyStatementCustom();
        entity.setNumber(number);
        entity.setVersion(version);
        return this.privacyStatementCustomDAO.findObject(entity, new Filter[0]);
    }

    public PrivacyStatementCustomNoHtmlDAO getPrivacyStatementCustomNoHtmlDAO() {
        return this.privacyStatementCustomNoHtmlDAO;
    }

    public void setPrivacyStatementCustomNoHtmlDAO(PrivacyStatementCustomNoHtmlDAO privacyStatementCustomNoHtmlDAO) {
        this.privacyStatementCustomNoHtmlDAO = privacyStatementCustomNoHtmlDAO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePrivacyContent(PrivacyStatementCustom entity) throws DataAccessException {
        PrivacyStatementCustom data = (PrivacyStatementCustom)this.privacyStatementCustomDAO.findById(entity.getId());
        data = this.getUpdateEditEntity(data, entity);
        this.privacyStatementCustomDAO.update(data);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void iterationPrivacyContent(PrivacyStatementCustom entity) throws DataAccessException {
        this.privacyStatementCustomDAO.create(entity);
    }

    @Override
    public String addPrivacyHTML(Context context, String docId, String content_) throws EASBizException, BOSException {
        return null;
    }

    @Override
    public boolean checkIsSigned(Context ctx, String number, String version) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("versionTime", (Object)version, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            int count = PrivacyStatementFactory.getLocalInstance((Context)ctx).getPrivacyStatementCollection(entityViewInfo).size();
            if (count > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean checkIsSigned(Context ctx, String id) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("privacyCusId", (Object)id, CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            int count = PrivacyStatementFactory.getLocalInstance((Context)ctx).getPrivacyStatementCollection(entityViewInfo).size();
            if (count > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public boolean checkIsEnable(Context ctx, String id) throws DataAccessException {
        PrivacyStatementCustom entity = (PrivacyStatementCustom)this.privacyStatementCustomDAO.findById(id);
        return entity == null || !StatusEnum.ENABLE.toString().equalsIgnoreCase(entity.getStatus());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String deletePrivacyContentByIds(Context ctx, String[] ids) throws DataAccessException {
        for (int i = 0; i < ids.length; ++i) {
            String id = ids[i];
            PrivacyStatementCustom entity = (PrivacyStatementCustom)this.privacyStatementCustomDAO.findById(id);
            if (entity != null && StatusEnum.ENABLE.toString().equalsIgnoreCase(entity.getStatus())) {
                return entity.getDisplayName() + "(" + entity.getNumber() + ") \u4e3a\u542f\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u8bf7\u5931\u6548\u540e\u91cd\u8bd5\uff01";
            }
            if (!this.checkIsSigned(ctx, id)) continue;
            return entity.getDisplayName() + "(" + entity.getNumber() + ") \u5df2\u7ecf\u88ab\u7528\u6237\u7b7e\u7f72 \uff0c\u65e0\u6cd5\u5220\u9664\uff01";
        }
        this.privacyStatementCustomDAO.deleteByIds(ids);
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String updatePrivacyStatusById(String id, String status) throws DataAccessException {
        if (StatusEnum.ENABLE.toString().equalsIgnoreCase(status)) {
            PrivacyStatementCustom entity = new PrivacyStatementCustom();
            entity.setStatus(StatusEnum.ENABLE.toString());
            PrivacyStatementCustom findObject = this.privacyStatementCustomDAO.findObject(entity, new Filter[0]);
            if (findObject != null) {
                return "\u65e0\u6cd5\u540c\u65f6\u542f\u7528\u591a\u6761\u9690\u79c1\u58f0\u660e\uff01";
            }
        }
        PrivacyStatementCustomNoHtml data = (PrivacyStatementCustomNoHtml)this.privacyStatementCustomNoHtmlDAO.findById(id);
        data = this.getEditEntity(data, status);
        this.privacyStatementCustomNoHtmlDAO.update(data);
        return null;
    }

    private PrivacyStatementCustomNoHtml getEditEntity(PrivacyStatementCustomNoHtml data, String status) {
        data.setStatus(status);
        Timestamp curTime = new Timestamp(new Date().getTime());
        data.setLastUpdateTime(curTime);
        data.setEnableTime(curTime);
        return data;
    }

    private PrivacyStatementCustom getUpdateEditEntity(PrivacyStatementCustom data, PrivacyStatementCustom entity) {
        data.setNumber(entity.getNumber());
        data.setDisplayName(entity.getDisplayName());
        data.setDescription(entity.getDescription());
        data.setVersion(entity.getVersion());
        data.setHtmlContent(null);
        Timestamp curTime = new Timestamp(new Date().getTime());
        data.setLastUpdateTime(curTime);
        return data;
    }

    @Override
    public boolean isRepeatPrivacy(Context ctx, String number, String version, String id) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("version", (Object)version, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)id)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        }
        entityViewInfo.setFilter(filterInfo);
        try {
            int count = PrivacyStatementCustomFactory.getLocalInstance((Context)ctx).getPrivacyStatementCustomCollection(entityViewInfo).size();
            if (count > 0) {
                return true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        return false;
    }
}

