/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.common.util;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletHelper {
    private static final Logger logger = LoggerFactory.getLogger(PortletHelper.class);

    public static Preferences convPreferences(String preString) {
        if (!StringUtil.isEmpty((String)preString)) {
            String _preString = JSONUtil.decodeJsonStr((String)preString);
            Preferences pres = (Preferences)JSONUtil.getObject4Json((String)_preString, Preferences.class);
            if (pres == null) {
                return null;
            }
            try {
                List<Preference> preferenceList = pres.getPreferences();
                if (!preferenceList.isEmpty()) {
                    Preferences preferences = new Preferences();
                    for (Preference preferenceObj : preferenceList) {
                        Preference preference = (Preference)JSONObject.toBean((JSONObject)JSONObject.fromObject((Object)preferenceObj), Preference.class);
                        PortletHelper.fixJsonFormatData(preference);
                        preferences.addPreference(preference);
                    }
                    return preferences;
                }
            }
            catch (Exception e) {
                HashMap<String, Class<Preference>> classMap = new HashMap<String, Class<Preference>>();
                classMap.put("preferences", Preference.class);
                Preferences pres2 = (Preferences)JSONUtil.getObject4Json((String)preString, Preferences.class, classMap);
                List<Preference> preferences = pres2.getPreferences();
                for (int i = 0; i < preferences.size(); ++i) {
                    Preference preference = preferences.get(i);
                    preference.setName(JSONUtil.decodeJsonStr((String)preference.getName()));
                    List<String> values = preference.getValues();
                    for (int j = 0; j < values.size(); ++j) {
                        String value = values.get(j);
                        values.set(j, JSONUtil.decodeJsonStr((String)value));
                    }
                }
                return pres2;
            }
        }
        return null;
    }

    public static Map<String, List<String>> convPreferences2Map(Preferences preferences) {
        HashMap<String, List<String>> preferencesMap = null;
        if (preferences != null) {
            List<Preference> preferenceList = preferences.getPreferences();
            if (!preferenceList.isEmpty()) {
                preferencesMap = new HashMap<String, List<String>>();
                for (Preference preference : preferenceList) {
                    preferencesMap.put(preference.getName(), preference.getValues());
                }
            } else {
                logger.error("convPreferences2Map preferenceList is null ");
            }
        } else {
            logger.error("convPreferences2Map preferences is null");
        }
        return preferencesMap;
    }

    public static String getPortletTmplCode(String pltTmplId, List<PortletTmpl> pltTmplList) {
        String pltCode = null;
        if (pltTmplList != null && pltTmplId != null) {
            for (PortletTmpl tmpl : pltTmplList) {
                if (!pltTmplId.equals(tmpl.getId())) continue;
                pltCode = tmpl.getCode();
                break;
            }
        }
        if (pltCode == null) {
            String defaultPltTmplId = PortalCache.getPortalProfileMap().get("default_portlet_tmpl");
            if (pltTmplList != null) {
                for (PortletTmpl tmpl : pltTmplList) {
                    if (!defaultPltTmplId.equals(tmpl.getId())) continue;
                    pltCode = tmpl.getCode();
                    break;
                }
            }
        }
        return pltCode;
    }

    private static void fixJsonFormatData(Preference preference) {
        if (preference != null && preference.getValues() != null) {
            List<String> paramList = preference.getValues();
            for (int i = 0; i < paramList.size(); ++i) {
                String param = paramList.get(i);
                if (StringUtil.isEmpty((String)param) || !param.startsWith("\"0x1") || !param.endsWith("0x2\"")) continue;
                param = param.substring(1, param.length() - 1);
                paramList.set(i, param);
            }
        }
    }
}

