/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.dao.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.portlet.dao.PortletCategoryDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.common.util.StringUtil;
import java.util.List;

public class PortletCategoryDAOImpl
extends BaseDAOImpl<PortletCategory>
implements PortletCategoryDAO {
    @Override
    public PagingResult findCategory(PortletCategory category, String categoryName, Integer pageNo, Integer pageSize, Filter[] filters) {
        PagingParam pagingParam = new PagingParam(pageNo, pageSize);
        pagingParam.setPageNo(pageNo);
        pagingParam.setPageSize(pageSize);
        pagingParam.setOrder(OrderEnum.DESC);
        pagingParam.setSortField("categoryName");
        try {
            return this.findList(category, pagingParam, filters);
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public PagingResult<Object[]> findCategoryList(PortalContext ctx, PagingParam pagingParam, String categoryName, Boolean fuzzy) {
        StringBuilder sb = new StringBuilder("SELECT c.id, c.categoryName, c.portletKeywords FROM PortletCategory c ");
        StringBuilder countsb = new StringBuilder("SELECT COUNT(c.id) FROM PortletCategory c ");
        StringBuilder where = this.buildNameSql(categoryName, fuzzy);
        if (where != null) {
            sb = sb.append(" WHERE ").append((CharSequence)where);
            countsb = countsb.append(" WHERE ").append((CharSequence)where);
        }
        sb.append(" ORDER BY createTime DESC");
        try {
            return this.findList(sb.toString(), null, pagingParam, countsb.toString());
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public List<PortletCategory> findAllCategories(String name) {
        String appName = "%\"" + name + "\"%";
        try {
            return this.findList(new FieldFilter("categoryName", "like", appName));
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public List<PortletCategory> findCategoriesByNameAndId(String categoryName, String id) {
        try {
            StringBuilder sb = new StringBuilder("SELECT c.id, c.categoryName FROM PortletCategory c ");
            if (!StringUtil.isEmpty((String)categoryName)) {
                sb.append(" WHERE c.categoryName LIKE '%").append(categoryName).append("%'");
            }
            if (!StringUtil.isEmpty((String)id)) {
                sb.append(" and c.id != '").append(id).append("'");
            }
            return this.findList(sb.toString(), new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private StringBuilder buildNameSql(String categoryName, boolean isFuzzy) {
        StringBuilder where = new StringBuilder();
        if (StringUtil.isEmpty((String)categoryName)) {
            return null;
        }
        if (isFuzzy) {
            where.append("c.categoryName like '%").append(categoryName).append("%'");
        } else {
            where.append("c.categoryName like '%\"").append(categoryName).append("\"%'");
        }
        return where;
    }
}

