/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.dao.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.portlet.dao.PortletDefinitionDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.common.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PortletDefinitionDAOImpl
extends BaseDAOImpl<PortletDefinition>
implements PortletDefinitionDAO {
    private static String jpql_getListByIds = "select t from PortletDefinition t where t.id in ({ids}) and t.status = '{status}'";

    @Override
    public PagingResult findPortletDefinitionsByAppId(String pageNo, String pageSize, String id, PortletDefinition portletDefinition) {
        PagingParam pagingParam = new PagingParam();
        pagingParam.setPageNo(Integer.parseInt(pageNo));
        pagingParam.setPageSize(Integer.parseInt(pageSize));
        pagingParam.setOrder(OrderEnum.DESC);
        pagingParam.setSortField("appName");
        PagingResult<PortletDefinition> result = null;
        try {
            portletDefinition.setResLevel(ResLevelEnum.EXT);
            result = this.findList(portletDefinition, pagingParam, new FieldFilter("portletAppId", "=", id));
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public PagingResult<Object[]> findEnablePortletList(String permIds, String name, String keywords, PagingParam pagingParam) {
        StringBuilder filter = new StringBuilder();
        filter.append(this.permIdFilter(permIds)).append(this.nameFilter(name)).append(this.keywordsFilter(keywords));
        return this.innerGetEnablePortlets(filter.toString(), pagingParam);
    }

    private PagingResult<Object[]> innerGetEnablePortlets(String filter, PagingParam pagingParam) {
        String sql = "select t.id, t.displayName, t.icon,t.portletName from PortletDefinition t where t.status='ENABLE'";
        String countSql = "select count(*) from PortletDefinition t where t.status='ENABLE' and t.resLevel='" + (Object)((Object)ResLevelEnum.EXT) + "'";
        sql = sql + filter;
        countSql = countSql + filter;
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        try {
            return this.findList(sql, paramMap, pagingParam, countSql);
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    private String permIdFilter(String permIds) {
        if (StringUtil.isEmpty((String)permIds)) {
            return "";
        }
        return " and t.id in (" + permIds + ")";
    }

    private String nameFilter(String name) {
        if (StringUtil.isEmpty((String)name)) {
            return "";
        }
        return " and t.displayName like '%" + name + "%'";
    }

    private String keywordsFilter(String keywords) {
        StringBuilder sql = new StringBuilder();
        if (StringUtil.isEmpty((String)keywords)) {
            return "";
        }
        String[] keys = keywords.split(",");
        for (int i = 0; i < keys.length; ++i) {
            if (i > 0) {
                sql.append(" or ");
            }
            sql.append(" t.keywords like '%,").append(keys[i]).append(",%'");
        }
        return " and (" + sql.toString() + ")";
    }

    @Override
    public PagingResult<Object[]> findCategoryList(PortalContext ctx, PagingParam pagingParam, String portletName, Boolean fuzzy) {
        StringBuilder sb = new StringBuilder("SELECT d.portletAppId, d.portletName, d.displayName, d.keywords FROM PortletDefinition d ");
        StringBuilder countsb = new StringBuilder("SELECT COUNT(d.portletAppId) FROM PortletDefinition d ");
        StringBuilder where = this.buildNameSql(portletName, fuzzy);
        if (where != null) {
            sb = sb.append(" WHERE d.status='ENABLE' ").append((CharSequence)where);
            countsb = countsb.append(" WHERE d.status='ENABLE' ").append((CharSequence)where);
        }
        sb.append(" ORDER BY createTime DESC");
        try {
            return this.findList(sb.toString(), null, pagingParam, countsb.toString());
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public PagingResult<PortletDefinition> findCopyPortletList(String appName, String portletName, String displayName, PagingParam pagingParam) throws DataAccessException {
        StringBuilder selectClause = new StringBuilder();
        selectClause.append("SELECT new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition(pd.id, pd.portletAppId, pd.appName, pd.portletName, pd.displayName, pd.description, pd.categoryId, pc.categoryName) ");
        selectClause.append("FROM PortletDefinition pd, PortletCategory pc WHERE pd.categoryId = pc.id  ");
        StringBuilder countClause = new StringBuilder("SELECT count(pd.id) FROM PortletDefinition pd, PortletCategory pc WHERE pd.categoryId = pc.id  ");
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AND pd.appName = '" + appName + "' ");
        whereClause.append("AND pd.portletName = '" + portletName + "' ");
        whereClause.append("AND pd.copy = 1 ");
        if (!StringUtil.isEmpty((String)displayName)) {
            whereClause.append(" AND pd.displayName LIKE '%" + displayName + "%' ");
        }
        StringBuilder orderClause = new StringBuilder();
        selectClause.append((CharSequence)whereClause).append((CharSequence)orderClause);
        countClause.append((CharSequence)whereClause);
        PagingResult<PortletDefinition> pagingResult = this.findList4CustomJPQL(selectClause.toString(), null, pagingParam, countClause.toString());
        return pagingResult;
    }

    private StringBuilder buildNameSql(String portletName, boolean isFuzzy) {
        StringBuilder where = new StringBuilder();
        if (StringUtil.isEmpty((String)portletName)) {
            return null;
        }
        if (isFuzzy) {
            where.append("d.portletName like '%").append(portletName).append("%'");
        } else {
            where.append("d.portletName = ").append(portletName);
        }
        return where;
    }

    @Override
    public PagingResult<Object[]> findPortletList(PortalContext cxt, PortletDefinition pd, PagingParam pagingParam, String appName, String displayName, String categoryId) throws DataAccessException {
        try {
            String displayNameAppend;
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            StringBuilder selectClause = new StringBuilder();
            selectClause.append("SELECT pd.id, pd.portletAppId, pd.appName, pd.portletName, pd.displayName, pd.description, pd.categoryId,pd.status,pd.copy,pd.preferences ");
            selectClause.append("FROM PortletDefinition pd WHERE pd.resLevel='").append((Object)pd.getResLevel()).append("' and ");
            if (!StringUtil.isEmpty((String)displayName)) {
                displayNameAppend = " pd.displayName like :displayName";
                paramMap.put("displayName", "%" + displayName + "%");
            } else {
                displayNameAppend = " pd.displayName like '%%'";
            }
            selectClause.append(displayNameAppend);
            StringBuilder countClause = new StringBuilder();
            countClause.append("SELECT count(pd.id) FROM PortletDefinition pd WHERE pd.resLevel='").append((Object)pd.getResLevel()).append("' and ");
            countClause.append(displayNameAppend);
            if (appName == null || appName.equals("")) {
                if (categoryId != null && !"".equals(categoryId)) {
                    selectClause.append(" and pd.categoryId='").append(categoryId).append("'");
                    countClause.append(" and pd.categoryId='").append(categoryId).append("'");
                }
            } else {
                if (categoryId == null || "".equals(categoryId)) {
                    selectClause.append(" and pd.appName=:appName");
                    countClause.append(" and pd.appName=:appName");
                } else {
                    selectClause.append(" and pd.appName=:appName");
                    selectClause.append(" and pd.categoryId='").append(categoryId).append("'");
                    countClause.append(" and pd.appName=:appName");
                    countClause.append(" and pd.categoryId='").append(categoryId).append("'");
                }
                paramMap.put("appName", appName);
            }
            if (pagingParam.getSortField() != null) {
                if (pagingParam.getSortField().equals("categoryName")) {
                    pagingParam.setSortField("categoryId");
                }
                selectClause.append(" order by pd.").append(pagingParam.getSortField()).append(" ").append(pagingParam.getOrder().toString());
            }
            return this.findList(selectClause.toString(), paramMap, pagingParam, countClause.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PagingResult<PortletDefinition> findStatusPortletList(PortletDefinition pd, PagingParam pagingParam, String categoryName, String displayName, StatusEnum status) throws DataAccessException {
        try {
            pd.setResLevel(ResLevelEnum.EXT);
            return this.findList(pd, pagingParam, new FieldFilter("status", "=", (Object)status), new FieldFilter("keywords", "like", categoryName), new FieldFilter("displayName", "like", displayName));
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<PortletDefinition> getListByIds(String status, Set<String> ids) throws DataAccessException {
        StringBuilder groupJpql = new StringBuilder();
        Iterator<String> iter = ids.iterator();
        while (iter.hasNext()) {
            groupJpql.append("'").append(iter.next()).append("'");
            if (!iter.hasNext()) continue;
            groupJpql.append(", ");
        }
        String jpql = StringUtil.merge((String)jpql_getListByIds, (String[])new String[]{groupJpql.toString(), status});
        return this.findList(jpql, new Object[0]);
    }

    @Override
    public void updateTmplIdByTmpilId(PortalContext context, String tmplId, String newTmplId) throws DataAccessException {
        String sql = "update PortletDefinition t set t.tmplId =:newTmplId  where t.tmplId = :tmplId";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("newTmplId", newTmplId);
        param.put("tmplId", tmplId);
        this.executeUpdate(sql, param);
    }

    @Override
    public List<PortletDefinition> findStatusCardList(String[] portletNames, String displayName, StatusEnum status) throws DataAccessException {
        String sql = "SELECT t FROM {entityClassName} t WHERE t.portletName IN ({portletNames})  and t.status= 'ENABLE' and t.resLevel='" + (Object)((Object)ResLevelEnum.EXT) + "' order by portletName asc";
        StringBuilder sb = new StringBuilder();
        for (String portletName : portletNames) {
            sb.append("'").append(portletName).append("'").append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        String jpql = StringUtil.merge((String)sql, (String[])new String[]{this.getEntityClassName(), sb.toString()});
        return this.findList(jpql, new Object[0]);
    }
}

