/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.entity;

import com.kingdee.portal.biz.common.entity.ObjectBaseEntity;
import com.kingdee.portal.biz.common.enums.PortletTypeEnum;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="T_JP_PortletDefinition")
public class PortletDefinition
extends ObjectBaseEntity {
    @Column(name="FPortletAppId", length=60)
    private String portletAppId;
    @Column(name="FAppName", length=60)
    private String appName;
    @Column(name="FPortletName", length=60)
    private String portletName;
    @Column(name="FDisplayName", length=300)
    private String displayName;
    @Column(name="FPreferences", length=3000)
    private String preferences;
    @Column(name="FIcon", length=100)
    private String icon;
    @Column(name="FKeywords", length=255)
    private String keywords;
    @Column(name="FSupports", length=255)
    private String supports;
    @Column(name="FDescription", length=600)
    private String description;
    @Column(name="FThemeId", length=60)
    private String themeId;
    @Column(name="FTmplId", length=60)
    private String tmplId;
    @Column(name="FCategoryId", length=60)
    private String categoryId;
    @Column(name="FPortletType", length=20)
    @Enumerated(value=EnumType.STRING)
    private PortletTypeEnum portletType;
    @Column(name="FCopy")
    private Boolean copy;
    @Column(name="FStatus", length=60)
    @Enumerated(value=EnumType.STRING)
    private StatusEnum status;
    @Column(name="FPermViewCtrl")
    private Boolean permViewCtrl;
    @Column(name="FResLevel", length=60)
    @Enumerated(value=EnumType.STRING)
    private ResLevelEnum resLevel;
    @Column(name="FGsPosition", length=60)
    private String gsPosition;
    @Transient
    private String categoryName;

    public PortletDefinition() {
    }

    public PortletDefinition(String id, String portletAppId, String appName, String portletName, String displayName, String description, String categoryId, String categoryName) {
        this.setId(id);
        this.setPortletAppId(portletAppId);
        this.setAppName(appName);
        this.setPortletName(portletName);
        this.setDisplayName(displayName);
        this.setDescription(description);
        this.setCategoryId(categoryId);
        this.setCategoryName(categoryName);
    }

    public String getPortletName() {
        return this.portletName;
    }

    public void setPortletName(String portletName) {
        this.portletName = portletName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = FilterSpecialCharactersTool.checkValidParamsForJSON(displayName);
    }

    public String getPreferences() {
        return this.preferences;
    }

    public void setPreferences(String preferences) {
        this.preferences = preferences;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getSupports() {
        return this.supports;
    }

    public void setSupports(String supports) {
        this.supports = supports;
    }

    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public String getPortletAppId() {
        return this.portletAppId;
    }

    public void setPortletAppId(String portletAppId) {
        this.portletAppId = portletAppId;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = FilterSpecialCharactersTool.checkValidParamsForJSON(description);
    }

    public String getThemeId() {
        return this.themeId;
    }

    public void setThemeId(String themeId) {
        this.themeId = themeId;
    }

    public String getTmplId() {
        return this.tmplId;
    }

    public void setTmplId(String tmplId) {
        this.tmplId = tmplId;
    }

    public Boolean getCopy() {
        return this.copy;
    }

    public void setCopy(Boolean copy) {
        this.copy = copy;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public PortletTypeEnum getPortletType() {
        return this.portletType;
    }

    public void setPortletType(PortletTypeEnum portletType) {
        this.portletType = portletType;
    }

    public Boolean getPermViewCtrl() {
        return this.permViewCtrl;
    }

    public void setPermViewCtrl(Boolean permViewCtrl) {
        this.permViewCtrl = permViewCtrl;
    }

    public ResLevelEnum getResLevel() {
        return this.resLevel;
    }

    public void setResLevel(ResLevelEnum resLevel) {
        this.resLevel = resLevel;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    @Transient
    public String getDisplayKeyword() {
        if (this.keywords == null) {
            return "";
        }
        String s = this.keywords;
        if (s.startsWith(",")) {
            s = s.substring(1);
        }
        if (s.endsWith(",")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getGsPosition() {
        return this.gsPosition;
    }

    public void setGsPosition(String gsPosition) {
        this.gsPosition = gsPosition;
    }
}

