/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.portlet.dao.PortletAppDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletApp;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.service.PortletAppService;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import net.sf.json.JSONObject;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletAppServiceImpl
implements PortletAppService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static ServletContext sysContext = null;
    private PortletDefinitionService portletDefinitionService;
    private PortletService portletService;
    private PortletCategoryService portletCategoryService;
    private PortletAppDAO portletAppDAO;

    @Override
    public PortletApp createPortletApp(PortalContext context, PortletApp portletApp, String categoryName) throws PortalBizException, PortletContainerException {
        boolean isAppExist = false;
        try {
            Iterator registerServices = this.getPortletRegistryService().getRegisteredPortletApplicationNames();
            String appName = null;
            while (registerServices.hasNext()) {
                appName = (String)registerServices.next();
                if (!appName.equals("/" + portletApp.getName())) continue;
                isAppExist = true;
                break;
            }
            if (isAppExist) {
                PortletApp portletAppdb = (PortletApp)this.portletAppDAO.findObject(new FieldFilter("name", "=", portletApp.getName()));
                if (portletAppdb != null) {
                    this.logger.error("portletApp===========have Exit");
                    throw new PortalBizException("302");
                }
            } else {
                this.logger.error("portletApp===========APP_NOT_EXIT");
                throw new PortalBizException("303");
            }
            portletApp.setPortalContext(context);
            portletApp.setContextPath(this.getPortletRegistryService().getPortletApplication(appName).getContextPath());
            portletApp.setStatus(StatusEnum.DISABLE);
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"zh_TW", (Object)portletApp.getName());
            jsonObj.put((Object)"zh_CN", (Object)portletApp.getName());
            jsonObj.put((Object)"en", (Object)portletApp.getName());
            portletApp.setDescription(jsonObj.toString());
            portletApp.setResLevel(ResLevelEnum.EXT);
            this.logger.error("jsonObj.toString()===========" + jsonObj.toString());
            portletApp = this.portletAppDAO.create(portletApp);
            this.logger.error("portletApp===========save End");
            this.portletDefinitionService.createPortlets(context, portletApp, categoryName);
        }
        catch (PortalBizException ex) {
            this.logger.error(ex.getMessage());
            throw ex;
        }
        catch (DataAccessException de) {
            this.logger.error(de.getMessage());
            throw new PortalBizException("300", de);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return portletApp;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<PortletApp> findPortletAppList(PagingParam pagingParam) throws PortalBizException {
        PagingResult<PortletApp> pagingResult = null;
        try {
            PortletApp portletApp = new PortletApp();
            pagingResult = this.portletAppDAO.findPortletApp(portletApp, pagingParam);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return pagingResult;
    }

    @Override
    public PortletApp modifyPortletAppStatus(PortalContext context, String appId) throws PortalBizException {
        PortletApp app = null;
        try {
            app = (PortletApp)this.portletAppDAO.findById(appId);
            if (app != null) {
                if (app.getResLevel().equals((Object)ResLevelEnum.SYS)) {
                    throw new PortalBizException("301");
                }
                app.setPortalContext(context);
                if (app.getStatus().equals((Object)StatusEnum.ENABLE)) {
                    app.setStatus(StatusEnum.DISABLE);
                    this.portletDefinitionService.modifyPortletListStatus(context, app, StatusEnum.DISABLE);
                } else {
                    app.setStatus(StatusEnum.ENABLE);
                    app.setPortalContext(context);
                    this.portletDefinitionService.modifyPortletListStatus(context, app, StatusEnum.ENABLE);
                }
                app = this.portletAppDAO.update(app);
            }
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("304", e);
        }
        catch (DataAccessException de) {
            this.logger.error(de.getMessage());
            throw new PortalBizException("304", de);
        }
        return app;
    }

    @Override
    public PortletApp updatePortletApp(PortalContext context, String appId, String desc) throws PortalBizException {
        PortletApp portletApp = null;
        try {
            portletApp = (PortletApp)this.portletAppDAO.findById(appId);
            portletApp.setPortalContext(context);
            this.portletAppDAO.update(portletApp);
            PortletApplicationDefinition appDefinition = null;
            try {
                appDefinition = this.getPortletRegistryService().getPortletApplication("/" + portletApp.getName());
            }
            catch (PortletContainerException e) {
                throw new PortalBizException("300", e);
            }
            boolean findFlag = false;
            ArrayList<String> existIds = new ArrayList<String>();
            PortletDefinition pd = new PortletDefinition();
            pd.setAppName(portletApp.getName());
            List<PortletDefinition> definitions = this.portletDefinitionService.findPortletDefinitionList(context, pd);
            String defaultCategoryId = "";
            ArrayList<String> nonExistIds = new ArrayList<String>();
            for (org.apache.pluto.container.om.portlet.PortletDefinition portletdefinition : appDefinition.getPortlets()) {
                findFlag = false;
                for (int i = 0; i < definitions.size(); ++i) {
                    PortletDefinition definition = definitions.get(i);
                    if (defaultCategoryId.length() <= 0) {
                        defaultCategoryId = definition.getCategoryId();
                    }
                    if (!definition.getPortletName().equals(portletdefinition.getPortletName())) continue;
                    this.portletDefinitionService.updateExistPortletDefinition(context, portletdefinition, definition);
                    existIds.add(definition.getId());
                    findFlag = true;
                }
                if (findFlag) continue;
                this.portletDefinitionService.savePortletDefinition(context, portletdefinition, appId, defaultCategoryId);
            }
            this.deletePortletList(context, definitions, existIds, nonExistIds);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("305", e);
        }
        return portletApp;
    }

    private void deletePortletList(PortalContext context, List<PortletDefinition> definitions, List<String> existIds, List<String> nonExistIds) throws PortalBizException {
        boolean nonFindFlag = false;
        for (int i = 0; i < definitions.size(); ++i) {
            PortletDefinition definition = definitions.get(i);
            if (existIds.contains(definition.getId())) {
                nonFindFlag = true;
            }
            if (existIds.contains(definition.getId())) continue;
            nonExistIds.add(definition.getId());
        }
        if (nonExistIds.size() > 0) {
            String[] ids = nonExistIds.toArray(new String[nonExistIds.size()]);
            this.portletDefinitionService.deletePortletDefinitionByIds(context, ids);
            this.portletService.deletePltInstanceAndPrefencesByDefIds(context, ids);
        }
    }

    @Override
    public void removePortletApp(PortalContext context, String appId, String appName) throws PortalBizException {
        PortletApp app = null;
        try {
            app = (PortletApp)this.portletAppDAO.findById(appId);
            if (app.getResLevel().equals((Object)ResLevelEnum.SYS)) {
                throw new PortalBizException("301");
            }
            List<PortletDefinition> definitions = this.portletDefinitionService.findPortletDefinitionsByAppId(appId).getPortletDefinitions();
            for (PortletDefinition definition : definitions) {
                List<PortletInstance> instances = this.portletService.getPortletInstanceListBydefinitionId(definition.getId());
                for (PortletInstance instance : instances) {
                    PortletRuntimePreferences preference = this.portletService.findPortletRuntimePreferencesByInsId(context, instance.getId());
                    if (preference != null) {
                        this.portletService.deletePortletRuntimePreferences(context, preference);
                    }
                    this.portletService.deletePortletInstance(context, instance);
                }
                this.portletDefinitionService.deletePortletDefinition(context, definition);
            }
            this.portletAppDAO.delete(app);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("306", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletApp> findAppNameListFromXML(String registerFlag) throws PortalBizException {
        List<PortletApp> appNameList = new ArrayList<PortletApp>();
        Iterator registerServices = this.getPortletRegistryService().getRegisteredPortletApplicationNames();
        if (registerFlag.equals("unregister")) {
            PagingParam pagin = new PagingParam();
            pagin.setPageNo(1);
            pagin.setPageSize(100);
            List<PortletApp> appRegisteredList = this.findPortletAppList(pagin).getRecords();
            appNameList = this.getUnresiteredList(appRegisteredList, registerServices);
        } else {
            while (registerServices.hasNext()) {
                PortletApp pa = new PortletApp();
                pa.setName(((String)registerServices.next()).substring(1, ((String)registerServices.next()).length()));
                appNameList.add(pa);
            }
        }
        return appNameList;
    }

    private List<PortletApp> getUnresiteredList(List<PortletApp> appRegisteredList, Iterator<String> registerServices) throws PortalBizException {
        ArrayList<PortletApp> appNameList = new ArrayList<PortletApp>();
        while (registerServices.hasNext()) {
            Boolean isExit = false;
            String str = registerServices.next();
            str = str.substring(1, str.length());
            for (int i = 0; i < appRegisteredList.size(); ++i) {
                PortletApp pa = appRegisteredList.get(i);
                if (!pa.getName().equals(str)) continue;
                isExit = true;
                break;
            }
            if (isExit.booleanValue()) continue;
            PortletApp npa = new PortletApp();
            npa.setName(str);
            appNameList.add(npa);
        }
        return appNameList;
    }

    private PortletRegistryService getPortletRegistryService() throws PortalBizException {
        return PlutoServices.getServices().getPortletRegistryService();
    }

    public static ServletContext getSysContext() {
        return sysContext;
    }

    public static void setSysContext(ServletContext sysContext) {
        PortletAppServiceImpl.sysContext = sysContext;
    }

    public void setPortletService(PortletService portletService) {
        this.portletService = portletService;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }

    public void setPortletCategoryService(PortletCategoryService portletCategoryService) {
        this.portletCategoryService = portletCategoryService;
    }

    public void setPortletAppDAO(PortletAppDAO portletAppDAO) {
        this.portletAppDAO = portletAppDAO;
    }
}

