/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.portlet.dao.PortletCategoryDAO;
import com.kingdee.portal.biz.module.portlet.dto.PortletModel;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletCategoryServiceImpl
implements PortletCategoryService {
    private PortletCategoryDAO portletCategoryDAO;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletModel findCategory(String categoryName, boolean fuzzy, String pageNo, String pageSize) {
        PortletModel model = new PortletModel();
        PortletCategory category = new PortletCategory();
        Integer pageNo1 = 1;
        Integer pageSize1 = 8;
        if (StringUtil.isEmpty((String)pageNo)) {
            pageNo1 = Integer.valueOf(pageNo);
        }
        if (StringUtil.isEmpty((String)pageSize)) {
            pageSize1 = Integer.valueOf(pageSize);
        }
        Filter[] filters = null;
        if (fuzzy) {
            filters = this.getFuzzyFilter(category);
        }
        model.setCategoryPagingResult(this.portletCategoryDAO.findCategory(category, categoryName, pageNo1, pageSize1, filters));
        return model;
    }

    @Override
    public PortletCategory editByCategory(PortletCategory category) throws PortalBizException {
        if (StringUtil.isEmpty((String)category.getId())) {
            try {
                category = this.portletCategoryDAO.create(category);
                PortletCategory category1 = (PortletCategory)this.portletCategoryDAO.findById(category.getId());
                if (category1 != null) {
                    if (StringUtil.isEmpty((String)category.getCategoryName())) {
                        category1.setCategoryName(category.getCategoryName());
                    }
                    if (StringUtil.isEmpty((String)category.getPortletKeywords())) {
                        category1.setPortletKeywords(category.getPortletKeywords());
                    }
                    category = this.portletCategoryDAO.update(category1);
                } else {
                    category = this.portletCategoryDAO.create(category);
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return category;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletCategory findCategoryById(PortletCategory category) throws PortalBizException {
        if (!StringUtil.isEmpty((String)category.getId())) {
            try {
                category = (PortletCategory)this.portletCategoryDAO.findById(category.getId());
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return category;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean checkDuplicateCategoryName(PortalContext portalContext, String categroyName) throws PortalBizException {
        DisplayName dn = new DisplayName(categroyName);
        ArrayList<String> nameList = new ArrayList<String>();
        if (!StringUtil.isEmpty((String)dn.getZh_CN())) {
            nameList.add(dn.getZh_CN());
        }
        if (!StringUtil.isEmpty((String)dn.getEn())) {
            nameList.add(dn.getEn());
        }
        if (!StringUtil.isEmpty((String)dn.getZh_TW())) {
            nameList.add(dn.getZh_TW());
        }
        for (int i = 0; i < nameList.size(); ++i) {
            String cname = (String)nameList.get(i);
            List<PortletCategory> categories = this.portletCategoryDAO.findAllCategories(cname);
            if (categories.size() <= 0) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean checkDuplicateCategoryName(PortalContext ctx, String id, String categoryName) throws PortalBizException {
        String nameTW;
        String nameEn;
        if (StringUtil.isEmpty((String)id)) {
            this.checkDuplicateCategoryName(ctx, categoryName);
        }
        PortletCategory category = null;
        if (StringUtil.isEmpty((String)id)) return false;
        try {
            category = (PortletCategory)this.portletCategoryDAO.findById(id);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        if (category == null) return false;
        DisplayName dbDisplayName = new DisplayName(category.getCategoryName());
        DisplayName cDisplayName = new DisplayName(categoryName);
        ArrayList<String> clientName = new ArrayList<String>();
        String nameCN = cDisplayName.getZh_CN();
        if (!StringUtil.isEmpty((String)nameCN)) {
            clientName.add(nameCN);
        }
        if (!StringUtil.isEmpty((String)(nameEn = cDisplayName.getEn()))) {
            clientName.add(nameEn);
        }
        if (!StringUtil.isEmpty((String)(nameTW = cDisplayName.getZh_TW()))) {
            clientName.add(nameTW);
        }
        if (dbDisplayName.toString().equals(categoryName)) {
            return false;
        }
        if (dbDisplayName.toString().equals(categoryName)) return false;
        for (int i = 0; i < clientName.size(); ++i) {
            String cName = (String)clientName.get(i);
            ArrayList<FieldFilter> filterList = new ArrayList<FieldFilter>();
            FieldFilter filter = null;
            if (!StringUtil.isEmpty((String)categoryName)) {
                filter = new FieldFilter("categoryName", "like", "%\"" + cName + "\"%");
                filterList.add(filter);
            }
            if (!StringUtil.isEmpty((String)id)) {
                filter = new FieldFilter("id", "<>", id);
                filterList.add(filter);
            }
            Filter[] filters = new Filter[filterList.size()];
            filters = filterList.toArray(filters);
            try {
                List categorys = this.portletCategoryDAO.findList(filters);
                if (categorys.size() <= 0) continue;
                return true;
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean checkDuplicateKeyWords(String id, String keyWrods) throws PortalBizException {
        if (StringUtil.isEmpty((String)id)) {
            try {
                List keys = this.portletCategoryDAO.findList(new FieldFilter("portletKeywords", "=", keyWrods));
                if (keys.size() > 0) {
                    return true;
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        if (!StringUtil.isEmpty((String)id)) {
            PortletCategory category = null;
            try {
                category = (PortletCategory)this.portletCategoryDAO.findById(id);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
            if (category.getPortletKeywords().equals(keyWrods)) {
                return false;
            }
            ArrayList<FieldFilter> filterList = new ArrayList<FieldFilter>();
            FieldFilter filter = null;
            if (!StringUtil.isEmpty((String)keyWrods)) {
                filter = new FieldFilter("portletKeywords", "=", keyWrods);
                filterList.add(filter);
            }
            if (!StringUtil.isEmpty((String)id)) {
                filter = new FieldFilter("id", "<>", id);
                filterList.add(filter);
            }
            Filter[] filters = new Filter[filterList.size()];
            filters = filterList.toArray(filters);
            try {
                List keys = this.portletCategoryDAO.findList(filters);
                if (keys.size() > 0) {
                    return true;
                }
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public String saveCategory(PortalContext portalContext, String id, String categoryName, String portletKeywords) throws PortalBizException {
        PortletCategory category = new PortletCategory();
        if (!StringUtil.isEmpty((String)categoryName)) {
            categoryName = categoryName.trim();
        }
        DisplayName dn = new DisplayName(categoryName);
        category.setCategoryName(dn.toString());
        if (!StringUtil.isEmpty((String)portletKeywords)) {
            category.setPortletKeywords(portletKeywords);
        }
        if (StringUtil.isEmpty((String)id)) {
            category.setPortalContext(portalContext);
            PortletCategory portletCategory = this.getRootPortletCategory();
            category.setParentNode(portletCategory);
            try {
                category = this.portletCategoryDAO.create(category);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                PortletCategory updateCategory = (PortletCategory)this.portletCategoryDAO.findById(id);
                updateCategory.setCategoryName(category.getCategoryName());
                updateCategory.setPortletKeywords(category.getPortletKeywords());
                updateCategory.setPortalContext(portalContext);
                category = this.portletCategoryDAO.update(updateCategory);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return category.getId();
    }

    @Override
    public String savePortletCategory(PortalContext portalContext, String id, String categoryName, String portletKeywords) throws PortalBizException {
        PortletCategory category = new PortletCategory();
        if (!StringUtil.isEmpty((String)categoryName)) {
            categoryName = categoryName.trim();
        }
        category.setCategoryName(categoryName);
        if (!StringUtil.isEmpty((String)portletKeywords)) {
            category.setPortletKeywords(portletKeywords);
        }
        if (StringUtil.isEmpty((String)id)) {
            category.setPortalContext(portalContext);
            PortletCategory portletCategory = this.getRootPortletCategory();
            category.setParentNode(portletCategory);
            try {
                category = this.portletCategoryDAO.create(category);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else {
            try {
                PortletCategory updateCategory = (PortletCategory)this.portletCategoryDAO.findById(id);
                updateCategory.setCategoryName(category.getCategoryName());
                updateCategory.setPortletKeywords(category.getPortletKeywords());
                updateCategory.setPortalContext(portalContext);
                category = this.portletCategoryDAO.update(updateCategory);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return category.getId();
    }

    private String setDisplayName(String categoryName) {
        DisplayName dn = new DisplayName();
        if ("plt_portal".equals(categoryName)) {
            dn.setEn("Portal Config");
            dn.setZh_CN("\u7ba1\u7406\u914d\u7f6e");
            dn.setZh_TW("\u7ba1\u7406\u914d\u7f6e");
        } else if ("plt_widget".equals(categoryName)) {
            dn.setEn("Portal Basic");
            dn.setZh_CN("\u95e8\u6237\u5e94\u7528");
            dn.setZh_TW("\u9580\u6236\u61c9\u7528");
        } else if ("plt_sp".equals(categoryName)) {
            dn.setEn("Develop Ref");
            dn.setZh_CN("\u5f00\u53d1\u53c2\u8003");
            dn.setZh_TW("\u958b\u767c\u53c3\u8003");
        } else if ("plt_demo".equals(categoryName)) {
            dn.setEn(categoryName);
            dn.setZh_CN("\u793a\u4f8b\u5305");
            dn.setZh_TW("\u793a\u4f8b\u5305");
        } else if ("plt_wfpc".equals(categoryName)) {
            dn.setEn("Process Center");
            dn.setZh_CN("\u6d41\u7a0b\u4e2d\u5fc3");
            dn.setZh_TW("\u6d41\u7a0b\u4e2d\u5fc3");
        } else if ("plt_myworkplat".equals(categoryName)) {
            dn.setEn("My Workbench");
            dn.setZh_CN("\u6211\u7684\u5de5\u4f5c\u53f0");
            dn.setZh_TW("\u6211\u7684\u5de5\u4f5c\u81fa");
        } else if ("plt_iservice".equals(categoryName)) {
            dn.setEn("iService");
            dn.setZh_CN("iService(\u670d\u52a1\u4e2d\u5fc3)");
            dn.setZh_TW("iService(\u670d\u52d9\u4e2d\u5fc3)");
        } else if ("plt_ireport".equals(categoryName)) {
            dn.setEn("My Workbench");
            dn.setZh_CN("\u6211\u7684\u5de5\u4f5c\u53f0");
            dn.setZh_TW("\u6211\u7684\u5de5\u4f5c\u81fa");
        } else {
            dn.setEn(categoryName);
            dn.setZh_CN(categoryName);
            dn.setZh_TW(categoryName);
        }
        return dn.toString();
    }

    private PortletCategory getRootPortletCategory() {
        try {
            return (PortletCategory)this.portletCategoryDAO.findObject(new FieldFilter("nodeLevel", "=", 0));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public JSONObject findCategoryList(PortalContext ctx, String pageNo, String pageSize, String categoryName, Boolean fuzzy) throws PortalBizException {
        int pageNum = this.parseValue(pageNo, 1);
        int size = this.parseValue(pageSize, 100);
        if (!StringUtil.isEmpty((String)categoryName)) {
            categoryName = categoryName.trim();
        }
        PagingParam pagingParam = this.getPagingParam(pageNum, size);
        PagingResult<Object[]> paging = this.portletCategoryDAO.findCategoryList(ctx, pagingParam, categoryName, fuzzy);
        return this.builderCategoryListObj(paging, size, pageNum);
    }

    @Override
    public void batchDeleteCategory(PortalContext portalContext, String ids) throws PortalBizException {
        if (StringUtil.isEmpty((String)ids)) {
            return;
        }
        String[] categoryIds = ids.split(",");
        try {
            this.portletCategoryDAO.deleteByIds(categoryIds);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    private JSONObject builderCategoryListObj(PagingResult<Object[]> paging, int pageSize, int pageNum) {
        List<Object[]> list = paging.getRecords();
        int total = paging.getTotalCount();
        int pageCount = (int)Math.ceil((double)total / (double)pageSize);
        JSONObject object = new JSONObject();
        object.put((Object)"result", (Object)this.getCategoryListArr(list));
        object.put((Object)"count", (Object)total);
        object.put((Object)"pageCount", (Object)this.judgeValue(pageCount, 1));
        object.put((Object)"pageNum", (Object)pageNum);
        object.put((Object)"pageSize", (Object)pageSize);
        return object;
    }

    private int judgeValue(int value, int defaultValue) {
        if (value <= 0) {
            return defaultValue;
        }
        return value;
    }

    private JSONArray getCategoryListArr(List<Object[]> categoryList) {
        JSONArray arr = new JSONArray();
        JSONObject obj = null;
        for (Object[] category : categoryList) {
            obj = new JSONObject();
            obj.put((Object)"id", category[0]);
            obj.put((Object)"categoryName", (Object)new DisplayName((String)category[1]));
            obj.put((Object)"portletKeywords", category[2]);
            arr.add((Object)obj);
        }
        return arr;
    }

    private PagingParam getPagingParam(int pageNum, int pageSize) {
        PagingParam pagingParam = new PagingParam();
        pagingParam.setPageNo(pageNum);
        pagingParam.setPageSize(pageSize);
        pagingParam.setOrder(OrderEnum.DESC);
        pagingParam.setSortField("createTime");
        return pagingParam;
    }

    private int parseValue(String value, int defaultValue) {
        if (!StringUtil.isEmpty((String)value)) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    private Filter[] getFuzzyFilter(PortletCategory category) {
        ArrayList<FieldFilter> filterList = new ArrayList<FieldFilter>();
        FieldFilter filter = null;
        if (category.getCategoryName() != null) {
            filter = new FieldFilter("categoryName", "like", this.getFuzzyString(category.getCategoryName()));
            filterList.add(filter);
        }
        if (category.getPortletKeywords() != null) {
            filter = new FieldFilter("portletKeywords", "like", this.getFuzzyString(category.getPortletKeywords()));
            filterList.add(filter);
        }
        Filter[] filters = new Filter[filterList.size()];
        filters = filterList.toArray(filters);
        return filters;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public String getFuzzyString(String value) {
        StringBuilder fuzzyString = new StringBuilder("%");
        fuzzyString.append(value);
        fuzzyString.append("%");
        return fuzzyString.toString();
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletCategory> getCategoryListByName(String categoryName) throws PortalBizException {
        try {
            return this.portletCategoryDAO.findList(new FieldFilter("portletKeywords", "=", categoryName));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void deleteCategory(PortletCategory category) throws PortalBizException {
        try {
            this.portletCategoryDAO.delete(category);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public PortletCategoryDAO getPortletCategoryDAO() {
        return this.portletCategoryDAO;
    }

    public void setPortletCategoryDAO(PortletCategoryDAO portletCategoryDAO) {
        this.portletCategoryDAO = portletCategoryDAO;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletCategory> findCategoryList(PortalContext portalContext, String ordername, String orderby) throws PortalBizException {
        List cateList = null;
        try {
            cateList = orderby.equals("ASC") ? this.portletCategoryDAO.findList(new Filter[]{new FieldFilter("nodeLevel", "=", 1), new FieldFilter("hidden", "=", false), new OrderFilter(ordername, OrderEnum.ASC)}) : this.portletCategoryDAO.findList(new Filter[]{new FieldFilter("nodeLevel", "=", 1), new FieldFilter("hidden", "=", false), new OrderFilter(ordername, OrderEnum.DESC)});
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        return cateList;
    }
}

