/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.PortletTypeEnum;
import com.kingdee.portal.biz.common.enums.ResLevelEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.portal.biz.module.portlet.dao.PortletDefinitionDAO;
import com.kingdee.portal.biz.module.portlet.dto.PortletDefinitionDTO;
import com.kingdee.portal.biz.module.portlet.dto.PortletModel;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.CardCategory;
import com.kingdee.portal.biz.module.portlet.entity.CardSecondCategory;
import com.kingdee.portal.biz.module.portlet.entity.CardSecondCategoryEntry;
import com.kingdee.portal.biz.module.portlet.entity.PortletApp;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.service.CardCategoryService;
import com.kingdee.portal.biz.module.portlet.service.CardSecondCategoryEntryService;
import com.kingdee.portal.biz.module.portlet.service.CardSecondCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletAppService;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.biz.module.setting.entity.PortalProfile;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.driver.PlutoServices;
import org.apache.pluto.container.driver.PortletRegistryService;
import org.apache.pluto.container.om.portlet.DisplayName;
import org.apache.pluto.container.om.portlet.PortletApplicationDefinition;
import org.apache.pluto.container.om.portlet.PortletDefinition;
import org.apache.pluto.container.om.portlet.Preferences;
import org.apache.pluto.container.om.portlet.Supports;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletDefinitionServiceImpl
implements PortletDefinitionService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SettingService portalProfileService;
    private PortletDefinitionDAO portletDefinitionDAO;
    private PortletService portletService;
    private PermService permService;
    private PortletAppService portletAppService;
    private PortletCategoryService portletCategoryService;
    private SettingService settingService;
    private CardCategoryService cardCategoryService;
    private CardSecondCategoryService cardSecondCategoryService;
    private CardSecondCategoryEntryService cardSecondCategoryEntryService;

    @Override
    public String createPortlets(PortalContext context, PortletApp portletApp, String categoryName) throws PortalBizException {
        PortletApplicationDefinition appDefinition = null;
        try {
            this.logger.error("createPortlets===========begin");
            appDefinition = this.getPortletRegistryService().getPortletApplication("/" + portletApp.getName());
            this.logger.error("createPortlets===========begin222===");
            for (PortletDefinition portletdefinition : appDefinition.getPortlets()) {
                List<PortletCategory> list = this.portletCategoryService.getCategoryListByName(categoryName);
                if (list.size() <= 0) continue;
                this.savePortletDefinition(context, portletdefinition, portletApp.getId(), list.get(0).getId());
            }
            this.logger.error("createPortlets===========end");
        }
        catch (PortletContainerException pe) {
            pe.printStackTrace();
            this.logger.error(pe.getMessage());
            throw new PortalBizException(pe.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new PortalBizException(e.getMessage());
        }
        return null;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletRegistryService getPortletRegistryService() throws PortalBizException {
        return PlutoServices.getServices().getPortletRegistryService();
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition savePortletDefinition(PortalContext portalContext, PortletDefinition portletdefinition, String appId, String categoryId) throws PortalBizException {
        this.logger.error("portlet name : ---->" + portletdefinition.getPortletName());
        com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
        definition.setPortletAppId(appId);
        definition.setCategoryId(categoryId);
        definition.setAppName(portletdefinition.getApplication().getName().substring(1));
        definition.setPortletName(portletdefinition.getPortletName());
        definition.setPermViewCtrl(false);
        this.updateDisplayName(portletdefinition, definition);
        this.updatePltIcon(portletdefinition, definition);
        this.updateDescription(portletdefinition, definition);
        this.updatePortletType(portletdefinition, definition);
        this.updateSupports(portletdefinition, definition);
        this.updatePreferences(portletdefinition, definition);
        String key = portletdefinition.getPortletInfo().getKeywords();
        if (!StringUtil.isEmpty((String)key)) {
            definition.setKeywords("," + key + ",");
        } else {
            definition.setKeywords("," + definition.getAppName() + "," + definition.getPortletName() + ",");
        }
        definition.setPortalContext(portalContext);
        PortalProfile profile = this.portalProfileService.findPortalProfileByConfigItem("default_portlet_theme");
        if (profile != null) {
            definition.setThemeId(this.portalProfileService.findPortalProfileByConfigItem("default_portlet_theme").getConfigValue());
        }
        if ((profile = this.portalProfileService.findPortalProfileByConfigItem("default_portlet_tmpl")) != null) {
            definition.setTmplId(this.portalProfileService.findPortalProfileByConfigItem("default_portlet_tmpl").getConfigValue());
        }
        definition.setStatus(StatusEnum.DISABLE);
        definition.setCopy(false);
        definition.setResLevel(ResLevelEnum.EXT);
        try {
            return this.portletDefinitionDAO.create(definition);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition findPortletDefinitionByName(PortalContext portalContext, String appName, String portletName) throws PortalBizException {
        try {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition filter = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
            filter.setAppName(appName);
            filter.setPortletName(portletName);
            filter.setCopy(false);
            return this.portletDefinitionDAO.findObject(filter, new Filter[0]);
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("308");
        }
    }

    private void updatePreferences(PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) {
        Preferences prefs = portletdefinition.getPortletPreferences();
        if (prefs == null) {
            return;
        }
        List prefList = prefs.getPortletPreferences();
        if (prefList == null || prefList.size() <= 0) {
            return;
        }
        com.kingdee.portal.biz.common.json.Preferences preferences = new com.kingdee.portal.biz.common.json.Preferences();
        for (org.apache.pluto.container.om.portlet.Preference preference : prefList) {
            Preference pref = new Preference();
            pref.setName(preference.getName());
            pref.setValues(preference.getValues());
            preferences.addPreference(pref);
        }
        definition.setPreferences(preferences.toString());
    }

    private void updateDisplayName(PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) {
        String tempDisplayName = "";
        com.kingdee.portal.biz.common.json.DisplayName display = new com.kingdee.portal.biz.common.json.DisplayName();
        for (DisplayName displayName : portletdefinition.getDisplayNames()) {
            if ("en".equals(displayName.getLang())) {
                display.setEn(displayName.getDisplayName());
                tempDisplayName = displayName.getDisplayName();
                continue;
            }
            if ("zh-CN".equals(displayName.getLang())) {
                display.setZh_CN(displayName.getDisplayName());
                tempDisplayName = displayName.getDisplayName();
                continue;
            }
            if (!"zh-TW".equals(displayName.getLang())) continue;
            display.setZh_TW(displayName.getDisplayName());
            tempDisplayName = displayName.getDisplayName();
        }
        if (display.getZh_CN() == null) {
            display.setZh_CN(tempDisplayName);
        }
        if (display.getZh_TW() == null) {
            display.setZh_TW(tempDisplayName);
        }
        if (display.getEn() == null) {
            display.setEn(tempDisplayName);
        }
        definition.setDisplayName(display.toString());
    }

    private void updatePltIcon(PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) {
        if (portletdefinition.getInitParam("portlet-icon") != null) {
            String icon = portletdefinition.getInitParam("portlet-icon").getParamValue();
            definition.setIcon(icon);
        }
    }

    private void updateDescription(PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) {
        String tempDescription = "";
        Description desc = new Description();
        for (org.apache.pluto.container.om.portlet.Description description : portletdefinition.getDescriptions()) {
            if ("en".equals(description.getLang())) {
                desc.setEn(description.getDescription());
                tempDescription = description.getDescription();
            } else if ("zh-CN".equals(description.getLang())) {
                desc.setZh_CN(description.getDescription());
                tempDescription = description.getDescription();
            } else if ("zh-TW".equals(description.getLang())) {
                desc.setZh_TW(description.getDescription());
                tempDescription = description.getDescription();
            }
            if (desc.getZh_CN() == null) {
                desc.setZh_CN(tempDescription);
            }
            if (desc.getZh_TW() == null) {
                desc.setZh_TW(tempDescription);
            }
            if (desc.getEn() != null) continue;
            desc.setEn(tempDescription);
        }
        definition.setDescription(desc.toString());
    }

    private void updatePortletType(PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) {
        if (portletdefinition.getInitParam("portletType") != null) {
            definition.setPortletType(PortletTypeEnum.CONTAINER);
        } else {
            definition.setPortletType(PortletTypeEnum.NORMAL);
        }
    }

    private void updateSupports(PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) {
        com.kingdee.portal.biz.common.json.Supports support = new com.kingdee.portal.biz.common.json.Supports();
        for (Supports supports : portletdefinition.getSupports()) {
            support.setMimeType(supports.getMimeType());
            support.setPortletModes(supports.getPortletModes());
            support.setWindowStates(supports.getWindowStates());
        }
        definition.setSupports(support.toString());
    }

    @Override
    public void modifyPortletListStatus(PortalContext context, PortletApp app, StatusEnum status) throws PortalBizException {
        try {
            List portlets = this.portletDefinitionDAO.findList(new FieldFilter("appName", "=", app.getName()));
            for (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition portlet : portlets) {
                portlet.setPortalContext(context);
                portlet.setStatus(status);
            }
            this.portletDefinitionDAO.update(portlets);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException("304", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletModel findPortletDefinitionsByAppId(String appId) throws PortalBizException {
        PortletModel model = new PortletModel();
        List list = null;
        try {
            list = this.portletDefinitionDAO.findList(new Filter[]{new FieldFilter("portletAppId", "=", appId), new OrderFilter("portletName", OrderEnum.DESC)});
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        model.setPortletDefinitions(list);
        return model;
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition updateExistPortletDefinition(PortalContext portalContext, PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) throws PortalBizException {
        boolean isCopy = definition.getCopy();
        if (isCopy) {
            return this.updateCopyDefinition(portalContext, portletdefinition, definition);
        }
        return this.updateOriginalDefinition(portalContext, portletdefinition, definition);
    }

    private com.kingdee.portal.biz.module.portlet.entity.PortletDefinition updateCopyDefinition(PortalContext portalContext, PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) throws PortalBizException {
        this.logger.info("update copy portlet name: " + portletdefinition.getPortletName());
        this.updatePortletType(portletdefinition, definition);
        this.updateSupports(portletdefinition, definition);
        this.updatePreferences(portletdefinition, definition);
        definition.setPortalContext(portalContext);
        try {
            return this.portletDefinitionDAO.update(definition);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    private com.kingdee.portal.biz.module.portlet.entity.PortletDefinition updateOriginalDefinition(PortalContext portalContext, PortletDefinition portletdefinition, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) throws PortalBizException {
        this.logger.info("update portlet name: " + portletdefinition.getPortletName());
        this.updateDisplayName(portletdefinition, definition);
        this.updatePortletType(portletdefinition, definition);
        this.updatePltIcon(portletdefinition, definition);
        this.updateDescription(portletdefinition, definition);
        this.updateSupports(portletdefinition, definition);
        this.updatePreferences(portletdefinition, definition);
        definition.setKeywords("," + portletdefinition.getPortletInfo().getKeywords() + ",");
        definition.setPortalContext(portalContext);
        try {
            return this.portletDefinitionDAO.update(definition);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return definition;
        }
    }

    @Override
    public void deletePortletDefinition(PortalContext portalContext, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition) throws PortalBizException {
        try {
            this.portletDefinitionDAO.delete(definition);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deletePortletDefinitionByIds(PortalContext portalContext, String[] ids) throws PortalBizException {
        try {
            this.portletDefinitionDAO.deleteByIds(ids);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition modifyPortletDefinitionStatus(PortalContext context, String portletId) throws PortalBizException {
        com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition = null;
        try {
            definition = (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition)this.portletDefinitionDAO.findById(portletId);
            if (definition != null) {
                definition.setPortalContext(context);
                if (definition.getStatus().equals((Object)StatusEnum.ENABLE)) {
                    definition.setStatus(StatusEnum.DISABLE);
                } else {
                    definition.setStatus(StatusEnum.ENABLE);
                }
            }
            definition = this.portletDefinitionDAO.update(definition);
        }
        catch (DataAccessException e1) {
            e1.printStackTrace();
        }
        return definition;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public JSONObject findPortletListByAppId(PortalContext portalContext, String appId, String pageNo, String pageSize) throws PortalBizException {
        if (StringUtil.isEmpty((String)pageNo)) {
            pageNo = "1";
        }
        if (StringUtil.isEmpty((String)pageSize)) {
            pageSize = "8";
        }
        com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
        List<Object> list = new ArrayList();
        PagingParam pagingParam = new PagingParam(Integer.valueOf(pageNo), Integer.valueOf(pageSize));
        pagingParam.setOrder(OrderEnum.DESC);
        pagingParam.setSortField("portletName");
        if (StringUtil.isEmpty((String)appId) || appId.equals("null")) {
            PagingParam param = new PagingParam(Integer.valueOf(pageNo), Integer.valueOf(pageSize));
            param.setOrder(OrderEnum.DESC);
            param.setSortField("createTime");
            PagingResult<PortletApp> result = this.portletAppService.findPortletAppList(param);
            if (result.getRecords().size() > 0) {
                PortletApp p = result.getRecords().get(0);
                appId = p.getId();
            }
        }
        PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> page = null;
        try {
            page = this.portletDefinitionDAO.findList(pd, pagingParam, new FieldFilter("portletAppId", "=", appId));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        try {
            list = this.portletDefinitionDAO.findList(new FieldFilter("portletAppId", "=", appId));
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        page.setTotalCount(list.size());
        int total = page.getTotalCount();
        int pageNum = page.getPagingParam().getPageNo();
        int pageS = page.getPagingParam().getPageSize();
        int pageCount = (int)Math.ceil((double)total / (double)pageS);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"result", (Object)this.getJsonArra(portalContext, page));
        jsonObject.put((Object)"count", (Object)total);
        jsonObject.put((Object)"pageCount", (Object)this.judgeValue(pageCount, 1));
        jsonObject.put((Object)"pageNum", (Object)pageNum);
        jsonObject.put((Object)"pageSize", (Object)pageSize);
        return jsonObject;
    }

    private JSONArray getJsonArra(PortalContext portalContext, PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> page) {
        JSONArray jsonArray = new JSONArray();
        JSONObject obj = new JSONObject();
        List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> list = page.getRecords();
        for (int i = 0; i < list.size(); ++i) {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition definition = list.get(i);
            obj.put((Object)"id", (Object)definition.getId());
            obj.put((Object)"portletName", (Object)definition.getPortletName());
            obj.put((Object)"portletAppId", (Object)definition.getPortletAppId());
            obj.put((Object)"displayName", (Object)this.getPortletDisplayName(portalContext, definition.getDisplayName()));
            obj.put((Object)"pName", (Object)definition.getPortletName());
            obj.put((Object)"appName", (Object)definition.getAppName());
            obj.put((Object)"status", (Object)definition.getStatus());
            jsonArray.add((Object)obj);
        }
        return jsonArray;
    }

    private String getPortletDisplayName(PortalContext context, String jsonStr) {
        if (StringUtil.isEmpty((String)jsonStr)) {
            return "\u65e0\u540d\u79f0";
        }
        com.kingdee.portal.biz.common.json.DisplayName display = new com.kingdee.portal.biz.common.json.DisplayName(jsonStr);
        display.setLocale(context.getLocale().toString());
        return display.getLocaleText();
    }

    private int judgeValue(int value, int defaultValue) {
        if (value <= 0) {
            return defaultValue;
        }
        return value;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findPortletList(PortalContext cxt, PagingParam pagingParam, String appName, String labelName, String displayName) throws PortalBizException {
        PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pagingResult = new PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
        try {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
            pd.setResLevel(ResLevelEnum.EXT);
            List<PortletCategory> list = this.portletCategoryService.getCategoryListByName(labelName);
            PagingResult<Object[]> objPagingResult = null;
            objPagingResult = list.size() > 0 ? this.portletDefinitionDAO.findPortletList(cxt, pd, pagingParam, appName, displayName, list.get(0).getId()) : this.portletDefinitionDAO.findPortletList(cxt, pd, pagingParam, appName, displayName, "");
            List<Object[]> objList = objPagingResult.getRecords();
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> portletDefList = this.Obj2PortletDefinition(objList);
            pagingResult.setPagingParam(objPagingResult.getPagingParam());
            pagingResult.setTotalCount(objPagingResult.getTotalCount());
            pagingResult.setRecords(portletDefList);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return pagingResult;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<PortletDefinitionDTO> findPortletDTOList(PortalContext cxt, PagingParam pagingParam, String appName, String labelName, String displayName) throws PortalBizException {
        PagingResult<PortletDefinitionDTO> pagingResult = new PagingResult<PortletDefinitionDTO>();
        try {
            this.logger.info("appName=" + appName + ";labelName=" + labelName + ";displayName=" + displayName);
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
            pd.setResLevel(ResLevelEnum.EXT);
            PagingResult<Object[]> objPagingResult = null;
            List<PortletCategory> list = this.portletCategoryService.getCategoryListByName(labelName);
            objPagingResult = list.size() > 0 ? this.portletDefinitionDAO.findPortletList(cxt, pd, pagingParam, appName, displayName, list.get(0).getId()) : this.portletDefinitionDAO.findPortletList(cxt, pd, pagingParam, appName, displayName, "");
            pagingResult.setPagingParam(objPagingResult.getPagingParam());
            pagingResult.setTotalCount(objPagingResult.getTotalCount());
            HashMap<String, String> categoryId2Name = new HashMap<String, String>();
            ArrayList<PortletDefinitionDTO> records = new ArrayList<PortletDefinitionDTO>();
            List<Object[]> objList = objPagingResult.getRecords();
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> portletDefList = this.Obj2PortletDefinition(objList);
            for (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition portletDef : portletDefList) {
                String categoryName = (String)categoryId2Name.get(portletDef.getCategoryId());
                if (categoryName == null && portletDef.getCategoryId() != null) {
                    categoryName = this.getPortletCategoryNameById(portletDef.getCategoryId());
                    categoryId2Name.put(portletDef.getCategoryId(), categoryName);
                }
                if (categoryName == null) {
                    categoryName = "";
                }
                PortletDefinitionDTO portletDefDTO = new PortletDefinitionDTO(portletDef, categoryName);
                records.add(portletDefDTO);
            }
            pagingResult.setRecords(records);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return pagingResult;
    }

    private List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> Obj2PortletDefinition(List<Object[]> objList) {
        ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> portletDefinitionList = new ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
        for (Object[] obj : objList) {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition p = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
            p.setId(obj[0].toString());
            p.setPortletAppId(obj[1].toString());
            p.setAppName(obj[2] == null ? "" : obj[2].toString());
            p.setPortletName(obj[3] == null ? "" : obj[3].toString());
            p.setDisplayName(obj[4] == null ? "" : obj[4].toString());
            p.setDescription(obj[5] == null ? "" : obj[5].toString());
            p.setCategoryId(obj[6] == null ? null : obj[6].toString());
            if (obj[7].toString().equals(StatusEnum.DISABLE.toString())) {
                p.setStatus(StatusEnum.DISABLE);
            } else {
                p.setStatus(StatusEnum.ENABLE);
            }
            if (obj[8].toString().equals("0")) {
                p.setCopy(false);
            } else {
                p.setCopy(true);
            }
            p.setPreferences(obj[9] == null ? null : obj[9].toString());
            portletDefinitionList.add(p);
        }
        return portletDefinitionList;
    }

    private String getPortletCategoryNameById(String categoryId) throws PortalBizException {
        PortletCategory category = new PortletCategory();
        category.setId(categoryId);
        category = this.portletCategoryService.findCategoryById(category);
        if (category != null) {
            return category.getCategoryName();
        }
        return "";
    }

    @Override
    public PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findCopyPortletList(PortalContext context, String appName, String portletName, String displayName, PagingParam pagingParam) throws PortalBizException {
        try {
            return this.portletDefinitionDAO.findCopyPortletList(appName, portletName, displayName, pagingParam);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition modifyPortlet(PortalContext context, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd) throws PortalBizException {
        try {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition oldPd = this.findPortletDefinitionById(pd.getId());
            oldPd.setPortalContext(context);
            oldPd.setDisplayName(pd.getDisplayName());
            oldPd.setDescription(pd.getDescription());
            oldPd.setPermViewCtrl(pd.getPermViewCtrl());
            if (pd.getTmplId() != null) {
                oldPd.setTmplId(pd.getTmplId());
            }
            if (pd.getPreferences() != null) {
                oldPd.setPreferences(pd.getPreferences());
            }
            if (!StringUtil.isEmpty((String)pd.getIcon())) {
                oldPd.setIcon(pd.getIcon());
            }
            return this.portletDefinitionDAO.update(oldPd);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition findPortletDefinitionById(String id) throws PortalBizException {
        try {
            return (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition)this.portletDefinitionDAO.findById(id);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findPortletDefinitionByIds(String[] ids) throws PortalBizException {
        try {
            return this.portletDefinitionDAO.findListByIds(ids);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findEnablePltList(PortalContext context, PagingParam pagingParam, String categoryName, String displayName) throws PortalBizException {
        PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pagingResult = null;
        try {
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pltList = this.findPltList4Perm(context, categoryName, displayName);
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> permList = this.permService.findPermPortletList(context, pltList, context.getLoginUser().getId());
            int totalCount = 0;
            if (permList != null) {
                totalCount = permList.size();
            }
            int totalPage = (totalCount - 1) / pagingParam.getPageSize() + 1;
            if (pagingParam.getPageNo() > totalPage) {
                pagingParam.setPageNo(totalPage);
            }
            ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> returnList = new ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
            int maxresult = pagingParam.getPageNo() * pagingParam.getPageSize();
            if (maxresult > totalCount) {
                maxresult = totalCount;
            }
            for (int i = pagingParam.getStartIndex(); i < maxresult; ++i) {
                returnList.add(permList.get(i));
            }
            pagingResult = new PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>(pagingParam, totalCount, returnList);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return pagingResult;
    }

    private List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findPltList4Perm(PortalContext context, String categoryName, String displayName) throws PortalBizException {
        try {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
            displayName = !displayName.equals("") ? "%" + context.getLocale().toString() + "%" + displayName + "%" : "%%";
            pd.setResLevel(ResLevelEnum.EXT);
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pltList = null;
            List<PortletCategory> list = this.portletCategoryService.getCategoryListByName(categoryName);
            pltList = list.size() > 0 ? this.portletDefinitionDAO.findList(pd, new FieldFilter("status", "=", (Object)StatusEnum.ENABLE), new FieldFilter("categoryId", "=", list.get(0).getId()), new FieldFilter("displayName", "like", displayName)) : this.portletDefinitionDAO.findList(pd, new FieldFilter("status", "=", (Object)StatusEnum.ENABLE), new FieldFilter("displayName", "like", displayName));
            final String locale = context.getLocale().toString();
            Collections.sort(pltList, new Comparator<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>(){

                @Override
                public int compare(com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd1, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd2) {
                    String dn1 = PortletDefinitionServiceImpl.this.getLocaleDisplayName(locale, pd1.getDisplayName()).toLowerCase();
                    String dn2 = PortletDefinitionServiceImpl.this.getLocaleDisplayName(locale, pd2.getDisplayName()).toLowerCase();
                    return dn1.compareTo(dn2);
                }
            });
            return pltList;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private String getLocaleDisplayName(String locale, String displayName) {
        com.kingdee.portal.biz.common.json.DisplayName dn = new com.kingdee.portal.biz.common.json.DisplayName(displayName, locale);
        return dn.getLocaleText();
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findEnablePltList(PortalContext context, String userId) throws PortalBizException {
        try {
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pltList = this.findPltList4Perm(context, "", "");
            return this.permService.findPermPortletList(context, pltList, userId);
        }
        catch (PortalBizException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition bulidNewPortlet(PortalContext context, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd) throws PortalBizException {
        try {
            List pdList = this.portletDefinitionDAO.findList(new Filter[]{new FieldFilter("appName", "=", "plt_widget"), new FieldFilter("portletName", "=", "IntegrateViewPortlet")});
            if (pdList == null) {
                throw new PortalBizException("309");
            }
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition oldPd = (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition)pdList.get(0);
            pd.setAppName("plt_widget");
            pd.setPortletAppId(oldPd.getPortletAppId());
            pd.setPortletName("IntegrateViewPortlet");
            pd.setTmplId(oldPd.getTmplId());
            pd.setThemeId(oldPd.getThemeId());
            pd.setIcon(oldPd.getIcon());
            pd.setKeywords(oldPd.getKeywords());
            pd.setStatus(StatusEnum.ENABLE);
            pd.setCopy(true);
            pd.setSupports(oldPd.getSupports());
            pd.setPortletType(oldPd.getPortletType());
            pd.setPermViewCtrl(oldPd.getPermViewCtrl());
            pd.setResLevel(oldPd.getResLevel());
            pd.setPortalContext(context);
            this.portletDefinitionDAO.create(pd);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
        return null;
    }

    public void setPortalProfileService(SettingService portalProfileService) {
        this.portalProfileService = portalProfileService;
    }

    public void setPortletDefinitionDAO(PortletDefinitionDAO portletDefinitionDAO) {
        this.portletDefinitionDAO = portletDefinitionDAO;
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition copyPortletDefinition(PortalContext portalContext, String appName, String portletName, PortletParam params) throws PortalBizException {
        return this.copyPortletDefinition(portalContext, appName, portletName, params, null);
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition copyPortletDefinition(PortalContext portalContext, String appName, String portletName, PortletParam params, String categoryId) throws PortalBizException {
        try {
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> src = this.findPortletByName(portalContext, appName, portletName);
            int size = src.size();
            if (size <= 0) {
                throw new PortalBizException("\u6ca1\u6709\u627e\u5230" + appName + "\u4e0b\u7684" + portletName + "\u5b9a\u4e49");
            }
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition target = this.copyFromSrc(portalContext, src.get(0));
            this.markCopy(target, this.createCopyMark(size));
            if (portletName.equals("BaiduPortlet")) {
                target.setKeywords(",plt_widget,\u767e\u5ea6\u5c0f\u5de5\u5177,");
            } else if (portletName.equals("GooglePortlet")) {
                target.setKeywords(",plt_widget,IGoogle\u5c0f\u5de5\u5177,");
            }
            target.setResLevel(ResLevelEnum.EXT);
            this.updateProperties(target, params);
            if (categoryId != null && categoryId.length() > 0) {
                target.setCategoryId(categoryId);
            }
            target.setThemeId(this.getDefaultTheme());
            target.setTmplId(this.getDefaultTmpl());
            return this.portletDefinitionDAO.create(target);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u6ca1\u6709\u627e\u5230" + appName + "\u4e0b\u7684" + portletName + "\u5b9a\u4e49");
        }
    }

    private String getDefaultTmpl() {
        String result = null;
        try {
            PortalProfile pf = this.settingService.findPortalProfileByConfigItem("default_portlet_tmpl");
            if (pf != null) {
                result = pf.getConfigValue();
            }
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    private String getDefaultTheme() {
        String result = null;
        try {
            PortalProfile pf = this.settingService.findPortalProfileByConfigItem("default_portlet_theme");
            if (pf != null) {
                result = pf.getConfigValue();
            }
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
            e.printStackTrace();
        }
        return result;
    }

    private List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findPortletByName(PortalContext portalContext, String appName, String portletName) throws DataAccessException {
        com.kingdee.portal.biz.module.portlet.entity.PortletDefinition filter = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
        filter.setAppName(appName);
        filter.setPortletName(portletName);
        filter.setCopy(false);
        return this.portletDefinitionDAO.findList(filter, new Filter[0]);
    }

    private com.kingdee.portal.biz.module.portlet.entity.PortletDefinition copyFromSrc(PortalContext portalContext, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition src) {
        com.kingdee.portal.biz.module.portlet.entity.PortletDefinition target = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
        BeanUtils.copyProperties((Object)src, (Object)target);
        target.setId(null);
        target.setPortalContext(portalContext);
        return target;
    }

    private String createCopyMark(int portletSize) {
        if (portletSize == 1) {
            return "";
        }
        StringBuilder sb = new StringBuilder(100);
        sb.append("(").append(portletSize).append(")");
        return sb.toString();
    }

    private void updateProperties(com.kingdee.portal.biz.module.portlet.entity.PortletDefinition target, PortletParam params) {
        com.kingdee.portal.biz.common.json.Preferences pref;
        Description desc;
        if (params == null) {
            return;
        }
        com.kingdee.portal.biz.common.json.DisplayName name = params.getDisplayName();
        if (name != null) {
            target.setDisplayName(name.toString());
        }
        if ((desc = params.getDescription()) != null) {
            target.setDescription(desc.toString());
        }
        if (!StringUtil.isEmpty((String)params.getIcon())) {
            target.setIcon(params.getIcon());
        }
        if (!StringUtil.isEmpty((String)params.getCategoryId())) {
            target.setCategoryId(params.getCategoryId());
        }
        if (params.getStatus() != null) {
            target.setStatus(params.getStatus());
        }
        if (params.getSupports() != null) {
            target.setSupports(params.getSupports().toString());
        }
        if ((pref = params.getPreferences()) != null) {
            target.setPreferences(pref.toString());
        }
    }

    private void markCopy(com.kingdee.portal.biz.module.portlet.entity.PortletDefinition target, String copyTag) {
        com.kingdee.portal.biz.common.json.DisplayName name = new com.kingdee.portal.biz.common.json.DisplayName(target.getDisplayName());
        name.setEn("CopyOf" + copyTag + " " + name.getEn());
        name.setZh_CN("\u590d\u4ef6" + copyTag + " " + name.getZh_CN());
        name.setZh_TW("\u8907\u4ef6" + copyTag + " " + name.getZh_TW());
        target.setDisplayName(name.toString());
        target.setCopy(true);
        target.setResLevel(ResLevelEnum.EXT);
    }

    @Override
    public void copyOne2ManyPortletDefinition(PortalContext portalContext, String appName, String portletName, PortletParam[] params) throws PortalBizException {
        try {
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> src = this.findPortletByName(portalContext, appName, portletName);
            int size = src.size();
            if (size <= 0) {
                throw new PortalBizException("\u6ca1\u6709\u627e\u5230" + appName + "\u4e0b\u7684" + portletName + "\u5b9a\u4e49");
            }
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition target = null;
            for (PortletParam param : params) {
                target = this.copyFromSrc(portalContext, src.get(0));
                if ("EASPortlet".equalsIgnoreCase(src.get(0).getPortletName()) && "plt_widget".equalsIgnoreCase(src.get(0).getAppName())) {
                    target.setCategoryId("fb576e97-7bc1-4120-a8f3-1c7aed25a37d");
                }
                this.markCopy(target, this.createCopyMark(size++));
                this.updateProperties(target, param);
                this.portletDefinitionDAO.create(target);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("\u6ca1\u6709\u627e\u5230" + appName + "\u4e0b\u7684" + portletName + "\u5b9a\u4e49");
        }
    }

    @Override
    public void delPortletDefinitionById(PortalContext context, String pltId) throws PortalBizException {
        try {
            this.portletDefinitionDAO.deleteById(pltId);
            this.portletService.deletePltInstanceAndPrefencesByDefId(context, pltId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition findPltByPageId(PortalContext context, String pageId) throws PortalBizException {
        try {
            String pid = "";
            if (pageId != null) {
                pid = "%" + pageId + "%";
            }
            return (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition)this.portletDefinitionDAO.findObject(new FieldFilter("preferences", "like", pid));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public com.kingdee.portal.biz.module.portlet.entity.PortletDefinition updatePortlet(PortalContext context, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pd) throws PortalBizException {
        try {
            return this.portletDefinitionDAO.update(pd);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findPortletDefinitionList(PortalContext context, com.kingdee.portal.biz.module.portlet.entity.PortletDefinition portletDefinition) throws PortalBizException {
        try {
            return this.portletDefinitionDAO.findList(portletDefinition, new Filter[0]);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean hasUsed4Icon(PortalContext context, String icon) throws PortalBizException {
        try {
            com.kingdee.portal.biz.module.portlet.entity.PortletDefinition portletDef = new com.kingdee.portal.biz.module.portlet.entity.PortletDefinition();
            portletDef.setIcon(icon);
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> portletDefList = this.portletDefinitionDAO.findList(portletDef, new Filter[0]);
            if (portletDefList != null && portletDefList.size() > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
        return false;
    }

    @Override
    public void updateTmplIdByTmpilId(PortalContext context, String tmplId, String newTmplId) throws PortalBizException {
        try {
            this.portletDefinitionDAO.updateTmplIdByTmpilId(context, tmplId, newTmplId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    public void setPortletService(PortletService portletService) {
        this.portletService = portletService;
    }

    public void setPermService(PermService permService) {
        this.permService = permService;
    }

    public void setPortletAppService(PortletAppService portletAppService) {
        this.portletAppService = portletAppService;
    }

    public void setPortletCategoryService(PortletCategoryService portletCategoryService) {
        this.portletCategoryService = portletCategoryService;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }

    @Override
    public PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findEnableCardList(PortalContext context, PagingParam pagingParam, String type, String name) throws PortalBizException {
        PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pagingResult = null;
        try {
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pltList = this.findCardList4Perm(context, type, name);
            List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> permList = this.permService.findPermPortletList(context, pltList, context.getLoginUser().getId());
            int totalCount = 0;
            if (permList != null) {
                totalCount = permList.size();
            }
            int totalPage = (totalCount - 1) / pagingParam.getPageSize() + 1;
            if (pagingParam.getPageNo() > totalPage) {
                pagingParam.setPageNo(totalPage);
            }
            ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> returnList = new ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
            int maxresult = pagingParam.getPageNo() * pagingParam.getPageSize();
            if (maxresult > totalCount) {
                maxresult = totalCount;
            }
            for (int i = pagingParam.getStartIndex(); i < maxresult; ++i) {
                returnList.add(permList.get(i));
            }
            pagingResult = new PagingResult<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>(pagingParam, totalCount, returnList);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return pagingResult;
    }

    private List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> findCardList4Perm(PortalContext context, String type, String displayName) throws PortalBizException {
        try {
            displayName = !displayName.equals("") ? "%" + context.getLocale().toString() + "%" + displayName + "%" : "%%";
            List<CardCategory> categorys = this.getCardCategoryService().findCategoriesByTypes(type);
            if (categorys.size() == 0) {
                return new ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
            }
            String[] parentIds = new String[categorys.size()];
            for (int i = 0; i < categorys.size(); ++i) {
                parentIds[i] = categorys.get(i).getId();
            }
            List<CardSecondCategory> secondCategories = this.cardSecondCategoryService.findAllCardSecondCategoryByParent(parentIds);
            if (secondCategories.size() < 1) {
                return new ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
            }
            String[] secondCategoriesIds = new String[secondCategories.size()];
            ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> pltList = new ArrayList<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition>();
            for (int i = 0; i < secondCategories.size(); ++i) {
                secondCategoriesIds[i] = secondCategories.get(i).getId();
                List<CardSecondCategoryEntry> entries = this.cardSecondCategoryEntryService.findCardSecondCategoryEntryByParent(new String[]{secondCategoriesIds[i]});
                String[] portletNames = new String[entries.size()];
                for (int j = 0; j < entries.size(); ++j) {
                    String portletName;
                    portletNames[j] = portletName = entries.get(j).getPortletName();
                }
                List<com.kingdee.portal.biz.module.portlet.entity.PortletDefinition> tmpPltList = this.portletDefinitionDAO.findStatusCardList(portletNames, displayName, StatusEnum.ENABLE);
                for (com.kingdee.portal.biz.module.portlet.entity.PortletDefinition pdf : tmpPltList) {
                    pdf.setCategoryName(secondCategories.get(i).getName());
                    pdf.setIcon(secondCategories.get(i).getIcon());
                }
                pltList.addAll(tmpPltList);
            }
            return pltList;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    public CardSecondCategoryService getCardSecondCategoryService() {
        return this.cardSecondCategoryService;
    }

    public void setCardSecondCategoryService(CardSecondCategoryService cardSecondCategoryService) {
        this.cardSecondCategoryService = cardSecondCategoryService;
    }

    public CardCategoryService getCardCategoryService() {
        return this.cardCategoryService;
    }

    public void setCardCategoryService(CardCategoryService cardCategoryService) {
        this.cardCategoryService = cardCategoryService;
    }

    public CardSecondCategoryEntryService getCardSecondCategoryEntryService() {
        return this.cardSecondCategoryEntryService;
    }

    public void setCardSecondCategoryEntryService(CardSecondCategoryEntryService cardSecondCategoryEntryService) {
        this.cardSecondCategoryEntryService = cardSecondCategoryEntryService;
    }
}

