/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.PortletIns;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.json.Supports;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.portlet.common.util.PortletHelper;
import com.kingdee.portal.biz.module.portlet.dao.PortletInstanceDAO;
import com.kingdee.portal.biz.module.portlet.dao.PortletRuntimePreferencesDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.entity.PortletInstance;
import com.kingdee.portal.biz.module.portlet.entity.PortletRuntimePreferences;
import com.kingdee.portal.biz.module.portlet.entity.PortletTheme;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.biz.module.portlet.service.PortletThemeService;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.JSONUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletServiceImpl
implements PortletService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletDefinitionService portletDefinitionService;
    private PortletThemeService portletThemeService;
    private PortletInstanceDAO portletInstanceDAO;
    private PortletRuntimePreferencesDAO portletRuntimePreferencesDAO;
    private PortletCategoryService portletCategoryService;
    private PageService pageService;
    private SettingService settingService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, Object> findPortletInfoMap(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        HashMap<String, Object> insMap = new HashMap<String, Object>();
        try {
            PortletInstance queryInstance = new PortletInstance();
            queryInstance.setPageId(pageId);
            queryInstance.setUserId(userId);
            List<PortletInstance> insList = this.portletInstanceDAO.findList(queryInstance, new OrderFilter("area", OrderEnum.ASC), new OrderFilter("orderNum", OrderEnum.ASC));
            String[] pltInsIds = new String[insList.size()];
            for (int i = 0; i < insList.size(); ++i) {
                pltInsIds[i] = insList.get(i).getId();
            }
            List<PortletRuntimePreferences> runtimeList = this.portletRuntimePreferencesDAO.findRuntimeListByInsId(pltInsIds);
            insMap.put("pltInsList", insList);
            insMap.put("pltRuntimePrefList", runtimeList);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
        return insMap;
    }

    @Override
    public void deletePersonalData4Admin(PortalContext ctx, String pageId) throws PortalBizException {
    }

    private boolean isExisted4PortletDefinition(String pltDefId, List<PortletDefinition> pltDefList) {
        boolean isExisted = false;
        if (pltDefList != null) {
            for (PortletDefinition definition : pltDefList) {
                if (!pltDefId.equals(definition.getId())) continue;
                isExisted = true;
                break;
            }
        }
        return isExisted;
    }

    private List<PortletInstance> filterInvalidPortletInstance(List<PortletInstance> pltInsList, List<PortletDefinition> pltDefList) {
        ArrayList<PortletInstance> tempPltInsList = new ArrayList<PortletInstance>();
        if (pltInsList != null) {
            for (PortletInstance pltIns : pltInsList) {
                if (!this.isExisted4PortletDefinition(pltIns.getDefinitionId(), pltDefList)) continue;
                tempPltInsList.add(pltIns);
            }
        }
        return tempPltInsList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletIns> buildPortletInsList(PortalContext ctx, List<PortletInstance> pltInsList) throws PortalBizException {
        ArrayList<PortletIns> pltInsInfoList = new ArrayList<PortletIns>();
        String[] pltDefIds = new String[pltInsList.size()];
        for (int i = 0; i < pltInsList.size(); ++i) {
            pltDefIds[i] = pltInsList.get(i).getDefinitionId();
        }
        List<PortletDefinition> pltDefList = this.portletDefinitionService.findPortletDefinitionByIds(pltDefIds);
        pltInsList = this.filterInvalidPortletInstance(pltInsList, pltDefList);
        HashMap<String, PortletDefinition> pltMap = new HashMap<String, PortletDefinition>();
        for (PortletDefinition definition : pltDefList) {
            pltMap.put(definition.getId(), definition);
        }
        String[] pltThemeIds = new String[pltInsList.size()];
        int theLength = 0;
        for (int i = 0; i < pltInsList.size(); ++i) {
            String themeId = pltInsList.get(i).getThemeId();
            if (StringUtil.isEmpty((String)themeId)) continue;
            pltThemeIds[i] = pltInsList.get(i).getThemeId();
            ++theLength;
        }
        List<PortletTheme> pltThemeList = null;
        if (theLength > 0) {
            String[] themeIds = new String[theLength];
            for (int i = 0; i < theLength; ++i) {
                themeIds[i] = pltThemeIds[i];
            }
            pltThemeList = this.portletThemeService.findThemeListByIds(pltThemeIds);
        }
        HashMap<String, PortletTheme> themeMap = new HashMap<String, PortletTheme>();
        if (pltThemeList != null) {
            for (PortletTheme theme : pltThemeList) {
                themeMap.put(theme.getId(), theme);
            }
        }
        HashMap<String, String> tmplMap = new HashMap<String, String>();
        if (pltInsList != null) {
            List<PortletTmpl> tmplList = PortalCache.getEnabledPortletTmplList();
            for (PortletInstance tmplPltIns : pltInsList) {
                tmplMap.put(tmplPltIns.getTmplId(), PortletHelper.getPortletTmplCode(tmplPltIns.getTmplId(), tmplList));
            }
        }
        for (PortletInstance instance : pltInsList) {
            pltInsInfoList.add(this.buildPortletIns(instance, pltMap, themeMap, tmplMap));
        }
        return pltInsInfoList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletIns> buildPortletInsList(PortalContext ctx, String pageId, String userId) throws PortalBizException {
        ArrayList<PortletIns> pltInsInfoList = new ArrayList();
        try {
            PortletInstance queryInstance = new PortletInstance();
            queryInstance.setPageId(pageId);
            queryInstance.setUserId(userId);
            List<PortletInstance> pltInsList = this.portletInstanceDAO.findList(queryInstance, new OrderFilter("area", OrderEnum.ASC), new OrderFilter("orderNum", OrderEnum.ASC));
            pltInsInfoList = this.buildPortletInsList(ctx, pltInsList);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
        return pltInsInfoList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletInstance findPortletInsById(PortalContext ctx, String portletInsId) throws PortalBizException {
        try {
            PortletInstance portletIns = (PortletInstance)this.portletInstanceDAO.findById(portletInsId);
            return portletIns;
        }
        catch (DataAccessException ex) {
            throw new PortalBizException("300", ex);
        }
    }

    private PortletIns buildPortletIns(PortletInstance instance, Map<String, PortletDefinition> pltMap, Map<String, PortletTheme> themeMap, Map<String, String> tmplMap) {
        PortletTheme portletTheme;
        PortletIns pltIns = new PortletIns();
        pltIns.setInsId(instance.getId());
        PortletDefinition portletDef = pltMap.get(instance.getDefinitionId());
        pltIns.setPortletName(portletDef.getPortletName());
        pltIns.setAppName(portletDef.getAppName());
        pltIns.setDefGsPosition(portletDef.getGsPosition());
        pltIns.setDisplayName(new DisplayName(instance.getDisplayName()));
        if (themeMap != null && themeMap.size() > 0 && (portletTheme = themeMap.get(instance.getThemeId())) != null) {
            pltIns.setTheme(portletTheme.getCode());
        }
        pltIns.setArea(instance.getArea());
        pltIns.setDefId(instance.getDefinitionId());
        Supports supports = (Supports)JSONUtil.getObject4Json((String)portletDef.getSupports(), Supports.class);
        pltIns.setPortletModes(supports.getPortletModes());
        pltIns.setHeight(instance.getHeight());
        pltIns.setTmpl(tmplMap.get(instance.getTmplId()));
        pltIns.setInner(instance.getInner());
        pltIns.setPortletType(instance.getPortletType());
        pltIns.setGsPosition(instance.getGsPosition());
        return pltIns;
    }

    @Override
    public PortletInstance createPortletInstance(PortalContext ctx, PortletInstance instance) throws PortalBizException {
        try {
            return this.portletInstanceDAO.create(instance);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public List<PortletInstance> batchCreatePortletInstance(PortalContext ctx, List<PortletInstance> instances) throws PortalBizException {
        try {
            return this.portletInstanceDAO.create(instances);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public PortletInstance updatePortletInstance(PortalContext ctx, PortletInstance instance) throws PortalBizException {
        try {
            instance.setPortalContext(ctx);
            return this.portletInstanceDAO.update(instance);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public List<PortletInstance> batchUpdatePortletInstance(PortalContext ctx, List<PortletInstance> instances) throws PortalBizException {
        try {
            return this.portletInstanceDAO.update(instances);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deletePortletInstance(PortalContext ctx, PortletInstance portletInstance) throws PortalBizException {
        try {
            this.portletInstanceDAO.delete(portletInstance);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deletePortletInstanceByIds(PortalContext ctx, String[] portletInsIds) throws PortalBizException {
        try {
            this.portletInstanceDAO.deleteByIds(portletInsIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deletePortletInsPersonalExt(PortalContext ctx, String insId) throws PortalBizException {
    }

    @Override
    public PortletRuntimePreferences createPortletRuntimePreferences(PortalContext ctx, PortletRuntimePreferences instances) throws PortalBizException {
        try {
            instances.setPortalContext(ctx);
            return this.portletRuntimePreferencesDAO.create(instances);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public List<PortletRuntimePreferences> batchCreatePortletRuntimePreferences(PortalContext ctx, List<PortletRuntimePreferences> instances) throws PortalBizException {
        try {
            return this.portletRuntimePreferencesDAO.create(instances);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public PortletRuntimePreferences updatePortletRuntimePreferences(PortalContext ctx, PortletRuntimePreferences instances) throws PortalBizException {
        try {
            return this.portletRuntimePreferencesDAO.update(instances);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public List<PortletRuntimePreferences> batchUpdatePortletRuntimePreferences(PortalContext ctx, List<PortletRuntimePreferences> instances) throws PortalBizException {
        try {
            return this.portletRuntimePreferencesDAO.update(instances);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deletePortletRuntimePreferences(PortalContext ctx, PortletRuntimePreferences prp) throws PortalBizException {
        try {
            this.portletRuntimePreferencesDAO.delete(prp);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deletePortletRuntimePreferencesByIds(PortalContext ctx, String[] runtimeIds) throws PortalBizException {
        try {
            this.portletRuntimePreferencesDAO.deleteByIds(runtimeIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deletePltInsAllByPageIds(PortalContext ctx, String[] ids) throws PortalBizException {
        try {
            List<PortletInstance> insList;
            if (ids != null && (insList = this.findPltInsListByPageIds(ids)) != null) {
                String[] insIds = new String[insList.size()];
                for (int i = 0; i < insList.size(); ++i) {
                    insIds[i] = insList.get(i).getId();
                }
                List<PortletRuntimePreferences> runtimeList = this.portletRuntimePreferencesDAO.findRuntimeListByInsId(insIds);
                String[] rtIds = new String[runtimeList.size()];
                for (int k = 0; k < runtimeList.size(); ++k) {
                    rtIds[k] = runtimeList.get(k).getId();
                }
                this.deletePortletRuntimePreferencesByIds(ctx, rtIds);
                this.deletePortletInstanceByIds(ctx, insIds);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private List<PortletInstance> findPltInsListByPageIds(String[] ids) throws PortalBizException {
        try {
            List<PortletInstance> insList = this.portletInstanceDAO.findPltInsListByPageIds(ids);
            return insList;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Preferences findPortletInsPreferences(PortalContext context, String portletInsId) throws PortalBizException {
        try {
            Preferences preferences = null;
            PortletRuntimePreferences rt = (PortletRuntimePreferences)this.portletRuntimePreferencesDAO.findObject(new FieldFilter("insId", "=", portletInsId));
            if (rt != null && !StringUtil.isEmpty((String)rt.getPreferences())) {
                preferences = PortletHelper.convPreferences(rt.getPreferences());
            }
            return preferences;
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void modifyBaiduTmplTools(PortalContext ctx, String insId, String displayName, String smode, String surl) throws PortalBizException {
        try {
            Preferences preferences;
            PortletInstance instance = (PortletInstance)this.portletInstanceDAO.findById(insId);
            instance.setDisplayName(displayName);
            this.portletInstanceDAO.update(instance);
            PortletRuntimePreferences prefs = (PortletRuntimePreferences)this.portletRuntimePreferencesDAO.findObject(new FieldFilter("", "", insId));
            if (prefs != null) {
                preferences = PortletHelper.convPreferences(prefs.getPreferences());
                if (preferences != null) {
                    ArrayList<String> modes = new ArrayList<String>();
                    modes.add(smode);
                    ArrayList<String> urls = new ArrayList<String>();
                    urls.add(surl);
                    ArrayList<String> displayNames = new ArrayList<String>();
                    displayNames.add(displayName);
                    for (int i = 0; i < preferences.getPreferences().size(); ++i) {
                        if (preferences.getPreferences().get(i).getName().equals("importMode")) {
                            preferences.getPreferences().get(i).setValues(modes);
                        }
                        if (preferences.getPreferences().get(i).getName().equals("address")) {
                            preferences.getPreferences().get(i).setValues(urls);
                        }
                        if (!preferences.getPreferences().get(i).getName().equals("displayName")) continue;
                        preferences.getPreferences().get(i).setValues(displayNames);
                    }
                } else {
                    preferences = new Preferences();
                    preferences.addPreference(new Preference("importMode", smode));
                    preferences.addPreference(new Preference("address", surl));
                    preferences.addPreference(new Preference("displayName", displayName));
                }
            } else {
                throw new PortalBizException("310");
            }
            prefs.setPreferences(preferences.toString());
            this.portletRuntimePreferencesDAO.update(prefs);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private Map<String, Object> createPersonalPltIns4User(PortalContext context, String portletInsId, String userId) throws DataAccessException {
        HashMap<String, Object> insExtMapInfo = new HashMap<String, Object>();
        return insExtMapInfo;
    }

    @Override
    public PortletInstance updatePltInsOutlook(PortalContext context, PortletInstance pltIns) throws PortalBizException {
        try {
            PortletInstance pltInsDatabase = (PortletInstance)this.portletInstanceDAO.findById(pltIns.getId());
            pltInsDatabase.setDisplayName(pltIns.getDisplayName());
            pltInsDatabase.setThemeId(pltIns.getThemeId());
            pltInsDatabase.setTmplId(pltIns.getTmplId());
            pltInsDatabase.setHeight(pltIns.getHeight());
            pltInsDatabase.setPortalContext(context);
            this.portletInstanceDAO.update(pltInsDatabase);
            return pltInsDatabase;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void updatePortletPreferences(PortalContext context, String pltInsId, Preferences preferences) throws PortalBizException {
        try {
            PortletRuntimePreferences portletRuntimePreferences = this.findPortletRuntimePreferencesByInsId(context, pltInsId);
            if (portletRuntimePreferences != null) {
                portletRuntimePreferences.setPreferences(preferences.toString());
                portletRuntimePreferences.setPortalContext(context);
                this.portletRuntimePreferencesDAO.update(portletRuntimePreferences);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private PortletRuntimePreferences updatePltInsPrePUser(PortalContext context, PortletRuntimePreferences oldrt, String userId, Preferences preferences) throws PortalBizException {
        try {
            PortletRuntimePreferences newRt = new PortletRuntimePreferences();
            return newRt;
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void resetDefaultOutlook4ViewMode(PortalContext context, String portletInsId) throws PortalBizException {
        try {
            PortletInstance personalPltIns = (PortletInstance)this.portletInstanceDAO.findById(portletInsId);
            if (!StringUtil.isEmpty((String)personalPltIns.getRefInsId())) {
                PortletInstance adminPltIns = (PortletInstance)this.portletInstanceDAO.findById(personalPltIns.getRefInsId());
                personalPltIns.setDisplayName(adminPltIns.getDisplayName());
                personalPltIns.setThemeId(adminPltIns.getThemeId());
                personalPltIns.setTmplId(adminPltIns.getTmplId());
                personalPltIns.setHeight(adminPltIns.getHeight());
                personalPltIns.setPortalContext(context);
                this.portletInstanceDAO.update(personalPltIns);
            } else {
                PortletDefinition pltDef = this.portletDefinitionService.findPortletDefinitionById(personalPltIns.getDefinitionId());
                personalPltIns.setDisplayName(pltDef.getDisplayName());
                personalPltIns.setThemeId(pltDef.getThemeId());
                personalPltIns.setTmplId(pltDef.getTmplId());
                personalPltIns.setHeight("auto");
                personalPltIns.setPortalContext(context);
                this.portletInstanceDAO.update(personalPltIns);
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void resetDefaultOutlook4EditMode(PortalContext context, PortletInstance personalPltIns) throws PortalBizException {
        try {
            if (!StringUtil.isEmpty((String)personalPltIns.getRefInsId())) {
                PortletInstance adminPltIns = (PortletInstance)this.portletInstanceDAO.findById(personalPltIns.getRefInsId());
                personalPltIns.setDisplayName(adminPltIns.getDisplayName());
                personalPltIns.setThemeId(adminPltIns.getThemeId());
                personalPltIns.setTmplId(adminPltIns.getTmplId());
                personalPltIns.setHeight(adminPltIns.getHeight());
            } else {
                PortletDefinition pltDef = this.portletDefinitionService.findPortletDefinitionById(personalPltIns.getDefinitionId());
                personalPltIns.setDisplayName(pltDef.getDisplayName());
                personalPltIns.setThemeId(pltDef.getThemeId());
                personalPltIns.setTmplId(pltDef.getTmplId());
                personalPltIns.setHeight("auto");
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletInstance findPortletInstance4DefaultOutlook(PortalContext context, String portletInsId) throws PortalBizException {
        try {
            PortletInstance result = null;
            PortletInstance personalPltIns = (PortletInstance)this.portletInstanceDAO.findById(portletInsId);
            if (!StringUtil.isEmpty((String)personalPltIns.getRefInsId())) {
                result = (PortletInstance)this.portletInstanceDAO.findById(personalPltIns.getRefInsId());
            } else {
                PortletDefinition pltDef = this.portletDefinitionService.findPortletDefinitionById(personalPltIns.getDefinitionId());
                result = new PortletInstance();
                result.setDisplayName(pltDef.getDisplayName());
                result.setThemeId(pltDef.getThemeId());
                result.setTmplId(pltDef.getTmplId());
                result.setHeight("auto");
            }
            return result;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void resetDefaultPreferences4PltIns(PortalContext context, String portletInsId) throws PortalBizException {
        try {
            PortletInstance personalPltIns = (PortletInstance)this.portletInstanceDAO.findById(portletInsId);
            if (!StringUtil.isEmpty((String)personalPltIns.getRefInsId())) {
                PortletRuntimePreferences personalPortletRuntimePreferences;
                PortletRuntimePreferences adminPortletRuntimePreferences = this.findPortletRuntimePreferencesByInsId(context, personalPltIns.getRefInsId());
                if (adminPortletRuntimePreferences != null && (personalPortletRuntimePreferences = this.findPortletRuntimePreferencesByInsId(context, portletInsId)) != null) {
                    personalPortletRuntimePreferences.setPreferences(adminPortletRuntimePreferences.getPreferences());
                    personalPortletRuntimePreferences.setPortalContext(context);
                    this.portletRuntimePreferencesDAO.update(personalPortletRuntimePreferences);
                }
            } else {
                PortletDefinition pltDef = this.portletDefinitionService.findPortletDefinitionById(personalPltIns.getDefinitionId());
                PortletRuntimePreferences personalPortletRuntimePreferences = this.findPortletRuntimePreferencesByInsId(context, portletInsId);
                if (personalPortletRuntimePreferences != null) {
                    personalPortletRuntimePreferences.setPreferences(pltDef.getPreferences());
                    personalPortletRuntimePreferences.setPortalContext(context);
                    this.portletRuntimePreferencesDAO.update(personalPortletRuntimePreferences);
                }
            }
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Preferences findDefaultPreferences4PltIns(PortalContext context, String portletInsId) throws PortalBizException {
        try {
            String preferencesStr = null;
            PortletInstance personalPltIns = (PortletInstance)this.portletInstanceDAO.findById(portletInsId);
            if (!StringUtil.isEmpty((String)personalPltIns.getRefInsId())) {
                PortletRuntimePreferences adminPortletRuntimePreferences = this.findPortletRuntimePreferencesByInsId(context, personalPltIns.getRefInsId());
                if (adminPortletRuntimePreferences != null) {
                    preferencesStr = adminPortletRuntimePreferences.getPreferences();
                }
            } else {
                PortletDefinition pltDef = this.portletDefinitionService.findPortletDefinitionById(personalPltIns.getDefinitionId());
                PortletRuntimePreferences personalPortletRuntimePreferences = this.findPortletRuntimePreferencesByInsId(context, portletInsId);
                if (personalPortletRuntimePreferences != null) {
                    preferencesStr = pltDef.getPreferences();
                }
            }
            Preferences preferences = PortletHelper.convPreferences(preferencesStr);
            return preferences;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    private PortletDefinition findPortletDefinitionByInsExtId(PortalContext context, String insExtId) throws PortalBizException {
        try {
            return null;
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
    }

    private PortletInstance findInstanceByInsExtId(PortalContext context, String insId) throws PortalBizException {
        try {
            return (PortletInstance)this.portletInstanceDAO.findById(insId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletRuntimePreferences findPortletRuntimePreferencesByInsId(PortalContext context, String pltInsId) throws PortalBizException {
        PortletRuntimePreferences prp = null;
        try {
            prp = (PortletRuntimePreferences)this.portletRuntimePreferencesDAO.findObject(new FieldFilter("insId", "=", pltInsId));
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return prp;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletInstance> getPortletInstanceListBydefinitionId(String definitionId) throws PortalBizException {
        try {
            return this.portletInstanceDAO.findList(new FieldFilter("definitionId", "=", definitionId));
        }
        catch (DataAccessException dataAccessException) {
            return null;
        }
    }

    @Override
    public void deletePltInstanceAndPrefencesByDefIds(PortalContext ctx, String[] defIds) throws PortalBizException {
        List<PortletInstance> insList = this.findPltInstanceByDefIds(ctx, defIds);
        if (insList != null) {
            ArrayList<String> insIdList = new ArrayList<String>();
            for (PortletInstance instance : insList) {
                insIdList.add(instance.getId());
            }
            String[] insIds = insIdList.toArray(new String[insIdList.size()]);
            try {
                this.portletRuntimePreferencesDAO.deleteByIds(insIds);
                this.portletInstanceDAO.deleteByIds(insIds);
            }
            catch (DataAccessException e) {
                throw new PortalBizException("300", e);
            }
        }
    }

    @Override
    public void deletePltInstanceAndPrefencesByDefId(PortalContext ctx, String defId) throws PortalBizException {
        String[] defIds = new String[]{defId};
        this.deletePltInstanceAndPrefencesByDefIds(ctx, defIds);
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletInstance> findPltInstanceByDefIds(PortalContext ctx, String[] defIds) throws PortalBizException {
        try {
            return this.portletInstanceDAO.findPltInstanceByDefIds(defIds);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletInstance> findPltInstanceByIds(PortalContext ctx, String[] ids) throws PortalBizException {
        try {
            return this.portletInstanceDAO.findPltInstanceByIds(ids);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void updateInstanceTmplId(PortalContext context, String tmplId, String newTmplId) throws PortalBizException {
        try {
            this.portletInstanceDAO.updateInstanceTmplId(context, tmplId, newTmplId);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }

    public void setPortletThemeService(PortletThemeService portletThemeService) {
        this.portletThemeService = portletThemeService;
    }

    public void setPortletInstanceDAO(PortletInstanceDAO portletInstanceDAO) {
        this.portletInstanceDAO = portletInstanceDAO;
    }

    public void setPortletRuntimePreferencesDAO(PortletRuntimePreferencesDAO portletRuntimePreferencesDAO) {
        this.portletRuntimePreferencesDAO = portletRuntimePreferencesDAO;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }

    public PortletCategoryService getPortletCategoryService() {
        return this.portletCategoryService;
    }

    public void setPortletCategoryService(PortletCategoryService portletCategoryService) {
        this.portletCategoryService = portletCategoryService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }
}

