/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.portlet.dao.PortletThemeDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletTheme;
import com.kingdee.portal.biz.module.portlet.service.PortletThemeService;
import java.util.List;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletThemeServiceImpl
implements PortletThemeService {
    private PortletThemeDAO portletThemeDAO;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletTheme findPortletThemeById(String id) throws PortalBizException {
        try {
            return (PortletTheme)this.portletThemeDAO.findById(id);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletTheme> findPortletThemeList4Enable() throws PortalBizException {
        try {
            PortletTheme portletTheme = new PortletTheme();
            portletTheme.setStatus(StatusEnum.ENABLE);
            return this.portletThemeDAO.findList(portletTheme, new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletTheme> findThemeListByIds(String[] ids) throws PortalBizException {
        try {
            return this.portletThemeDAO.findListByIds(ids);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    public void setPortletThemeDAO(PortletThemeDAO portletThemeDAO) {
        this.portletThemeDAO = portletThemeDAO;
    }
}

