/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.portlet.dao.PortletTmplDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.portlet.service.PortletService;
import com.kingdee.portal.biz.module.portlet.service.PortletTmplService;
import com.kingdee.portal.biz.module.setting.entity.PortalProfile;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PortletTmplServiceImpl
implements PortletTmplService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletTmplDAO portletTmplDAO;
    private SettingService settingService;
    private PortletDefinitionService portletDefinitionService;
    private PortletService portletService;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public JSONObject findAllPortletTmpl(String status) throws PortalBizException {
        JSONObject result = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONObject obj = new JSONObject();
        List<PortletTmpl> tmplList = this.findPortletTmplByStatus(status);
        if (tmplList != null && tmplList.size() > 0) {
            for (PortletTmpl tmpl : tmplList) {
                obj.put((Object)"id", (Object)tmpl.getId());
                obj.put((Object)"displayName", (Object)tmpl.getDisplayName());
                obj.put((Object)"content", (Object)tmpl.getContent());
                obj.put((Object)"status", (Object)tmpl.getStatus());
                jsonArray.add((Object)obj);
            }
        }
        result.put((Object)"tmplList", (Object)jsonArray);
        return result;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletTmpl> findPortletTmplByStatus(String status) throws PortalBizException {
        List<Object> tmplList = null;
        try {
            if (status != null && !status.equals("")) {
                PortletTmpl portletTmpl = new PortletTmpl();
                if (status.equals("ENABLE")) {
                    portletTmpl.setStatus(StatusEnum.ENABLE);
                } else {
                    portletTmpl.setStatus(StatusEnum.DISABLE);
                }
                tmplList = this.portletTmplDAO.findList(portletTmpl, new OrderFilter("createTime", OrderEnum.ASC));
            } else {
                tmplList = this.portletTmplDAO.findList(new OrderFilter("createTime", OrderEnum.ASC));
            }
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return tmplList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletTmpl> findPortletTmplList4Enable() throws PortalBizException {
        List<PortletTmpl> tmplList = null;
        try {
            PortletTmpl portletTmpl = new PortletTmpl();
            portletTmpl.setStatus(StatusEnum.ENABLE);
            tmplList = this.portletTmplDAO.findList(portletTmpl, new OrderFilter("createTime", OrderEnum.ASC));
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
        return tmplList;
    }

    @Override
    public PortletTmpl modifyTmplStatus(PortalContext context, String tmplId, String tmplStatus) throws PortalBizException {
        PortletTmpl tmpl = null;
        try {
            tmpl = (PortletTmpl)this.portletTmplDAO.findById(tmplId);
            if (tmpl != null) {
                tmpl.setPortalContext(context);
                if (tmpl.getStatus().equals((Object)StatusEnum.ENABLE)) {
                    tmpl.setStatus(StatusEnum.DISABLE);
                } else {
                    tmpl.setStatus(StatusEnum.ENABLE);
                }
            }
            tmpl = this.portletTmplDAO.update(tmpl);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("304", e);
        }
        return tmpl;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<PortletTmpl> findPortletTmpl(PagingParam pagingParam) throws PortalBizException {
        PagingResult<PortletTmpl> pagingResult = null;
        try {
            PortletTmpl portletTmpl = new PortletTmpl();
            pagingResult = this.portletTmplDAO.findList(portletTmpl, pagingParam, new Filter[0]);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
        return pagingResult;
    }

    @Override
    public void deleteTmpl(PortalContext context, String tmplId) throws PortalBizException {
        try {
            String defaultTmplId;
            this.portletTmplDAO.deleteById(tmplId);
            String newTmplId = "feb9ec4f-6bf9-44f3-b9e3-147c0c713009";
            PortalProfile pf = this.settingService.findPortalProfileByConfigItem("default_portlet_tmpl");
            if (pf != null && tmplId.equals(defaultTmplId = pf.getConfigValue())) {
                pf.setConfigValue(newTmplId);
                this.settingService.updatePortalProfile(context, pf);
            }
            this.portletDefinitionService.updateTmplIdByTmpilId(context, tmplId, newTmplId);
            this.portletService.updateInstanceTmplId(context, tmplId, newTmplId);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortletTmpl findTmplById(String tmplId) throws PortalBizException {
        try {
            return (PortletTmpl)this.portletTmplDAO.findById(tmplId);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public PortletTmpl modifyTmpl(PortalContext context, PortletTmpl tmpl) throws PortalBizException {
        try {
            PortletTmpl oldTmpl = (PortletTmpl)this.portletTmplDAO.findById(tmpl.getId());
            oldTmpl.setCode(tmpl.getCode());
            oldTmpl.setDisplayName(tmpl.getDisplayName());
            oldTmpl.setContent(tmpl.getContent());
            oldTmpl.setDecription(tmpl.getDecription());
            oldTmpl.setPortalContext(context);
            return this.portletTmplDAO.update(oldTmpl);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public PortletTmpl createTmpl(PortalContext context, PortletTmpl tmpl) throws PortalBizException {
        try {
            return this.portletTmplDAO.create(tmpl);
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public PortletTmpl saveTmpl(PortalContext context, PortletTmpl tmpl) throws PortalBizException {
        try {
            if (tmpl != null) {
                tmpl.setPortalContext(context);
                if (tmpl.getId() != null && !tmpl.getId().equals("")) {
                    return this.modifyTmpl(context, tmpl);
                }
                return this.portletTmplDAO.create(tmpl);
            }
            return null;
        }
        catch (DataAccessException e) {
            this.logger.error(e.getMessage());
            throw new PortalBizException("300", e);
        }
    }

    public void setPortletTmplDAO(PortletTmplDAO portletTmplDAO) {
        this.portletTmplDAO = portletTmplDAO;
    }

    public void setSettingService(SettingService settingService) {
        this.settingService = settingService;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }

    public void setPortletService(PortletService portletService) {
        this.portletService = portletService;
    }
}

