/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.portlet.service.impl;

import com.kingdee.eas.base.common.app.ProcessStatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.portlet.dao.ProcessCardPortletDAO;
import com.kingdee.portal.biz.module.portlet.entity.ProcessCardPortletEntity;
import com.kingdee.portal.biz.module.portlet.service.ProcessCardPortletService;
import java.util.HashSet;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ProcessCardPortletServiceImpl
implements ProcessCardPortletService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ProcessCardPortletDAO processCardPortletDAO;

    public ProcessCardPortletDAO getProcessCardPortletDAO() {
        return this.processCardPortletDAO;
    }

    public void setProcessCardPortletDAO(ProcessCardPortletDAO processCardPortletDAO) {
        this.processCardPortletDAO = processCardPortletDAO;
    }

    @Override
    public void addProcessCardEntry(ProcessCardPortletEntity entity) {
        try {
            this.processCardPortletDAO.create(entity);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteProcessCardEntryByInsId(String insId) {
        this.processCardPortletDAO.deletePorcessCardEntryByInsId(insId);
    }

    @Override
    public void updeteProcessCardEntryByEntryId(String processEntryId, String processEntry) {
        this.processCardPortletDAO.updetePorcessCardEntryByEntryId(processEntryId, processEntry);
    }

    @Override
    public void updateProcessCardStyleByProcessId(String procesId, String processCardStyle) {
        this.processCardPortletDAO.updateProcessCardStyleByProcessId(procesId, processCardStyle);
    }

    @Override
    public void updateProcessStatusByProcessId(String procesId, ProcessStatusEnum status) {
        this.processCardPortletDAO.updateProcessCardStyleByProcessId(procesId, status);
    }

    @Override
    public String getProcessCardEntryByEntryId(String processEntryId) {
        ProcessCardPortletEntity entity = new ProcessCardPortletEntity();
        entity.setFProcessEntryId(processEntryId);
        entity.setStatus("1");
        try {
            ProcessCardPortletEntity result = this.processCardPortletDAO.findObject(entity, null);
            if (result != null) {
                return result.getFProcessEntry();
            }
            return "";
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public String getProcessCardStyleByProcessId(String processId) {
        ProcessCardPortletEntity entity = new ProcessCardPortletEntity();
        entity.setProcessId(processId);
        try {
            ProcessCardPortletEntity result = this.processCardPortletDAO.findObject(entity, null);
            if (result != null) {
                return result.getProcessCardStyle();
            }
            return "";
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            return "";
        }
    }

    @Override
    public void saveProcessCardEntrys(String processId, String entrys) {
        ProcessCardPortletEntity entity = new ProcessCardPortletEntity();
        ProcessCardPortletEntity result = new ProcessCardPortletEntity();
        HashSet<String> entryIdsFromProcess = new HashSet<String>();
        try {
            JSONArray menuItems = JSONArray.fromObject((Object)entrys);
            for (int i = 0; i < menuItems.size(); ++i) {
                JSONObject tmp = menuItems.getJSONObject(i);
                String processEntryId = tmp.getString("id");
                entryIdsFromProcess.add(processEntryId);
            }
            entity.setProcessId(processId);
            List<ProcessCardPortletEntity> resultList = this.processCardPortletDAO.findList(entity, null);
            String entryIdFromDB = "";
            if (resultList != null && resultList.size() > 0) {
                for (int i = 0; i < resultList.size(); ++i) {
                    entryIdFromDB = resultList.get(i).getFProcessEntryId();
                    if (entryIdsFromProcess.contains(entryIdFromDB)) continue;
                    this.processCardPortletDAO.deletePorcessCardEntryByEntryId(entryIdFromDB);
                }
            }
            for (int i = 0; i < menuItems.size(); ++i) {
                JSONObject tmp = menuItems.getJSONObject(i);
                String processEntryId = tmp.getString("id");
                entity = new ProcessCardPortletEntity();
                entity.setFProcessEntryId(processEntryId);
                result = this.processCardPortletDAO.findObject(entity, null);
                if (result == null) continue;
                this.processCardPortletDAO.updetePorcessCardEntryByEntryId(processEntryId, tmp.toString());
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void deleteProcessCardByProcessId(String processId) {
        this.processCardPortletDAO.deleteProcessCardByProcessId(processId);
    }
}

