/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.pub.dao.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.pub.dao.ExportDataToFileDAO;
import com.kingdee.portal.biz.module.pub.dto.TableField;
import com.kingdee.portal.common.util.Constant;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.ejb.HibernateEntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.SessionFactoryUtils;

public class ExportDataToFileDAOImpl
extends BaseDAOImpl<Page>
implements ExportDataToFileDAO {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public List<String> exportDataFromTable(PortalContext ctx, String tableName, String exportContents) throws DataAccessException {
        List<TableField> tfList = this.getTableColumn(ctx, tableName, exportContents);
        List<String> sqlStr = this.getDataAndTransToList(ctx, tableName, exportContents, tfList);
        return sqlStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TableField> getTableColumn(PortalContext ctx, String tableName, String exportContents) throws DataAccessException {
        Object hbem = null;
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            String dbType = (String)context.get((Object)"dbType");
            String sql = "/*dialect*/ select COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_PRECISION,DATA_SCALE ,NULLABLE\u3000from user_tab_columns where table_name =UPPER('" + tableName + "')";
            sql = "MS SQL Server".equals(dbType) ? "/*dialect*/ SELECT syscolumns.name  COLUMN_NAME,systypes.name  DATA_TYPE,syscolumns.length DATA_LENGTH,syscolumns.prec DATA_PRECISION, syscolumns.scale ,syscolumns.isnullable NULLABLE FROM syscolumns, systypes WHERE syscolumns.xusertype = systypes.xusertype  AND syscolumns.id = object_id('" + tableName + "')" : ("Oracle".equals(dbType) ? "/*dialect*/ select COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_PRECISION,DATA_SCALE ,NULLABLE\u3000from user_tab_columns where table_name =UPPER('" + tableName + "')" : "/*dialect*/ select name AS COLUMN_NAME,coltype AS DATA_TYPE,length  as DATA_LENGTH from sysibm.syscolumns  where tbname='" + tableName.toUpperCase() + "'");
            ArrayList<TableField> tfList = new ArrayList<TableField>();
            IRowSet colRet = DbUtil.executeQuery((Context)context, (String)sql);
            while (true) {
                if (!colRet.next()) {
                    return tfList;
                }
                TableField tf = new TableField();
                tf.setColumnName(colRet.getString("COLUMN_NAME"));
                tf.setColumnType(colRet.getString("DATA_TYPE"));
                tf.setDatasize(colRet.getInt("DATA_LENGTH"));
                tfList.add(tf);
            }
        }
        catch (SQLException se) {
            this.logger.error(se.getMessage());
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getData(String tableName, String exportContents) throws DataAccessException {
        HibernateEntityManager hbem = null;
        try {
            hbem = (HibernateEntityManager)this.em;
            Connection cn = SessionFactoryUtils.getDataSource((SessionFactory)hbem.getSession().getSessionFactory()).getConnection();
            ResultSet resultSet = cn.prepareStatement("select * from " + tableName).executeQuery();
            return resultSet;
        }
        catch (SQLException sQLException) {
        }
        finally {
            hbem.getSession().disconnect();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getDataAndTransToList(PortalContext ctx, String tableName, String exportContents, List<TableField> tfList) throws DataAccessException {
        try {
            ArrayList<String> sqlStr = new ArrayList<String>();
            ArrayList<String> sqltemp = new ArrayList<String>();
            String updateStr = "";
            String ifStr = "";
            String insertStr = "";
            String valueStr = "";
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)("select * from " + tableName));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss ");
            while (rs.next()) {
                ifStr = "if not exists (select * from " + tableName + " where FId='" + rs.getString("FId") + "')";
                insertStr = "Insert Into " + tableName + "(";
                valueStr = "Values(";
                for (TableField td : tfList) {
                    if (tableName.equals("T_JP_PortletDefinition") && td.getColumnName().equals("FPortletName")) {
                        ifStr = "if not exists (select * from " + tableName + " where FPortletName='" + rs.getString("FPortletName") + "' and FCopy=" + rs.getString("FCopy") + ")";
                        updateStr = "update T_JP_PortletDefinition set FResLevel='SYS' where FPortletName='" + rs.getString("FPortletName") + "' and FCopy=2;";
                        sqltemp.add(updateStr);
                    }
                    insertStr = insertStr + td.getColumnName() + ",";
                    if ("varchar".equals(td.getColumnType()) || "NVARCHAR2".equals(td.getColumnType()) || "VARCHAR2".equals(td.getColumnType()) || "VARCHAR".equals(td.getColumnType()) || "VARGRAPH".equals(td.getColumnType())) {
                        if (rs.getString(td.getColumnName()) == null || rs.getString(td.getColumnName()).equals("null")) {
                            valueStr = valueStr + null + ",";
                            continue;
                        }
                        valueStr = valueStr + "'" + rs.getString(td.getColumnName()) + "',";
                        continue;
                    }
                    if ("datetime".equals(td.getColumnType()) || "TIMESTAMP(6)".equals(td.getColumnType()) || "TIMESTMP".equals(td.getColumnType())) {
                        valueStr = valueStr + "{ts'" + df.format(rs.getDate(td.getColumnName())) + "'},";
                        continue;
                    }
                    if ("int".equals(td.getColumnType()) || "NUMBER".equals(td.getColumnType()) || "INTEGER".equals(td.getColumnType().trim())) {
                        valueStr = valueStr + rs.getString(td.getColumnName()) + ",";
                        continue;
                    }
                    if ("decimal".equals(td.getColumnType())) {
                        valueStr = valueStr + rs.getString(td.getColumnName()) + ",";
                        continue;
                    }
                    if ("image".equals(td.getColumnType()) || "BLOB".equals(td.getColumnType().trim())) {
                        if (rs.getBlob(td.getColumnName()) != null) {
                            try {
                                String fileSuffix = ".png";
                                if (rs.getString("FDocSuffix") != null) {
                                    fileSuffix = rs.getString("FDocSuffix");
                                }
                                this.saveDatFile(rs.getBlob(td.getColumnName()), rs.getString("FId"), fileSuffix, tableName, td.getColumnName());
                            }
                            catch (IOException e) {
                                this.logger.error(tableName + " saveDatFile Error IOException===" + e.getMessage());
                            }
                            valueStr = valueStr + null + ",";
                            continue;
                        }
                        valueStr = valueStr + null + ",";
                        continue;
                    }
                    if (rs.getString(td.getColumnName()) == null || rs.getString(td.getColumnName()).equals("null")) {
                        valueStr = valueStr + null + ",";
                        continue;
                    }
                    valueStr = valueStr + "'" + rs.getString(td.getColumnName()) + "',";
                }
                insertStr = insertStr.substring(0, insertStr.length() - 1) + ")";
                valueStr = valueStr.substring(0, valueStr.length() - 1) + ");";
                sqlStr.add(ifStr);
                sqlStr.add(insertStr);
                sqlStr.add(valueStr);
            }
            if (tableName.equals("T_JP_PortletDefinition")) {
                for (String str : sqltemp) {
                    sqlStr.add(str);
                }
            }
            Iterator<TableField> iterator = sqlStr;
            return iterator;
        }
        catch (Exception exception) {
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDatFile(Blob blob, String fid, String fileSuffix, String tableName, String filedName) throws IOException {
        String spath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + "exportsql/" + tableName + "/";
        this.logger.error("saveDatFile data writeToFile path====" + spath);
        FileOutputStream fos = null;
        FilterOutputStream bos = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        int bytesRead = 0;
        try {
            String fileName;
            File myPath = new File(FilterSpecialCharactersTool.cleanPathString(spath));
            if (!myPath.exists()) {
                myPath.mkdir();
            }
            if (!FilterSpecialCharactersTool.checkParamsValid(fileName = spath + fid + "_" + filedName + fileSuffix)) {
                this.logger.error("saveDatFile checkParamsValid error !");
                throw new IOException();
            }
            File file = new File(FilterSpecialCharactersTool.cleanPathString(fileName));
            is = blob.getBinaryStream();
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bis = new BufferedInputStream(is);
            while ((bytesRead = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(bytesRead);
                ((BufferedOutputStream)bos).flush();
            }
        }
        catch (Exception e) {
            this.logger.error(fid + " saveDatFile Error===" + e.getMessage());
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bis != null) {
                bis.close();
            }
            if (fos != null) {
                fos.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
    }
}

