/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.pub.service;

import com.kingdee.portal.biz.module.pub.service.ExportData;
import com.kingdee.portal.biz.module.pub.service.ExportDataToFile;
import com.kingdee.portal.biz.module.pub.service.NullExportData;
import java.util.HashMap;

public class ExportDataFactory {
    private static final ExportDataFactory instance = new ExportDataFactory();
    private static final ExportData[] exportDatas = new ExportData[]{new ExportDataToFile()};

    private ExportDataFactory() {
    }

    public static ExportDataFactory getInstance() {
        return instance;
    }

    public ExportData createExportData(String exportType) {
        if (exportType == null) {
            return new NullExportData();
        }
        return this.createExportData(this.getExportTypClass(exportType).getClass());
    }

    public ExportData createExportData(Class<?> clazz) {
        for (ExportData exportData : exportDatas) {
            if (!exportData.canProcess(clazz)) continue;
            return exportData;
        }
        return null;
    }

    private Object getExportTypClass(String exportType) {
        HashMap<String, ExportDataToFile> typeList = new HashMap<String, ExportDataToFile>();
        typeList.put("file", new ExportDataToFile());
        return typeList.get(exportType);
    }
}

