/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.pub.service.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.pub.dao.ExportDataToFileDAO;
import com.kingdee.portal.biz.module.pub.service.ExportDataService;
import com.kingdee.portal.common.util.Constant;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class ExportDataServiceImpl
implements ExportDataService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExportDataToFileDAO exportDataToFileDAO;

    @Override
    public String exportData(PortalContext ctx, String tableNames, String exportType, String exportContents) throws PortalBizException {
        String result = null;
        try {
            String[] tbList;
            this.createFolder();
            for (String tableName : tbList = tableNames.split(",")) {
                List<String> sqlStr = this.exportDataToFileDAO.exportDataFromTable(ctx, tableName, exportContents);
                this.writeToFile(sqlStr, tableName);
            }
            result = "success";
        }
        catch (DataAccessException e) {
            this.logger.error("exportDataToFile err" + e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void createFolder() {
        String parentPath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + "exportsql/";
        this.logger.error("export data writeToFile path====" + parentPath);
        File mPath = new File(parentPath);
        if (!mPath.exists()) {
            mPath.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(List<String> sqlStr, String tableName) throws IOException {
        OutputStreamWriter write = null;
        BufferedWriter bw = null;
        try {
            if (sqlStr == null) {
                return;
            }
            String spath = Constant.SYSTEM_ROOT_PATH + ".." + Constant.SYSTEM_PATH_SEPARATOR + "exportsql/";
            this.logger.error("export data writeToFile path====" + spath);
            File myPath = new File(spath);
            if (!myPath.exists()) {
                myPath.mkdir();
            }
            File file = new File(spath + tableName + ".sql");
            write = new FileWriter(file);
            bw = new BufferedWriter(write);
            for (int i = 0; i < sqlStr.size(); ++i) {
                bw.write(new String(sqlStr.get(i).getBytes(), "utf-8"));
                bw.newLine();
                if ((i + 1) % 3 != 0) continue;
                bw.newLine();
            }
        }
        catch (IOException e) {
            this.logger.error(tableName + " Write Error===" + e.getMessage());
        }
        finally {
            if (bw != null) {
                bw.flush();
                bw.close();
            }
            if (write != null) {
                write.close();
            }
        }
    }

    public void setExportDataToFileDAO(ExportDataToFileDAO exportDataToFileDAO) {
        this.exportDataToFileDAO = exportDataToFileDAO;
    }
}

