/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.pub.service.impl;

import com.kingdee.bos.ctrl.reportone.r1.print.common.ImageUtil;
import com.kingdee.eas.base.message.util.StringUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.personal.entity.PersonalProfile;
import com.kingdee.portal.biz.module.personal.service.PersonalProfileService;
import com.kingdee.portal.biz.module.portlet.service.PortletDefinitionService;
import com.kingdee.portal.biz.module.pub.common.enums.FileTypeEnum;
import com.kingdee.portal.biz.module.pub.common.json.FileMetaInfo;
import com.kingdee.portal.biz.module.pub.common.util.gif.GIFEncoder;
import com.kingdee.portal.biz.module.pub.dao.PubFileDAO;
import com.kingdee.portal.biz.module.pub.dto.CropModel;
import com.kingdee.portal.biz.module.pub.dto.FileModel;
import com.kingdee.portal.biz.module.pub.entity.PubFile;
import com.kingdee.portal.biz.module.pub.service.PubFileService;
import com.kingdee.portal.common.util.FileUtil;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class PubFileServiceImpl
implements PubFileService {
    private static final Logger logger = LoggerFactory.getLogger(PubFileServiceImpl.class);
    private PubFileDAO pubFileDAO;
    private PageService pageService;
    private PortletDefinitionService portletDefinitionService;
    private PersonalProfileService personalProfileService;

    @Override
    public PubFile createPubFile4Img(PortalContext ctx, FileModel fileModel, CropModel cropModel, DisplayName displayName, FileTypeEnum fileType) throws PortalBizException {
        return this.createOrUpdatePubFile4Img(ctx, fileModel, cropModel, displayName, fileType, null);
    }

    private PubFile createOrUpdatePubFile4Img(PortalContext ctx, FileModel fileModel, CropModel cropModel, DisplayName displayName, FileTypeEnum fileType, String pubFileId) throws PortalBizException {
        try {
            byte[] corpImgContent = null;
            corpImgContent = FileTypeEnum.UPLOAD_IMG.equals((Object)fileType) ? this.getImgBytes(fileModel) : this.corp(fileModel, cropModel);
            logger.error(">>createPubFile4Img length:" + corpImgContent.length);
            PubFile pubFile = null;
            logger.error(">>createPubFile4Img fileType:" + (Object)((Object)fileType));
            if (FileTypeEnum.USER_LOGO.equals((Object)fileType)) {
                pubFile = this.savePubFile4UserLogo(ctx, fileModel, cropModel, displayName, fileType, corpImgContent);
            } else {
                pubFile = pubFileId != null ? (PubFile)this.pubFileDAO.findById(pubFileId) : new PubFile();
                this.buildPubFile4Save(pubFile, ctx, fileModel, cropModel, displayName, fileType, corpImgContent);
                if (pubFileId != null) {
                    this.pubFileDAO.update(pubFile);
                } else {
                    this.pubFileDAO.create(pubFile);
                }
            }
            logger.error(">>createPubFile4Img 1111");
            File tempFile = new File(fileModel.getUploadFilePath());
            if (tempFile != null && tempFile.isFile()) {
                tempFile.delete();
            }
            logger.error(">>createPubFile4Img 222");
            PubFile newPubFile = new PubFile();
            newPubFile.setId(pubFile.getId());
            return newPubFile;
        }
        catch (Exception ex) {
            throw new PortalBizException("400", ex);
        }
    }

    @Override
    public PubFile updatePubFile4Img(PortalContext ctx, FileModel fileModel, CropModel cropModel, DisplayName displayName, FileTypeEnum fileType, String pubFileId) throws PortalBizException {
        return this.createOrUpdatePubFile4Img(ctx, fileModel, cropModel, displayName, fileType, pubFileId);
    }

    @Override
    public void deletePubFileById(PortalContext ctx, String id) throws PortalBizException {
        try {
            this.pubFileDAO.deleteById(id);
        }
        catch (Exception ex) {
            throw new PortalBizException("403", ex);
        }
    }

    @Override
    public void updatePubFile(PortalContext ctx, PubFile pubFile) throws PortalBizException {
        try {
            this.pubFileDAO.update(pubFile);
        }
        catch (Exception ex) {
            throw new PortalBizException("401", ex);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<PubFile> findPubFileList(PortalContext ctx, PubFile pubFile, PagingParam pagingParam, String displayName) throws PortalBizException {
        PagingResult<PubFile> pubFileList = null;
        try {
            pubFileList = this.pubFileDAO.findList(pubFile, pagingParam, new FieldFilter("displayName", "like", "%" + displayName + "%"));
        }
        catch (Exception ex) {
            throw new PortalBizException("402", ex);
        }
        return pubFileList;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PubFile findPubFileById(PortalContext ctx, String id) throws PortalBizException {
        PubFile pubFile = null;
        try {
            pubFile = (PubFile)this.pubFileDAO.findById(id);
        }
        catch (Exception ex) {
            throw new PortalBizException("402", ex);
        }
        return pubFile;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PubFile findUserLogoByUserCode(PortalContext ctx, String userCode) throws PortalBizException {
        PubFile pubFile = null;
        try {
            pubFile = new PubFile();
            pubFile.setCreator(userCode);
            pubFile.setFileType(FileTypeEnum.USER_LOGO);
            pubFile = this.pubFileDAO.findObject(pubFile, new OrderFilter("lastUpdateTime", OrderEnum.DESC));
        }
        catch (Exception ex) {
            throw new PortalBizException("402", ex);
        }
        return pubFile;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public boolean hasUsed4Img(PortalContext context, String id) throws PortalBizException {
        boolean hasUsed4Plt = this.portletDefinitionService.hasUsed4Icon(context, id);
        if (hasUsed4Plt) {
            return true;
        }
        boolean hasUsed4Page = this.pageService.hasUsed4Icon(context, id);
        if (hasUsed4Page) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] corp(FileModel fileModel, CropModel cropModel) throws Exception {
        byte[] imageContent = null;
        File imageFile = new File(fileModel.getUploadFilePath());
        String imgFormatName = FileUtil.getFileSuffix((String)imageFile.getName());
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(imageFile);
        int x = (int)Math.round((double)cropModel.getX().intValue() / cropModel.getScale());
        int y = (int)Math.round((double)cropModel.getY().intValue() / cropModel.getScale());
        int height = (int)Math.round((double)cropModel.getHeight().intValue() / cropModel.getScale());
        int width = (int)Math.round((double)cropModel.getWidth().intValue() / cropModel.getScale());
        ImageInputStream imageInputStream = null;
        try {
            Iterator<ImageReader> it = null;
            it = ImageIO.getImageReadersByFormatName(imgFormatName);
            ImageReader reader = it.next();
            imageInputStream = ImageIO.createImageInputStream(fileInputStream);
            reader.setInput(imageInputStream, true);
            ImageReadParam param = reader.getDefaultReadParam();
            Rectangle rect = new Rectangle(x, y, width, height);
            param.setSourceRegion(rect);
            BufferedImage bufferedImage = reader.read(0, param);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if ("gif".equalsIgnoreCase(imgFormatName)) {
                GIFEncoder gifEncoder = new GIFEncoder(bufferedImage);
                gifEncoder.Write(byteArrayOutputStream);
            } else {
                ImageIO.write((RenderedImage)bufferedImage, imgFormatName, byteArrayOutputStream);
            }
            imageContent = byteArrayOutputStream.toByteArray();
            fileModel.setLength(Long.valueOf(imageContent.length));
            cropModel.setHeight(height);
            cropModel.setWidth(width);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (imageInputStream != null) {
                imageInputStream.close();
            }
        }
        return imageContent;
    }

    private void buildPubFile4Save(PubFile pubFile, PortalContext ctx, FileModel fileModel, CropModel cropModel, DisplayName displayName, FileTypeEnum fileType, byte[] corpImgContent) {
        String fileSuffix;
        pubFile.setFileType(fileType);
        pubFile.setDisplayName(displayName.toString());
        pubFile.setContent(corpImgContent);
        pubFile.setContentType(fileModel.getUploadContentType());
        pubFile.setLength(fileModel.getLength().intValue());
        if (FileTypeEnum.USER_LOGO.equals((Object)fileType) && !StringUtil.isEmpty((String)fileModel.getUploadFilePath())) {
            pubFile.setOrigImgContent(ImageUtil.getImageByteContent((String)fileModel.getUploadFilePath()));
        }
        if (!StringUtil.isEmpty((String)(fileSuffix = FileUtil.getFileSuffix((String)fileModel.getUploadFilePath())))) {
            fileSuffix = "." + fileSuffix;
        }
        pubFile.setFileSuffix(fileSuffix);
        FileMetaInfo fileMetaInfo = new FileMetaInfo();
        fileMetaInfo.setHeight(cropModel.getHeight());
        fileMetaInfo.setWidth(cropModel.getWidth());
        fileMetaInfo.setX(cropModel.getX());
        fileMetaInfo.setY(cropModel.getY());
        fileMetaInfo.setX2(cropModel.getX2());
        fileMetaInfo.setY2(cropModel.getY2());
        fileMetaInfo.setScale(cropModel.getScale());
        fileMetaInfo.setOrigHeight(fileModel.getHeight());
        fileMetaInfo.setOrigWidth(fileModel.getWidth());
        pubFile.setMetaInfo(fileMetaInfo.toString());
        pubFile.setPortalContext(ctx);
    }

    private PubFile savePubFile4UserLogo(PortalContext ctx, FileModel fileModel, CropModel cropModel, DisplayName displayName, FileTypeEnum fileType, byte[] corpImgContent) throws PortalBizException, DataAccessException {
        PubFile pubFile = null;
        PersonalProfile personalProfile = this.personalProfileService.findLoginUserLogo(ctx);
        if (personalProfile != null) {
            PubFile tempPubFile = (PubFile)this.pubFileDAO.findById(personalProfile.getConfigValue());
            if (tempPubFile != null) {
                this.buildPubFile4Save(tempPubFile, ctx, fileModel, cropModel, displayName, fileType, corpImgContent);
                this.pubFileDAO.update(tempPubFile);
                pubFile = tempPubFile;
            } else {
                pubFile = new PubFile();
                pubFile.setId(personalProfile.getConfigValue());
                this.buildPubFile4Save(pubFile, ctx, fileModel, cropModel, displayName, fileType, corpImgContent);
                this.pubFileDAO.create(pubFile);
            }
        } else {
            pubFile = new PubFile();
            this.buildPubFile4Save(pubFile, ctx, fileModel, cropModel, displayName, fileType, corpImgContent);
            this.pubFileDAO.create(pubFile);
            this.personalProfileService.savePersonalProfile4UserLogo(ctx, pubFile.getId());
        }
        return pubFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getImgBytes(FileModel fileModel) throws Exception {
        byte[] imageContent = null;
        FileInputStream fileInputStream = null;
        File imageFile = new File(fileModel.getUploadFilePath());
        String imgFormatName = FileUtil.getFileSuffix((String)imageFile.getName());
        try {
            fileInputStream = new FileInputStream(imageFile);
            BufferedImage bufferedImage = ImageIO.read(fileInputStream);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if ("gif".equalsIgnoreCase(imgFormatName)) {
                GIFEncoder gifEncoder = new GIFEncoder(bufferedImage);
                gifEncoder.Write(byteArrayOutputStream);
            } else {
                ImageIO.write((RenderedImage)bufferedImage, imgFormatName, byteArrayOutputStream);
            }
            imageContent = byteArrayOutputStream.toByteArray();
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return imageContent;
    }

    public void setPubFileDAO(PubFileDAO pubFileDAO) {
        this.pubFileDAO = pubFileDAO;
    }

    public PageService getPageService() {
        return this.pageService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public PortletDefinitionService getPortletDefinitionService() {
        return this.portletDefinitionService;
    }

    public void setPortletDefinitionService(PortletDefinitionService portletDefinitionService) {
        this.portletDefinitionService = portletDefinitionService;
    }

    public PersonalProfileService getPersonalProfileService() {
        return this.personalProfileService;
    }

    public void setPersonalProfileService(PersonalProfileService personalProfileService) {
        this.personalProfileService = personalProfileService;
    }

    public PubFileDAO getPubFileDAO() {
        return this.pubFileDAO;
    }
}

