/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.report.dao.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.module.report.common.BaseVarProvider;
import com.kingdee.portal.biz.module.report.dao.SimpleReportDAO;
import com.kingdee.portal.biz.module.report.entity.SimpleReport;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleReportDAOImpl
extends BaseDAOImpl<SimpleReport>
implements SimpleReportDAO {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public ArrayList getReportData(Context ctx, String reportSql, String[] params) throws Exception {
        reportSql = this.replaceReportSql(ctx, reportSql);
        this.logger.info("SimpleReportDAOImpl sql:" + reportSql);
        ArrayList dataList = new ArrayList();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)reportSql);
        while (rs.next()) {
            HashMap<String, String> hm = new HashMap<String, String>();
            for (int i = 0; i < params.length; ++i) {
                hm.put(params[i], rs.getString(params[i]));
            }
            dataList.add(hm);
        }
        return dataList;
    }

    @Override
    public PagingResult<HashMap> findPagingList(Context ctx, String reportSql, PagingParam pagingParam) throws Exception {
        reportSql = this.replaceReportSql(ctx, reportSql);
        this.logger.info("SimpleReportDAOImpl sql:" + reportSql);
        ArrayList list = new ArrayList();
        int start = pagingParam.getStartIndex();
        int maxSize = pagingParam.getPageSize();
        ArrayList<String> columns = this.getColumnName(ctx, reportSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)reportSql);
        int count = 0;
        while (rs.next()) {
            if (++count <= start) continue;
            if (list.size() >= maxSize) break;
            HashMap<String, String> hm = new HashMap<String, String>();
            for (int i = 0; i < columns.size(); ++i) {
                hm.put(columns.get(i), rs.getString(columns.get(i)));
            }
            list.add(hm);
        }
        int totalCount = 0;
        String countSql = "select count(" + columns.get(0) + ") " + columns.get(0) + " from (" + reportSql + ")  as t";
        rs = DbUtil.executeQuery((Context)ctx, (String)countSql);
        if (rs.next()) {
            totalCount = rs.getInt(columns.get(0));
        }
        PagingResult<HashMap> pagingResult = new PagingResult<HashMap>(pagingParam, totalCount, list);
        return pagingResult;
    }

    @Override
    public ArrayList<String> getColumnName(Context ctx, String reportSql) throws Exception {
        ArrayList<String> columunName = new ArrayList<String>();
        reportSql = this.replaceReportSql(ctx, reportSql);
        Connection conn = EJBFactory.getConnection((Context)ctx);
        PreparedStatement ps = conn.prepareStatement(reportSql);
        ps.execute();
        ResultSetMetaData rsmd = ps.getMetaData();
        for (int i = 1; i < rsmd.getColumnCount() + 1; ++i) {
            columunName.add(rsmd.getColumnName(i));
        }
        SQLUtils.cleanup((Connection)conn);
        return columunName;
    }

    private String[] getColumns(String reportSql) {
        if (reportSql == null || reportSql.equals("")) {
            return null;
        }
        int iSelectBegin = reportSql.indexOf("select");
        if (iSelectBegin < 0) {
            return null;
        }
        int iSelectEnd = reportSql.indexOf("from");
        if (iSelectEnd < 0) {
            return null;
        }
        reportSql = reportSql.substring(iSelectBegin + 6, iSelectEnd);
        String[] sqlParams = reportSql.split(",");
        String[] columns = new String[sqlParams.length];
        for (int i = 0; i < sqlParams.length; ++i) {
            if (sqlParams[i].contains(" as ")) {
                int iBegin = sqlParams[i].indexOf(" as ");
                columns[i] = sqlParams[i].substring(iBegin + 4, sqlParams[i].length()).trim();
                continue;
            }
            String[] names = sqlParams[i].split(" ");
            columns[i] = names[names.length - 1];
        }
        return columns;
    }

    private String replaceReportSql(Context ctx, String reportSql) throws Exception {
        String result = reportSql;
        result = result.replaceAll("\n", " ");
        result = result.replaceAll(";", "");
        BaseVarProvider varProvider = new BaseVarProvider(ctx);
        List list = varProvider.enumVars();
        for (int i = 0; i < list.size(); ++i) {
            HashMap hm = (HashMap)list.get(i);
            if (result.indexOf((String)hm.get("varExp")) <= -1) continue;
            String replace = "'" + varProvider.getVar((String)hm.get("name")).toString() + "'";
            result = result.replaceAll((String)hm.get("varExp"), replace);
        }
        return result;
    }
}

