/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.report.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.module.report.dao.SimpleReportDAO;
import com.kingdee.portal.biz.module.report.service.DataBuilder;
import com.kingdee.portal.biz.module.report.service.impl.BaseDataBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaDataBuilder
extends BaseDataBuilder
implements DataBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SimpleReportDAO simpleReportDAO;

    public void setSimpleReportDAO(SimpleReportDAO simpleReportDAO) {
        this.simpleReportDAO = simpleReportDAO;
    }

    @Override
    public String getReportData(Context ctx, String reportSql, String[] xAxis, String[] yAxis, String[] countNames, String[] countValues) {
        if (yAxis != null && yAxis.length > 0) {
            return this.multiGetReportData(ctx, reportSql, xAxis, yAxis, countNames, this.convertCountTypes(countValues));
        }
        return this.singleGetReportData(ctx, reportSql, xAxis, yAxis, countNames, this.convertCountTypes(countValues));
    }

    private ArrayList getCategoriesData(Context ctx, String reportSql, String[] xAxis) {
        String sqlwapper = "select ";
        sqlwapper = sqlwapper + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + " from (" + reportSql + ") as t group by" + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + this.combineOrders(xAxis);
        this.logger.info("sqlWapper:" + sqlwapper);
        ArrayList list = null;
        try {
            list = this.simpleReportDAO.getReportData(ctx, sqlwapper, xAxis);
            this.logger.info("list" + list);
            this.logger.info("list size:" + list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> categoriesList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap hm = (HashMap)list.get(i);
            String name = (String)hm.get(xAxis[0]);
            for (int j = 1; j < xAxis.length; ++j) {
                name = name + "," + hm.get(xAxis[j]);
            }
            categoriesList.add(name);
        }
        return categoriesList;
    }

    private String singleGetReportData(Context ctx, String reportSql, String[] xAxis, String[] yAxis, String[] countNames, String[] types) {
        String sqlwapper = "select ";
        sqlwapper = sqlwapper + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + "," + this.combineOpWapperStrings(countNames, types);
        sqlwapper = sqlwapper + " from (" + reportSql + ") as t group by " + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + this.combineOrders(xAxis);
        this.logger.info("sqlWapper:" + sqlwapper);
        ArrayList list = null;
        try {
            list = this.simpleReportDAO.getReportData(ctx, sqlwapper, this.combineStrings(xAxis, countNames));
            this.logger.info("list" + list);
            this.logger.info("list size:" + list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList categoriesList = this.getCategoriesData(ctx, reportSql, xAxis);
        String reportData = this.buildSingleXmlData(list, categoriesList, xAxis, countNames);
        this.logger.info("reportData:" + reportData);
        return reportData;
    }

    private String multiGetReportData(Context ctx, String reportSql, String[] xAxis, String[] yAxis, String[] countNames, String[] types) {
        String reportData = "";
        ArrayList yDatas = this.getYDatas(ctx, reportSql, yAxis);
        HashMap categorysMap = new HashMap();
        ArrayList categoriesList = this.getCategoriesData(ctx, reportSql, xAxis);
        String categorys = "";
        String dataSets = "";
        for (int i = 0; i < yDatas.size(); ++i) {
            HashMap yData = (HashMap)yDatas.get(i);
            String sqlwapper = "select ";
            sqlwapper = sqlwapper + this.combineStrings(xAxis);
            sqlwapper = sqlwapper + "," + this.combineOpWapperStrings(countNames, types);
            sqlwapper = sqlwapper + " from (" + reportSql + ") as t";
            sqlwapper = sqlwapper + this.combineConditions(yAxis, yData);
            sqlwapper = sqlwapper + " group by " + this.combineStrings(xAxis);
            sqlwapper = sqlwapper + this.combineOrders(xAxis);
            this.logger.info("sqlWapper:" + sqlwapper);
            ArrayList list = null;
            try {
                list = this.simpleReportDAO.getReportData(ctx, sqlwapper, this.combineStrings(xAxis, countNames));
                this.logger.info("list" + list);
                this.logger.info("list size:" + list.size());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            dataSets = dataSets + this.buildDataSetXmlData(list, categoriesList, xAxis, this.getYAxis(yData, yAxis), countNames, i);
        }
        categorys = this.getCategoriesXml(categoriesList);
        reportData = this.buildMultiXmlData(categorys, dataSets);
        this.logger.info("reportData:" + reportData);
        return reportData;
    }

    private ArrayList getYDatas(Context ctx, String reportSql, String[] yAxis) {
        String sqlwapper = "select ";
        sqlwapper = sqlwapper + this.combineStrings(yAxis);
        sqlwapper = sqlwapper + " from (" + reportSql + ") as t group by " + this.combineStrings(yAxis);
        this.logger.info("sqlWapper:" + sqlwapper);
        ArrayList list = null;
        try {
            list = this.simpleReportDAO.getReportData(ctx, sqlwapper, yAxis);
            this.logger.info("list" + list);
            this.logger.info("list size:" + list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private String buildSingleXmlData(ArrayList list, ArrayList categoriesList, String[] xAxis, String[] countNames) {
        String xmlData = "<chart bgColor='E9E9E9' canvasBgAlpha='0' bgAlpha='0' baseFontSize='12' formatNumberScale='0' outCnvBaseFontColor='666666' caption=''  xAxisName='' yAxisName='' numberPrefix='' showNames='1' showValues='0'  plotFillAlpha='50' numVDivLines='10' showAlternateVGridColor='1' AlternateVGridColor='e1f5ff' divLineColor='e1f5ff' vdivLineColor='e1f5ff'  baseFontColor='666666' canvasBorderThickness='1' showPlotBorder='1' plotBorderThickness='0'> ";
        xmlData = xmlData + this.getCategoriesXml(categoriesList);
        xmlData = xmlData + this.getDataSetXml(list, categoriesList, xAxis, countNames);
        xmlData = xmlData + "</chart>";
        return xmlData;
    }

    private String buildMultiXmlData(String categories, String dataSets) {
        String xmlData = "<chart bgColor='E9E9E9' canvasBgAlpha='0' bgAlpha='0' baseFontSize='12' formatNumberScale='0' outCnvBaseFontColor='666666' caption=''  xAxisName='' yAxisName='' numberPrefix='' showNames='1' showValues='0'  plotFillAlpha='50' numVDivLines='10' showAlternateVGridColor='1' AlternateVGridColor='e1f5ff' divLineColor='e1f5ff' vdivLineColor='e1f5ff'  baseFontColor='666666' canvasBorderThickness='1' showPlotBorder='1' plotBorderThickness='0'> ";
        xmlData = xmlData + categories;
        xmlData = xmlData + dataSets;
        xmlData = xmlData + "</chart>";
        return xmlData;
    }

    private String buildDataSetXmlData(ArrayList list, ArrayList categoriesList, String[] xAxis, String yAxis, String[] countNames, int yDataIndex) {
        String xmlData = this.getDataSetXml(list, categoriesList, xAxis, countNames, yAxis, yDataIndex);
        return xmlData;
    }

    private String getCategoriesXml(HashMap filterMap, String[] xAxis) {
        String categoriesXml = "<categories>";
        Iterator iterator = filterMap.keySet().iterator();
        while (iterator.hasNext()) {
            categoriesXml = categoriesXml + "<category name='" + iterator.next() + " '/>";
        }
        categoriesXml = categoriesXml + "</categories>";
        return categoriesXml;
    }

    private String getCategoriesXml(List categoriesList) {
        String categoriesXml = "<categories>";
        for (int i = 0; i < categoriesList.size(); ++i) {
            categoriesXml = categoriesXml + "<category name='" + categoriesList.get(i) + " '/>";
        }
        categoriesXml = categoriesXml + "</categories>";
        return categoriesXml;
    }

    private String getDataSetXml(ArrayList list, String[] countNames) {
        String dataSetXml = "";
        for (int i = 0; i < countNames.length; ++i) {
            String xml = "<dataset seriesname='" + countNames[i] + "' color='" + this.getColor(i) + "'  showValues='0' areaAlpha='70' formatNumberScale='0'  showAreaBorder='0' areaBorderThickness='2' areaBorderColor='" + countNames[0] + "'>";
            for (int j = 0; j < list.size(); ++j) {
                HashMap hm = (HashMap)list.get(j);
                String value = (String)hm.get(countNames[i]);
                xml = xml + "<set value=' " + value + "' />";
            }
            xml = xml + "</dataset>";
            dataSetXml = dataSetXml + xml;
        }
        return dataSetXml;
    }

    private String getDataSetXml(ArrayList list, ArrayList categoriesList, String[] xAxis, String[] countNames) {
        String dataSetXml = "";
        HashMap map = this.envelopList2Map(list, xAxis);
        for (int i = 0; i < countNames.length; ++i) {
            String xml = "<dataset seriesname='" + countNames[i] + "' color='" + this.getColor(i) + "'  showValues='0' areaAlpha='70' formatNumberScale='0'  showAreaBorder='0' areaBorderThickness='2' areaBorderColor='" + countNames[0] + "'>";
            for (int j = 0; j < categoriesList.size(); ++j) {
                String value = "";
                String category = (String)categoriesList.get(j);
                HashMap hm = (HashMap)map.get(category);
                if (hm != null && (value = (String)hm.get(countNames[i])) == null) {
                    value = "";
                }
                xml = xml + "<set value='" + value + "' />";
            }
            xml = xml + "</dataset>";
            dataSetXml = dataSetXml + xml;
        }
        return dataSetXml;
    }

    private String getDataSetXml(ArrayList list, ArrayList categoriesList, String[] xAxis, String[] countNames, String yAxis, int yDataIndex) {
        String dataSetXml = "";
        HashMap map = this.envelopList2Map(list, xAxis);
        for (int i = 0; i < countNames.length; ++i) {
            String xml = "<dataset seriesname='" + countNames[i] + "' color='" + this.getColor(yDataIndex * countNames.length + i) + "'  showValues='0' areaAlpha='70' formatNumberScale='0'  showAreaBorder='0' areaBorderThickness='2' areaBorderColor='" + countNames[0] + "'>";
            for (int j = 0; j < categoriesList.size(); ++j) {
                String value = "";
                String category = (String)categoriesList.get(j);
                HashMap hm = (HashMap)map.get(category);
                if (hm != null && (value = (String)hm.get(countNames[i])) == null) {
                    value = "";
                }
                xml = xml + "<set value='" + value + "' />";
            }
            xml = xml + "</dataset>";
            dataSetXml = dataSetXml + xml;
        }
        return dataSetXml;
    }

    @Override
    public String buildColumn(Context ctx, String reportSql) {
        try {
            ArrayList<String> columus = this.simpleReportDAO.getColumnName(ctx, reportSql);
            JSONArray arr = new JSONArray();
            for (int i = 0; i < columus.size(); ++i) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"name", (Object)columus.get(i));
                obj.put((Object)"x", (Object)"");
                obj.put((Object)"y", (Object)"");
                arr.add((Object)obj);
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)true);
            jsonObj.put((Object)"params", (Object)arr);
            return jsonObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

