/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.report.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.module.report.dao.SimpleReportDAO;
import com.kingdee.portal.biz.module.report.service.DataBuilder;
import com.kingdee.portal.biz.module.report.service.impl.BaseDataBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PieDataBuilder
extends BaseDataBuilder
implements DataBuilder {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SimpleReportDAO simpleReportDAO;

    public void setSimpleReportDAO(SimpleReportDAO simpleReportDAO) {
        this.simpleReportDAO = simpleReportDAO;
    }

    @Override
    public String getReportData(Context ctx, String reportSql, String[] xAxis, String[] yAxis, String[] countNames, String[] countValues) {
        return this.singleGetReportData(ctx, reportSql, xAxis, yAxis, countNames, this.convertCountTypes(countValues));
    }

    private ArrayList getCategoriesData(Context ctx, String reportSql, String[] xAxis) {
        String sqlwapper = "select ";
        sqlwapper = sqlwapper + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + " from (" + reportSql + ") as t group by " + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + this.combineOrders(xAxis);
        this.logger.info("sqlWapper:" + sqlwapper);
        ArrayList list = null;
        try {
            list = this.simpleReportDAO.getReportData(ctx, sqlwapper, xAxis);
            this.logger.info("list" + list);
            this.logger.info("list size:" + list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<String> categoriesList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            HashMap hm = (HashMap)list.get(i);
            String name = (String)hm.get(xAxis[0]);
            for (int j = 1; j < xAxis.length; ++j) {
                name = name + "," + hm.get(xAxis[j]);
            }
            categoriesList.add(name);
        }
        return categoriesList;
    }

    private String singleGetReportData(Context ctx, String reportSql, String[] xAxis, String[] yAxis, String[] countNames, String[] types) {
        String sqlwapper = "select ";
        sqlwapper = sqlwapper + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + "," + this.combineOpWapperStrings(countNames, types);
        sqlwapper = sqlwapper + " from (" + reportSql + ") as t group by " + this.combineStrings(xAxis);
        sqlwapper = sqlwapper + this.combineOrders(xAxis);
        this.logger.info("sqlWapper:" + sqlwapper);
        ArrayList list = null;
        try {
            list = this.simpleReportDAO.getReportData(ctx, sqlwapper, this.combineStrings(xAxis, countNames));
            this.logger.info("list" + list);
            this.logger.info("list size:" + list.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList categoriesList = this.getCategoriesData(ctx, reportSql, xAxis);
        String reportData = this.buildSingleXmlData(list, categoriesList, xAxis, countNames);
        this.logger.info("reportData:" + reportData);
        return reportData;
    }

    private String buildSingleXmlData(ArrayList list, ArrayList categoriesList, String[] xAxis, String[] countNames) {
        String xmlData = "<chart caption='' canvasBgAlpha='0' bgAlpha='0' formatNumberScale='0' showLegend='1'> ";
        xmlData = xmlData + this.getDataSetXml(list, categoriesList, xAxis, countNames);
        xmlData = xmlData + "</chart>";
        return xmlData;
    }

    private String getDataSetXml(ArrayList list, ArrayList categoriesList, String[] xAxis, String[] countNames) {
        String dataSetXml = "";
        HashMap map = this.envelopList2Map(list, xAxis);
        for (int i = 0; i < countNames.length; ++i) {
            String xml = "";
            for (int j = 0; j < categoriesList.size(); ++j) {
                String value = "";
                String category = (String)categoriesList.get(j);
                HashMap hm = (HashMap)map.get(category);
                if (hm != null && (value = (String)hm.get(countNames[i])) == null) {
                    value = "";
                }
                xml = xml + "<set label='" + category + "' value='" + value + "' />";
            }
            dataSetXml = dataSetXml + xml;
        }
        return dataSetXml;
    }

    @Override
    public String buildColumn(Context ctx, String reportSql) {
        try {
            ArrayList<String> columus = this.simpleReportDAO.getColumnName(ctx, reportSql);
            JSONArray arr = new JSONArray();
            for (int i = 0; i < columus.size(); ++i) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"name", (Object)columus.get(i));
                obj.put((Object)"x", (Object)"");
                obj.put((Object)"y", (Object)"hide");
                arr.add((Object)obj);
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)true);
            jsonObj.put((Object)"params", (Object)arr);
            return jsonObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

