/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.report.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.json.Description;
import com.kingdee.portal.biz.common.json.DisplayName;
import com.kingdee.portal.biz.common.json.Preference;
import com.kingdee.portal.biz.common.json.Preferences;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.portal.PortalServiceFacade;
import com.kingdee.portal.biz.facade.portal.facade.PortletDefinitionServiceFacade;
import com.kingdee.portal.biz.module.portlet.dto.PortletParam;
import com.kingdee.portal.biz.module.portlet.entity.PortletCategory;
import com.kingdee.portal.biz.module.portlet.entity.PortletDefinition;
import com.kingdee.portal.biz.module.portlet.service.PortletCategoryService;
import com.kingdee.portal.biz.module.report.dao.SimpleReportDAO;
import com.kingdee.portal.biz.module.report.entity.SimpleReport;
import com.kingdee.portal.biz.module.report.service.DataBuilder;
import com.kingdee.portal.biz.module.report.service.SimpleReportService;
import com.kingdee.portal.biz.module.report.service.impl.DataBuilderFactory;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class SimpleReportServiceImpl
implements SimpleReportService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PortletDefinitionServiceFacade portletDefinitionServiceFacade = PortalServiceFacade.getPortletDefinitionServiceFacade();
    private PortletCategoryService portletCategoryService = (PortletCategoryService)PortalServiceLocator.getBean("portletCategoryService");
    private SimpleReportDAO simpleReportDAO;

    public void setSimpleReportDAO(SimpleReportDAO simpleReportDAO) {
        this.simpleReportDAO = simpleReportDAO;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public SimpleReport findById(PortalContext ctx, String id) throws PortalBizException {
        try {
            return (SimpleReport)this.simpleReportDAO.findById(id);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("simplereport findbyid error", e);
        }
    }

    @Override
    public SimpleReport update(PortalContext ctx, SimpleReport simpleReport) throws PortalBizException {
        try {
            simpleReport.setPortalContext(ctx);
            this.saveOrUpdatePortletDefinition(ctx, simpleReport);
            this.simpleReportDAO.update(simpleReport);
            return simpleReport;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException("simple report update error!", e);
        }
    }

    private void saveOrUpdatePortletDefinition(PortalContext ctx, SimpleReport simpleReport) throws PortalBizException {
        PortletParam portletParam = new PortletParam();
        DisplayName displayName = new DisplayName(simpleReport.getName());
        portletParam.setDisplayName(displayName);
        Description description = new Description(simpleReport.getDesc());
        portletParam.setDescription(description);
        Preferences preferences = new Preferences();
        Preference preference = new Preference("simpleReportId", simpleReport.getId());
        preferences.addPreference(preference);
        portletParam.setPreferences(preferences);
        portletParam.setCategoryId(simpleReport.getCategoryId());
        portletParam.setIcon(simpleReport.getIcon());
        portletParam.setStatus(StatusEnum.ENABLE);
        String portletDefinitionId = simpleReport.getPortletId();
        PortletDefinition portletDefinition = null;
        if (portletDefinitionId != null) {
            portletDefinition = this.portletDefinitionServiceFacade.findPortletDefinitionById(ctx, portletDefinitionId);
        }
        if (portletDefinition != null) {
            this.portletDefinitionServiceFacade.updatePortletDefinition(ctx, portletDefinitionId, portletParam);
        } else {
            portletDefinition = this.portletDefinitionServiceFacade.createPortletDefinition(ctx, "plt_portal", "SimpleReportViewPortlet", portletParam);
            simpleReport.setPortletId(portletDefinition.getId());
        }
    }

    @Override
    public SimpleReport create(PortalContext ctx, SimpleReport simpleReport) throws PortalBizException {
        try {
            simpleReport.setPortalContext(ctx);
            SimpleReport simpleReportSaved = this.simpleReportDAO.create(simpleReport);
            this.saveOrUpdatePortletDefinition(ctx, simpleReportSaved);
            this.simpleReportDAO.update(simpleReportSaved);
            return simpleReportSaved;
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException("simple report create error", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult<SimpleReport> findList(PortalContext ctx, PagingParam pagingParam) throws PortalBizException {
        try {
            PagingResult<SimpleReport> pr = this.simpleReportDAO.findList(new SimpleReport(), pagingParam, new OrderFilter("createTime", OrderEnum.DESC));
            List<SimpleReport> list = pr.getRecords();
            for (SimpleReport simpleReport : list) {
                String portletId = simpleReport.getPortletId();
                PortletDefinition portletDefinition = this.portletDefinitionServiceFacade.findPortletDefinitionById(ctx, portletId);
                simpleReport.setPortletName(portletDefinition.getDisplayName());
                PortletCategory portletCategory = new PortletCategory();
                portletCategory.setId(portletDefinition.getCategoryId());
                portletCategory = this.portletCategoryService.findCategoryById(portletCategory);
                simpleReport.setCategoryName(portletCategory.getCategoryName());
            }
            return pr;
        }
        catch (DataAccessException e) {
            throw new PortalBizException("simple report findList error", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PagingResult findPagingList(Context ctx, String reportSql, PagingParam pagingParam) throws PortalBizException {
        try {
            return this.simpleReportDAO.findPagingList(ctx, reportSql, pagingParam);
        }
        catch (Exception e) {
            throw new PortalBizException("simple report viewResultSet error", e);
        }
    }

    @Override
    public int delete(PortalContext ctx, String id) throws PortalBizException {
        try {
            SimpleReport simpleReport = (SimpleReport)this.simpleReportDAO.findById(id);
            if (!StringUtil.isEmpty((String)simpleReport.getPortletId())) {
                this.portletDefinitionServiceFacade.deletePortletDefinitionById(ctx, simpleReport.getPortletId());
            } else {
                this.logger.info("simpleReport delete, simpleReport.getPortletId() is null.");
            }
            return this.simpleReportDAO.deleteById(id);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw new PortalBizException("simple report delete error", e);
        }
    }

    @Override
    public String getColumn(Context ctx, String reportSql) {
        if (reportSql == null || reportSql.equals("")) {
            return this.buildErrorColumn();
        }
        if (reportSql.toLowerCase().indexOf("update ") >= 0) {
            return this.buildErrorColumn();
        }
        if (reportSql.toLowerCase().indexOf("delete ") >= 0) {
            return this.buildErrorColumn();
        }
        int iSelectBegin = reportSql.toLowerCase().indexOf("select");
        if (iSelectBegin < 0) {
            return this.buildErrorColumn();
        }
        int iSelectEnd = reportSql.toLowerCase().indexOf("from");
        if (iSelectEnd < 0) {
            return this.buildErrorColumn();
        }
        try {
            JSONObject jsonObj = new JSONObject();
            ArrayList<String> columnNames = this.simpleReportDAO.getColumnName(ctx, reportSql);
            jsonObj.put((Object)"success", (Object)true);
            jsonObj.put((Object)"data", (Object)JSONArray.fromObject(columnNames));
            return jsonObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public String getChooseColumn(Context ctx, String reportSql, String chartType, String showStyle) {
        if (reportSql == null || reportSql.equals("")) {
            return this.buildErrorColumn();
        }
        if (reportSql.toLowerCase().indexOf("update ") >= 0) {
            return this.buildErrorColumn();
        }
        if (reportSql.toLowerCase().indexOf("delete ") >= 0) {
            return this.buildErrorColumn();
        }
        int iSelectBegin = reportSql.toLowerCase().indexOf("select");
        if (iSelectBegin < 0) {
            return this.buildErrorColumn();
        }
        int iSelectEnd = reportSql.toLowerCase().indexOf("from");
        if (iSelectEnd < 0) {
            return this.buildErrorColumn();
        }
        if ("tableStyle".equals(showStyle)) {
            return this.buildColumnBySQL(ctx, reportSql);
        }
        DataBuilder dataBuilder = DataBuilderFactory.getDataBuilder(chartType);
        return dataBuilder.buildColumn(ctx, reportSql);
    }

    private String buildColumnBySQL(Context ctx, String reportSql) {
        try {
            JSONArray arr = new JSONArray();
            ArrayList<String> columnNames = this.simpleReportDAO.getColumnName(ctx, reportSql);
            for (String colunmu : columnNames) {
                JSONObject obj = new JSONObject();
                obj.put((Object)"name", (Object)colunmu);
                obj.put((Object)"x", (Object)"");
                obj.put((Object)"y", (Object)"");
                arr.add((Object)obj);
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"result", (Object)true);
            jsonObj.put((Object)"params", (Object)arr);
            return jsonObj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String buildErrorColumn() {
        JSONObject obj = new JSONObject();
        obj.put((Object)"success", (Object)false);
        return obj.toString();
    }

    private String buildColumn(String reportSql) {
        String[] sqlParams = reportSql.split(",");
        JSONArray arr = new JSONArray();
        for (int i = 0; i < sqlParams.length; ++i) {
            JSONObject obj = new JSONObject();
            if (sqlParams[i].contains(" as ")) {
                int iBegin = sqlParams[i].indexOf(" as ");
                obj.put((Object)"name", (Object)sqlParams[i].substring(iBegin + 4, sqlParams[i].length()).trim());
            } else {
                String[] names = sqlParams[i].split(" ");
                obj.put((Object)"name", (Object)names[names.length - 1]);
            }
            obj.put((Object)"x", (Object)"");
            obj.put((Object)"y", (Object)"");
            arr.add((Object)obj);
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"result", (Object)true);
        jsonObj.put((Object)"params", (Object)arr);
        return jsonObj.toString();
    }
}

