/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.setting.dao.impl;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.impl.BaseDAOImpl;
import com.kingdee.portal.biz.common.dao.impl.FieldFilter;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.module.setting.dao.PortalProfileDAO;
import com.kingdee.portal.biz.module.setting.entity.PortalProfile;
import java.util.List;

public class PortalProfileDAOImpl
extends BaseDAOImpl<PortalProfile>
implements PortalProfileDAO {
    @Override
    public PortalProfile getPortalProfileByConfigItem(String item) throws DataAccessException {
        try {
            return (PortalProfile)this.findObject(new Filter[]{new FieldFilter("configItem", "=", item)});
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void updateProfile(PortalContext ctx, List<PortalProfile> profileList) throws DataAccessException {
        try {
            if (profileList != null) {
                for (PortalProfile profile : profileList) {
                    this.updateProfile(ctx, profile);
                }
            }
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void updateProfile(PortalContext ctx, PortalProfile profile) throws DataAccessException {
        try {
            FieldFilter filter = new FieldFilter("configItem", "=", profile.getConfigItem());
            PortalProfile db_pf = (PortalProfile)this.findObject(new Filter[]{filter});
            if (db_pf != null) {
                if (!profile.getConfigValue().equals(db_pf.getConfigValue())) {
                    db_pf.setPortalContext(ctx);
                    db_pf.setConfigValue(profile.getConfigValue());
                    this.update(db_pf);
                }
            } else {
                profile.setPortalContext(ctx);
                this.create(profile);
                this.logger.debug("add portal profile for configItem: " + profile.getConfigItem());
            }
        }
        catch (Exception e) {
            throw new DataAccessException(e);
        }
    }
}

