/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.setting.service.impl;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.common.DCInfo;
import com.kingdee.eas.cp.common.web.util.DataCenterManager;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.jdbc.rowset.impl.SerialBlob;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.module.setting.dao.LogoSettingDAO;
import com.kingdee.portal.biz.module.setting.entity.LogoSetting;
import com.kingdee.portal.biz.module.setting.service.LogoSettingService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.FileUtil;
import java.io.File;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class LogoSettingServiceImpl
implements LogoSettingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LogoSettingDAO logoSettingDAO;

    public void setLogoSettingDAO(LogoSettingDAO logoSettingDAO) {
        this.logoSettingDAO = logoSettingDAO;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public LogoSetting getLogoSettingByLogoName(String type, String dataCenter, String language) throws PortalBizException {
        try {
            LogoSetting ls = null;
            String logoName = type + "_logo_" + dataCenter + "_" + language + ".png";
            if (this.canGetContext(language)) {
                Context context = this.getContext(dataCenter, language);
                StringBuilder permSql = new StringBuilder();
                permSql.append("select * from T_JP_LogoSetting where FLogoName=?");
                IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new String[]{logoName});
                if (rs != null) {
                    while (rs.next()) {
                        ls = new LogoSetting();
                        ls.setId(rs.getString("FId"));
                        ls.setLanguage(rs.getString("FLanguage"));
                        byte[] b = null;
                        InputStream is = null;
                        if ("PostgreSQL".equals(context.get((Object)"dbType"))) {
                            is = rs.getBinaryStream("FLogoContent");
                            b = new byte[is.available()];
                        } else {
                            SerialBlob bb = (SerialBlob)rs.getBlob("FLogoContent");
                            is = bb.getBinaryStream();
                            b = new byte[(int)bb.length()];
                        }
                        is.read(b);
                        ls.setLogoContent(b);
                        ls.setLogoName(rs.getString("FLogoName"));
                        ls.setDataCenter(rs.getString("FDataCenter"));
                        ls.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                    }
                }
            } else {
                String path = this.getFilePrePath(type);
                File file = new File(path + logoName);
                if (file.exists()) {
                    ls = new LogoSetting();
                    ls.setLanguage(language);
                    ls.setLogoName(logoName);
                    ls.setDataCenter(dataCenter);
                    Timestamp ts = new Timestamp(file.lastModified());
                    ls.setLastUpdateTime(ts);
                    byte[] content = FileUtil.getByteArrayData((File)file);
                    ls.setLogoContent(content);
                }
            }
            return ls;
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
    }

    private Context getContext(String dataCenter, String language) {
        Context context = new Context();
        Context userCtx = new Context();
        Locale locale = new Locale(this.transferLanguage(language));
        userCtx.setLocale(locale);
        DataCenterManager dc = new DataCenterManager(userCtx);
        ArrayList dcList = dc.getDCList();
        for (DCInfo di : dcList) {
            if (!dataCenter.equals(di.getNumber())) continue;
            context.setAIS(dataCenter);
            String clientHostIP = di.getDataSource().substring(0, di.getDataSource().indexOf(":"));
            context.setClientHostIP(clientHostIP);
            context.setClientHostName(clientHostIP);
            context.setLocale(locale);
            context.put((Object)"dbType", (Object)di.getDBType());
        }
        return context;
    }

    private boolean canGetContext(String language) {
        Context userCtx = new Context();
        Locale locale = new Locale(this.transferLanguage(language));
        userCtx.setLocale(locale);
        DataCenterManager dc = new DataCenterManager(userCtx);
        ArrayList dcList = dc.getDCList();
        if (dcList.size() == 0) {
            return false;
        }
        for (DCInfo di : dcList) {
            if (di.getDataSource() != null && !di.getDataSource().equals("")) continue;
            return false;
        }
        return true;
    }

    private String getFilePrePath(String type) {
        if ("top".equals(type)) {
            return Constant.SYSTEM_ROOT_PATH + "res" + Constant.SYSTEM_PATH_SEPARATOR + "img" + Constant.SYSTEM_PATH_SEPARATOR + "global" + Constant.SYSTEM_PATH_SEPARATOR + "common" + Constant.SYSTEM_PATH_SEPARATOR;
        }
        int lIndex = Constant.SYSTEM_ROOT_PATH.indexOf("portal.ear");
        String tempPath = Constant.SYSTEM_ROOT_PATH.substring(0, lIndex);
        return tempPath + "eas.ear" + Constant.SYSTEM_PATH_SEPARATOR + "sso_web.war" + Constant.SYSTEM_PATH_SEPARATOR + "images" + Constant.SYSTEM_PATH_SEPARATOR + "newlogin1" + Constant.SYSTEM_PATH_SEPARATOR;
    }

    private String transferLanguage(String language) {
        String lg = "";
        lg = "ch".equals(language) ? "l2" : ("tw".equals(language) ? "l3" : "l1");
        return lg;
    }

    @Override
    public void saveLogoSetting(LogoSetting logoSetting) throws PortalBizException {
        try {
            this.logoSettingDAO.create(logoSetting);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void deleteLogoSettingByLogoName(String logoName) throws PortalBizException {
        try {
            this.logoSettingDAO.deleteLogoSettingByLogoName(logoName);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public void updateAndSaveLogoSetting(PortalContext ctx, LogoSetting logoSetting) throws PortalBizException {
        try {
            LogoSetting setting = this.getLogoSettingFromDB(ctx, logoSetting.getLogoName());
            if (setting == null) {
                this.logoSettingDAO.create(logoSetting);
            } else {
                setting.setLanguage(logoSetting.getLanguage());
                setting.setDataCenter(logoSetting.getDataCenter());
                setting.setLogoContent(logoSetting.getLogoContent());
                this.logoSettingDAO.update(setting);
            }
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
    }

    private LogoSetting getLogoSettingFromDB(PortalContext ctx, String logoName) throws PortalBizException {
        LogoSetting setting = null;
        StringBuilder permSql = new StringBuilder();
        permSql.append("select * from T_JP_LogoSetting where FLogoName=?");
        try {
            Context context = (Context)ctx.getMetaInfo().get("eas_context");
            IRowSet rs = DbUtil.executeQuery((Context)context, (String)permSql.toString(), (Object[])new String[]{logoName});
            if (rs != null) {
                while (rs.next()) {
                    setting = new LogoSetting();
                    setting.setId(rs.getString("FId"));
                    setting.setLanguage(rs.getString("FLanguage"));
                    byte[] b = null;
                    InputStream is = null;
                    if ("PostgreSQL".equals(context.get((Object)"dbType"))) {
                        is = rs.getBinaryStream("FLogoContent");
                        b = new byte[is.available()];
                    } else {
                        SerialBlob bb = (SerialBlob)rs.getBlob("FLogoContent");
                        is = bb.getBinaryStream();
                        b = new byte[(int)bb.length()];
                    }
                    is.read(b);
                    setting.setLogoContent(b);
                    setting.setLogoName(rs.getString("FLogoName"));
                    setting.setDataCenter(rs.getString("FDataCenter"));
                    setting.setLastUpdateTime(rs.getTimestamp("FLastUpdateTime"));
                }
            }
        }
        catch (Exception e) {
            throw new PortalBizException("300", e);
        }
        return setting;
    }
}

