/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.biz.module.setting.service.impl;

import com.kingdee.eas.cp.eip.sso.util.LocaleManager;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.Filter;
import com.kingdee.portal.biz.common.dao.OrderEnum;
import com.kingdee.portal.biz.common.dao.impl.OrderFilter;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.BizException;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.module.page.entity.PageLayoutTmpl;
import com.kingdee.portal.biz.module.page.entity.PageTheme;
import com.kingdee.portal.biz.module.page.service.PageLayoutTmplService;
import com.kingdee.portal.biz.module.page.service.PageThemeService;
import com.kingdee.portal.biz.module.portlet.dao.PortletTmplDAO;
import com.kingdee.portal.biz.module.portlet.entity.PortletTheme;
import com.kingdee.portal.biz.module.portlet.entity.PortletTmpl;
import com.kingdee.portal.biz.module.portlet.service.PortletThemeService;
import com.kingdee.portal.biz.module.setting.dao.PortalProfileDAO;
import com.kingdee.portal.biz.module.setting.dao.SuspensionBtnDAO;
import com.kingdee.portal.biz.module.setting.dto.LinksDTO;
import com.kingdee.portal.biz.module.setting.dto.PortalProfileModel;
import com.kingdee.portal.biz.module.setting.entity.PortalProfile;
import com.kingdee.portal.biz.module.setting.entity.SuspensionButtonConfig;
import com.kingdee.portal.biz.module.setting.service.SettingService;
import com.kingdee.portal.common.util.HttpUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={BizException.class})
public class SettingServiceImpl
implements SettingService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PageLayoutTmplService pageLayoutTmplService = (PageLayoutTmplService)PortalServiceLocator.getBean("pageLayoutTmplService");
    private PageThemeService pageThemeService = (PageThemeService)PortalServiceLocator.getBean("pageThemeService");
    private PortletThemeService portletThemeService = (PortletThemeService)PortalServiceLocator.getBean("portletThemeService");
    private PortalProfileDAO portalProfileDAO;
    private PortletTmplDAO portletTmplDAO;
    private SuspensionBtnDAO suspensionBtnDAO;

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortalProfile findPortalProfileByConfigItem(String item) throws PortalBizException {
        try {
            return this.portalProfileDAO.getPortalProfileByConfigItem(item);
        }
        catch (DataAccessException e) {
            throw new PortalBizException("300", e);
        }
    }

    @Override
    public PortalContext buildTempPortalContext4LoginPage(HttpServletRequest request) throws Exception {
        String dataCenter = StringUtil.convNull((String)request.getParameter("dataCenter"));
        if (StringUtil.isEmpty((String)dataCenter)) {
            dataCenter = HttpUtil.getCookieValue((HttpServletRequest)request, (String)"EasPortalDataCenterCode", (String)"");
        }
        PortalContext portalContext = new PortalContext();
        DSObserver.putDSName(dataCenter);
        portalContext.getMetaInfo().put("current_data_center", dataCenter);
        return portalContext;
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public PortalProfileModel getPortalProfileModel(PortalContext ctx) throws PortalBizException {
        PortalProfileModel model = new PortalProfileModel();
        try {
            List<PortalProfile> profileList = this.portalProfileDAO.findList(new Filter[0]);
            List<PageTheme> pageThemeList = this.pageThemeService.findEnablePageThemeList(ctx);
            List<PageLayoutTmpl> pageLayoutTmplList = this.pageLayoutTmplService.findEnabledLayoutTmplList();
            List<PortletTheme> portletThemeList = this.portletThemeService.findPortletThemeList4Enable();
            List<PortletTmpl> portletTmplList = this.findPortletTmplByStatus(StatusEnum.ENABLE.toString());
            Map sortedLangMap = LocaleManager.getAllSupportLanguage();
            model.setPortalProfileList(profileList);
            model.setPageThemeList(pageThemeList);
            model.setPageLayoutList(pageLayoutTmplList);
            model.setPortletThemeList(portletThemeList);
            model.setPortletTmplList(portletTmplList);
            model.setSortedLangMap(sortedLangMap);
        }
        catch (Exception e) {
            this.logger.error("get portal profile error:", (Throwable)e);
            throw new PortalBizException("300", e);
        }
        return model;
    }

    @Override
    public void updatePortalProfile(PortalContext ctx, PortalProfile portalProfile) throws PortalBizException {
        try {
            this.portalProfileDAO.update(portalProfile);
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    @Override
    public void updatePortalProfile(PortalContext ctx, PortalProfileModel portalProfileModel) throws PortalBizException {
        List<PortalProfile> profileList = portalProfileModel.getPortalProfileList();
        try {
            this.portalProfileDAO.updateProfile(ctx, profileList);
        }
        catch (Exception e) {
            this.logger.error("update portal profile error: ", (Throwable)e);
            throw new PortalBizException("300", e);
        }
    }

    @Override
    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public Map<String, String> findPortalProfileMap() throws PortalBizException {
        HashMap<String, String> profileMap = new HashMap<String, String>();
        List portalProfileList = null;
        try {
            portalProfileList = this.portalProfileDAO.findList(new Filter[0]);
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        for (PortalProfile portalProfile : portalProfileList) {
            profileMap.put(portalProfile.getConfigItem(), portalProfile.getConfigValue());
        }
        return profileMap;
    }

    @Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
    public List<PortletTmpl> findPortletTmplByStatus(String status) throws PortalBizException {
        List<Object> tmplList = null;
        try {
            if (status != null && !status.equals("")) {
                PortletTmpl portletTmpl = new PortletTmpl();
                if (status.equals("ENABLE")) {
                    portletTmpl.setStatus(StatusEnum.ENABLE);
                } else {
                    portletTmpl.setStatus(StatusEnum.DISABLE);
                }
                tmplList = this.portletTmplDAO.findList(portletTmpl, new OrderFilter("createTime", OrderEnum.ASC));
            } else {
                tmplList = this.portletTmplDAO.findList(new OrderFilter("createTime", OrderEnum.ASC));
            }
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
        return tmplList;
    }

    @Override
    public void saveSecondLink(String secondLinkJSON, String parentId, List<LinksDTO> list) throws PortalBizException {
        try {
            ArrayList<SuspensionButtonConfig> entityList = new ArrayList<SuspensionButtonConfig>();
            SuspensionButtonConfig suspensionButtonConfig = null;
            for (LinksDTO linksDTO : list) {
                suspensionButtonConfig = new SuspensionButtonConfig();
                suspensionButtonConfig.setButtondesc(linksDTO.getButtonDesc());
                suspensionButtonConfig.setButtontype(linksDTO.getButtonType());
                suspensionButtonConfig.setButttonname(linksDTO.getButtonName());
                suspensionButtonConfig.setIcon(linksDTO.getIcon());
                suspensionButtonConfig.setLinkurl(linksDTO.getLinkurl());
                suspensionButtonConfig.setOrder(linksDTO.getOrder());
                suspensionButtonConfig.setStatus(linksDTO.getStatus());
                suspensionButtonConfig.setParentid(parentId);
                entityList.add(suspensionButtonConfig);
            }
            boolean existSecondLinkByParentId = this.suspensionBtnDAO.isExistSecondLinkByParentId(parentId);
            if (existSecondLinkByParentId) {
                this.suspensionBtnDAO.updateSecondLink(entityList);
            } else {
                this.suspensionBtnDAO.create(entityList);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveFirstBtn(List<LinksDTO> defaultList, List<LinksDTO> personalList) throws PortalBizException, DataAccessException {
        for (LinksDTO defaultBtn : defaultList) {
            String order = defaultBtn.getOrder();
            String status = defaultBtn.getStatus();
            this.suspensionBtnDAO.updateStatusByTypeAndOrder(status, "DEFAULT", order);
        }
        ArrayList<SuspensionButtonConfig> entityList = new ArrayList<SuspensionButtonConfig>();
        SuspensionButtonConfig suspensionButtonConfig = null;
        for (LinksDTO linksDTO : personalList) {
            suspensionButtonConfig = new SuspensionButtonConfig();
            suspensionButtonConfig.setButtondesc(linksDTO.getButtonDesc());
            suspensionButtonConfig.setButtontype(linksDTO.getButtonType());
            suspensionButtonConfig.setButttonname(linksDTO.getButtonName());
            suspensionButtonConfig.setIcon(linksDTO.getIcon());
            suspensionButtonConfig.setLinkurl(linksDTO.getLinkurl());
            suspensionButtonConfig.setOrder(linksDTO.getOrder());
            suspensionButtonConfig.setStatus(linksDTO.getStatus());
            suspensionButtonConfig.setParentid("personal_button");
            entityList.add(suspensionButtonConfig);
        }
        this.suspensionBtnDAO.updateSecondLink(entityList);
    }

    @Override
    public Map<String, String> findDefaultBtnMap() throws DataAccessException {
        List<SuspensionButtonConfig> findBtnsByParentId = this.suspensionBtnDAO.findBtnsByParentId("default_button");
        HashMap<String, String> mapDefault = new HashMap<String, String>();
        for (SuspensionButtonConfig suspensionButtonConfig : findBtnsByParentId) {
            mapDefault.put(suspensionButtonConfig.getOrder(), suspensionButtonConfig.getStatus());
        }
        return mapDefault;
    }

    @Override
    public Map<String, LinksDTO> findPersonaBtnMap() throws DataAccessException {
        List<SuspensionButtonConfig> findBtnsByParentId = this.suspensionBtnDAO.findBtnsByParentId("personal_button");
        HashMap<String, LinksDTO> mapPersonal = new HashMap<String, LinksDTO>();
        for (SuspensionButtonConfig suspensionButtonConfig : findBtnsByParentId) {
            LinksDTO linksDTO = new LinksDTO();
            linksDTO.setButtonName(suspensionButtonConfig.getButttonname());
            linksDTO.setButtonType(suspensionButtonConfig.getButtontype());
            linksDTO.setIcon(suspensionButtonConfig.getIcon());
            linksDTO.setStatus(suspensionButtonConfig.getStatus());
            linksDTO.setLinkurl(suspensionButtonConfig.getLinkurl());
            mapPersonal.put(suspensionButtonConfig.getOrder(), linksDTO);
        }
        return mapPersonal;
    }

    @Override
    public Map<String, LinksDTO> findSecondLinkConfig(String parentId) throws DataAccessException {
        List<SuspensionButtonConfig> findBtnsByParentId = this.suspensionBtnDAO.findBtnsByParentId(parentId);
        HashMap<String, LinksDTO> map = new HashMap<String, LinksDTO>();
        for (SuspensionButtonConfig suspensionButtonConfig : findBtnsByParentId) {
            LinksDTO linksDTO = new LinksDTO();
            linksDTO.setButtonDesc(suspensionButtonConfig.getButtondesc());
            linksDTO.setButtonName(suspensionButtonConfig.getButttonname());
            linksDTO.setButtonType(suspensionButtonConfig.getButtontype());
            linksDTO.setIcon(suspensionButtonConfig.getIcon());
            linksDTO.setStatus(suspensionButtonConfig.getStatus());
            linksDTO.setLinkurl(suspensionButtonConfig.getLinkurl());
            map.put(suspensionButtonConfig.getOrder(), linksDTO);
        }
        return map;
    }

    @Override
    public Map<String, String> findDefaultBtnMapEnable() throws DataAccessException {
        List<SuspensionButtonConfig> list = this.findBtnsOfDefaultAndEnble();
        HashMap<String, String> mapDefault = new HashMap<String, String>();
        for (SuspensionButtonConfig suspensionButtonConfig : list) {
            mapDefault.put(suspensionButtonConfig.getOrder(), suspensionButtonConfig.getId());
        }
        return mapDefault;
    }

    @Override
    public Map<String, List<LinksDTO>> findPersonBtnMapEnable() throws DataAccessException {
        List<SuspensionButtonConfig> list = this.findBtnsOfPersonAndEnble();
        HashMap<String, List<LinksDTO>> mapPersonal = new HashMap<String, List<LinksDTO>>();
        for (SuspensionButtonConfig suspensionButtonConfig : list) {
            LinksDTO linksDTO = new LinksDTO();
            linksDTO.setButtonName(suspensionButtonConfig.getButttonname());
            linksDTO.setButtonType(suspensionButtonConfig.getButtontype());
            linksDTO.setIcon(suspensionButtonConfig.getIcon());
            linksDTO.setStatus(suspensionButtonConfig.getStatus());
            linksDTO.setLinkurl(suspensionButtonConfig.getLinkurl());
            linksDTO.setOrder(suspensionButtonConfig.getOrder());
            ArrayList<LinksDTO> btnList = new ArrayList<LinksDTO>();
            btnList.add(linksDTO);
            if ("FOLDER".equalsIgnoreCase(suspensionButtonConfig.getButtontype())) {
                List<SuspensionButtonConfig> linkList = this.findLinksOfEnbleByParentIdASC(suspensionButtonConfig.getId());
                for (SuspensionButtonConfig link : linkList) {
                    LinksDTO secondDTO = new LinksDTO();
                    secondDTO.setButtonName(link.getButttonname());
                    secondDTO.setButtonDesc(link.getButtondesc());
                    secondDTO.setButtonType(link.getButtontype());
                    secondDTO.setIcon(link.getIcon());
                    secondDTO.setStatus(link.getStatus());
                    secondDTO.setLinkurl(link.getLinkurl());
                    btnList.add(secondDTO);
                }
            }
            mapPersonal.put(linksDTO.getOrder(), btnList);
        }
        return mapPersonal;
    }

    private List<SuspensionButtonConfig> findBtnsOfDefaultAndEnble() throws DataAccessException {
        SuspensionButtonConfig entity = new SuspensionButtonConfig();
        entity.setButtontype("DEFAULT");
        entity.setStatus("ENABLE");
        List<SuspensionButtonConfig> findList = this.suspensionBtnDAO.findList(entity, null);
        return findList;
    }

    private List<SuspensionButtonConfig> findBtnsOfPersonAndEnble() throws DataAccessException {
        SuspensionButtonConfig entity = new SuspensionButtonConfig();
        entity.setParentid("personal_button");
        entity.setStatus("ENABLE");
        List<SuspensionButtonConfig> findList = this.suspensionBtnDAO.findList(entity, null);
        return findList;
    }

    private List<SuspensionButtonConfig> findLinksOfEnbleByParentIdASC(String parentId) throws DataAccessException {
        return this.suspensionBtnDAO.findLinksOfEnbleByParentIdASC(parentId);
    }

    public void setPortalProfileDAO(PortalProfileDAO portalProfileDAO) {
        this.portalProfileDAO = portalProfileDAO;
    }

    public void setPortletTmplDAO(PortletTmplDAO portletTmplDAO) {
        this.portletTmplDAO = portletTmplDAO;
    }

    public void setSuspensionBtnDAO(SuspensionBtnDAO suspensionBtnDAO) {
        this.suspensionBtnDAO = suspensionBtnDAO;
    }
}

