/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.common.util;

import com.kingdee.util.StringUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.bind.DatatypeConverter;

public abstract class AESUtils {
    protected static final String KEY_ALGO = "AES";
    protected static final String ENCRYPT_ALGO_CBC = "AES/CBC/PKCS5Padding";
    protected static final int IV_LENGTH_BYTE = 16;
    protected static final Charset UTF_8 = StandardCharsets.UTF_8;

    public static String generateKey(int keySize) {
        return AESUtils.bytesToHex(AESUtils.generateRandomKey(keySize));
    }

    private static byte[] generateRandomKey(int keySize) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] key = new byte[keySize];
        secureRandom.nextBytes(key);
        return key;
    }

    private static String bytesToHex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes).toLowerCase();
    }

    public static String cbcDecrypt(String encryptStr, String decryptKey) throws Exception {
        if (encryptStr == null || encryptStr.trim().length() == 0 || decryptKey == null || decryptKey.trim().length() == 0) {
            return null;
        }
        byte[] iv = encryptStr.substring(0, 16).getBytes(UTF_8);
        byte[] key = decryptKey.getBytes();
        byte[] encryptByte = Base64.getDecoder().decode(encryptStr.substring(16, encryptStr.length()));
        return new String(AESUtils.decrypt(encryptByte, key, iv));
    }

    public static String cbcEncrypt(String content, String encryptKey) throws Exception {
        if (content == null || content.trim().length() == 0 || encryptKey == null || encryptKey.trim().length() == 0) {
            return null;
        }
        byte[] pByte = content.getBytes();
        byte[] key = encryptKey.getBytes();
        String random = AESUtils.getRandomNonce(16);
        byte[] iv = random.getBytes(UTF_8);
        byte[] encrypt = AESUtils.encrypt(pByte, key, iv);
        return random + Base64.getEncoder().encodeToString(encrypt);
    }

    public static byte[] encrypt(byte[] pByte, byte[] key, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO_CBC);
        IvParameterSpec parameterSpec = new IvParameterSpec(iv);
        SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGO);
        cipher.init(1, (Key)keySpec, parameterSpec);
        return cipher.doFinal(pByte);
    }

    public static byte[] decrypt(byte[] dByte, byte[] key, byte[] iv) throws Exception {
        Cipher cipher = Cipher.getInstance(ENCRYPT_ALGO_CBC);
        SecretKeySpec keySpec = new SecretKeySpec(key, KEY_ALGO);
        IvParameterSpec parameterSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)keySpec, parameterSpec);
        return cipher.doFinal(dByte);
    }

    public static String getRandomNonce(int number) {
        StringBuilder uid = new StringBuilder();
        SecureRandom rd = new SecureRandom();
        block5: for (int i = 0; i < number; ++i) {
            int type = rd.nextInt(3);
            switch (type) {
                case 0: {
                    uid.append(rd.nextInt(10));
                    continue block5;
                }
                case 1: {
                    uid.append((char)(rd.nextInt(25) + 65));
                    continue block5;
                }
                case 2: {
                    uid.append((char)(rd.nextInt(25) + 97));
                    continue block5;
                }
            }
        }
        return uid.toString();
    }

    public static String decodeForBase64(String value, String preFix) {
        if (!StringUtils.isEmpty((String)preFix) && null != preFix && null != value && value.startsWith(preFix)) {
            value = value.substring(preFix.length());
        }
        return new String(Base64.getDecoder().decode(value));
    }

    public static String encodeForBase64(String value, String preFix) {
        value = Base64.getEncoder().encodeToString(value.getBytes(UTF_8));
        if (!StringUtils.isEmpty((String)preFix) && null != value && !value.startsWith(preFix)) {
            value = preFix.concat(value);
        }
        return value;
    }
}

