/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.common.util;

import com.kingdee.portal.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class FileUtil {
    private static final Logger logger = LoggerFactory.getLogger(FileUtil.class);

    public static String getFileSuffix(String fileName) {
        int i;
        String suffix = "";
        String _fileName = StringUtil.convNull(fileName);
        if (!StringUtil.isEmpty(_fileName) && (i = fileName.lastIndexOf(46)) > 0 && i < fileName.length() - 1) {
            suffix = fileName.substring(i + 1);
        }
        suffix = StringUtil.convNull(suffix).toLowerCase();
        return suffix;
    }

    public static String getBase64Data4Byte(byte[] data) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static byte[] getByteArrayData(String filePath) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(filePath);
            data = FileUtil.getByteArrayData(in);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return data;
    }

    public static byte[] getByteArrayData(InputStream in) {
        byte[] data = null;
        try {
            data = new byte[in.available()];
            in.read(data);
            in.close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return data;
    }

    public static byte[] getByteArrayData(File file) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(file);
            data = FileUtil.getByteArrayData(in);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return data;
    }

    public static byte[] encodedBase64Str(String encodedStr) {
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] biteArray = null;
        try {
            biteArray = decoder.decodeBuffer(encodedStr);
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return biteArray;
    }

    public static void writeFile(byte[] byteArray, String filePath) {
        try {
            FileOutputStream out = new FileOutputStream(filePath);
            ((OutputStream)out).write(byteArray);
            ((OutputStream)out).close();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public boolean deleteFile(String filePath) {
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                return false;
            }
            if (!file.isDirectory()) {
                return false;
            }
            if (file.isFile()) {
                return file.delete();
            }
            return false;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static void deleteFolder(String folderPath) {
        try {
            FileUtil.deleteAllFile(folderPath);
            String filePath = folderPath;
            filePath = filePath.toString();
            File myFilePath = new File(filePath);
            myFilePath.delete();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static boolean deleteAllFile4First(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (!temp.isFile()) continue;
            temp.delete();
        }
        return flag;
    }

    public static boolean deleteAllFile(String path) {
        boolean flag = false;
        File file = new File(path);
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = path.endsWith(File.separator) ? new File(path + tempList[i]) : new File(path + File.separator + tempList[i]);
            if (temp.isFile()) {
                temp.delete();
            }
            if (!temp.isDirectory()) continue;
            FileUtil.deleteAllFile(path + "/" + tempList[i]);
            FileUtil.deleteFolder(path + "/" + tempList[i]);
            flag = true;
        }
        return flag;
    }
}

