/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.common.util;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

public class ImageUtil {
    private static final Logger logger = LoggerFactory.getLogger(ImageUtil.class);

    public static void resizeImage(String imgPath, int width, int height) {
        try {
            File imgFile = new File(imgPath);
            BufferedImage img = ImageIO.read(imgFile);
            int imgHeight = ((Image)img).getHeight(null);
            int imgWidht = ((Image)img).getWidth(null);
            double zoom = ImageUtil.getZoom(imgWidht, imgHeight, width, height);
            int _width = (int)Math.round((double)imgWidht * zoom);
            int _height = (int)Math.round((double)imgHeight * zoom);
            BufferedImage bufferedImage = new BufferedImage(_width, _height, 1);
            bufferedImage.getGraphics().drawImage(img.getScaledInstance(_width, _height, 4), 0, 0, null);
            FileOutputStream out = new FileOutputStream(imgFile);
            ImageIO.write((RenderedImage)bufferedImage, "JPG", out);
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getImgStrData4Byte(byte[] data) {
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(data);
    }

    public static byte[] getImgByteData(String imgFilePath) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return data;
    }

    public static void writeImgFile(byte[] imgContent, String imgFilePath) {
        try {
            FileOutputStream out = new FileOutputStream(imgFilePath);
            ((OutputStream)out).write(imgContent);
            ((OutputStream)out).close();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    public static void deleteImg(String imgFilePath) {
        try {
            File imgFile = new File(imgFilePath);
            imgFile.delete();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private static double getZoom(int imgWidth, int imgHeight, int tmplWidth, int tmplHeight) {
        double heightZoom = 1.0 * (double)tmplHeight / (double)imgHeight;
        double widthZoom = 1.0 * (double)tmplWidth / (double)imgWidth;
        return heightZoom <= widthZoom ? heightZoom : widthZoom;
    }
}

