/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.common.util;

import com.kingdee.portal.common.util.StringUtil;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.PropertyFilter;

public class JSONUtil {
    private static String[][] ENCODE_MAPPING = new String[][]{{"\\{", "0x1"}, {"\\}", "0x2"}, {"\\[", "0x3"}, {"\\]", "0x4"}};

    private JSONUtil() {
    }

    public static Object getObject4Json(String jsonString, Class pojoCalss) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString, (JsonConfig)JSONUtil.getJsonConfig(new PropertyFilter[0]));
        Object pojo = JSONObject.toBean((JSONObject)jsonObject, (Class)pojoCalss);
        return pojo;
    }

    public static Object getObject4Json(String jsonString, Class pojoCalss, Map propertyClassMapping) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString, (JsonConfig)JSONUtil.getJsonConfig(new PropertyFilter[0]));
        Object pojo = JSONObject.toBean((JSONObject)jsonObject, (Class)pojoCalss, (Map)propertyClassMapping);
        return pojo;
    }

    public static String getJson4Object(Object object, String ... excludeField) {
        JsonConfig jsonConfig = JSONUtil.getJsonConfig(new PropertyFilter[0]);
        if (excludeField != null && excludeField.length > 0) {
            jsonConfig.setExcludes(excludeField);
        }
        JSONObject json = JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig);
        return json.toString();
    }

    public static String getJson4Object(Object object) {
        JsonConfig jsonConfig = JSONUtil.getJsonConfig(new PropertyFilter[0]);
        JSONObject json = JSONObject.fromObject((Object)object, (JsonConfig)jsonConfig);
        String string = json.toString();
        string = JSONSerializer.toJSON((Object)string, (JsonConfig)jsonConfig).toString();
        return string;
    }

    public static String getJson4List(Collection list) {
        JsonConfig jsonConfig = JSONUtil.getJsonConfig(new PropertyFilter[0]);
        JSONArray json = JSONArray.fromObject((Object)list, (JsonConfig)jsonConfig);
        String string = json.toString();
        string = JSONSerializer.toJSON((Object)string, (JsonConfig)jsonConfig).toString();
        return string;
    }

    public static String getJson4List(List list, String ... excludeField) {
        JsonConfig jsonConfig = JSONUtil.getJsonConfig(new PropertyFilter[0]);
        if (excludeField != null && excludeField.length > 0) {
            jsonConfig.setExcludes(excludeField);
        }
        JSONArray json = JSONArray.fromObject((Object)list, (JsonConfig)jsonConfig);
        return json.toString();
    }

    public static Map getMap4Json(String jsonString) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString, (JsonConfig)JSONUtil.getJsonConfig(new PropertyFilter[0]));
        Iterator keyIter = jsonObject.keys();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        while (keyIter.hasNext()) {
            String key = (String)keyIter.next();
            Object value = jsonObject.get(key);
            valueMap.put(key, value);
        }
        return valueMap;
    }

    public static String encodeJsonStr(String jsonStr) {
        if (!StringUtil.isEmpty(jsonStr)) {
            for (String[] encodeMapping : ENCODE_MAPPING) {
                jsonStr = jsonStr.replaceAll(encodeMapping[0], encodeMapping[1]);
            }
        }
        return jsonStr;
    }

    public static String decodeJsonStr(String jsonStr) {
        if (!StringUtil.isEmpty(jsonStr)) {
            for (String[] encodeMapping : ENCODE_MAPPING) {
                jsonStr = jsonStr.replaceAll(encodeMapping[1], encodeMapping[0]);
            }
        }
        return jsonStr;
    }

    private static JsonConfig getJsonConfig(PropertyFilter ... propertyFilters) {
        JsonConfig jsonConfig = new JsonConfig();
        JsonValueProcessor jsonDateValueProcessor = new JsonValueProcessor(){

            public Object processArrayValue(Object value, JsonConfig jsonConfig) {
                return this.process(value);
            }

            public Object processObjectValue(String key, Object value, JsonConfig jsonConfig) {
                return this.process(value);
            }

            private Object process(Object value) {
                try {
                    if (value instanceof Timestamp) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        return sdf.format(new Date(((Timestamp)value).getTime()));
                    }
                    if (value instanceof Date) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        return sdf.format((Date)value);
                    }
                    return value == null ? "" : value.toString();
                }
                catch (Exception e) {
                    return "";
                }
            }
        };
        if (propertyFilters != null && propertyFilters.length > 0) {
            jsonConfig.setJsonPropertyFilter(propertyFilters[0]);
        }
        jsonConfig.registerJsonValueProcessor(Timestamp.class, jsonDateValueProcessor);
        jsonConfig.registerJsonValueProcessor(Date.class, jsonDateValueProcessor);
        return jsonConfig;
    }
}

