/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.common.util;

import com.kingdee.portal.common.util.Constant;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.File;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateUtil {
    private static Logger logger = LoggerFactory.getLogger(TemplateUtil.class);

    public static String getServletTmplRootPath() {
        String servletRootPath = Constant.SYSTEM_ROOT_PATH;
        servletRootPath = servletRootPath + "WEB-INF" + Constant.SYSTEM_PATH_SEPARATOR + "templet" + Constant.SYSTEM_PATH_SEPARATOR;
        return servletRootPath;
    }

    public static String merge(String tmplFile, Map<String, Object> context) {
        String result = "";
        try {
            File _tmplFile = new File(tmplFile);
            Configuration config = new Configuration();
            config.setDirectoryForTemplateLoading(_tmplFile.getParentFile());
            config.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            Template template = config.getTemplate(_tmplFile.getName());
            StringWriter out = new StringWriter();
            template.process(context, (Writer)out);
            ((Writer)out).flush();
            ((Writer)out).close();
            result = ((Object)out).toString();
        }
        catch (Exception ex) {
            result = ex.getMessage();
            logger.error(ex.getMessage());
        }
        return result;
    }
}

