/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.other.action;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.base.license.LicenseBaseInfo;
import com.kingdee.eas.base.license.LicenseException;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.EasCloud;
import com.kingdee.eas.base.xtsync.xtutil.EasXtSyncUtil;
import com.kingdee.eas.base.xtsync.xtutil.XtCommunicateUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.EncryptUtils;
import com.kingdee.portal.biz.common.util.XTServiceConfig;
import com.kingdee.portal.biz.common.util.XunTongHelper;
import com.kingdee.util.StringUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.Key;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class CloudHubManagerAction
extends BaseAction {
    public static final String SUPPORT_SALES_URL = "https://support.kingdee.com/osp2016/chat/pc/index.php";
    public static final String SUPPORT_SERVICE_URL = "https://support.kingdee.com/productSelect.php";
    private static final String SECRET = "LTAIKzJqfjQ70Jiw";
    private static LicenseBaseInfo baseInfo = null;

    private boolean isEmpty(String s) {
        return s == null || "".equals(s);
    }

    public void getCloudHubUrl() {
        String eid = "";
        Key key = null;
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            String dataCenterId = ctx.getAIS();
            eid = this.getEid(dataCenterId, ctx);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (user == null || user.getPerson() == null) {
                this.writeErrorData("004");
                return;
            }
            String openId = XunTongHelper.getOpenIdByUserId((Context)ctx, (String)user.getId().toString());
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("dataCenterId", dataCenterId);
            infoMap.put("eid", eid);
            infoMap.put("openId", openId);
            this.logger.error(((Object)infoMap).toString());
            if (!this.isEmpty(eid) && !this.isEmpty(openId)) {
                if (key == null) {
                    key = this.getKey(eid, ctx);
                }
                if (key == null) {
                    this.logger.error("\u672a\u627e\u5230\u4e0eeid\u5339\u914d\u7684key");
                    this.writeErrorData("006");
                    return;
                }
                this.logger.error("\u767b\u5f55web\u4e91\u4e4b\u5bb6\u684c\u9762\u7aef\u4fe1\u606f=====>:");
                String data = eid + "|" + openId + "|" + new Date().getTime();
                this.logger.error("data to sign:" + data);
                String token = EncryptUtils.encryptWithEncodeBase64UTF8((String)data, (Key)key);
                String url = XunTongHelper.getXunTongUrlFromEas((String)eid, (String)openId, (String)token);
                this.logger.error("url==========:" + url);
                this.writeAjaxData(true, null, url);
            } else {
                if (this.isEmpty(eid)) {
                    this.writeErrorData("001");
                    return;
                }
                if (this.isEmpty(openId)) {
                    this.writeErrorData("002");
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            LocalErr localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
    }

    public void getCustomerServiceUrl() throws Exception {
        try {
            String url = null;
            String type = this.getRequest().getParameter("type");
            baseInfo = baseInfo == null ? LicenseSrvAgentFactory.getRemoteInstance().getLicenseBaseInfo() : baseInfo;
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            Map<String, String> params = this.buildUrlParam(userInfo, type);
            url = "Sales".equalsIgnoreCase(type) ? "https://support.kingdee.com/osp2016/chat/pc/index.php?" + CloudHubManagerAction.getQueryString(params) : "https://support.kingdee.com/productSelect.php?" + CloudHubManagerAction.getQueryString(params);
            this.writeAjaxData(true, null, url);
        }
        catch (LicenseException e) {
            this.writeAjaxData(false, null, "getCustomerServiceUrl error!!!");
            e.printStackTrace();
        }
    }

    private Map<String, String> buildUrlParam(UserInfo userInfo, String type) throws Exception {
        ConcurrentHashMap<String, String> params = new ConcurrentHashMap<String, String>();
        String _userId = userInfo.getId().toString();
        String uid = userInfo.getUid();
        params.put("vendorID", "8");
        params.put("type", type);
        params.put("source", "EASProduct");
        params.put("clientId", EasCloud.CLIENT_ID);
        params.put("serviceType", "1");
        params.put("kduid", StringUtils.isEmpty((String)uid) ? "unknown" : uid);
        if (!StringUtils.isEmpty((String)uid)) {
            JSONObject rs = EasCloud.cloudErpAccessToken((String)uid, (String)(StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID()));
            if (rs != null && rs.getIntValue("errcode") == 0) {
                String access_token = rs.getJSONObject("data").getString("access_token");
                if ((rs = EasCloud.getUserAuthCode((String)access_token)) != null && rs.getIntValue("errcode") == 0) {
                    params.put("authCode", rs.getJSONObject("data").getString("auth_code"));
                } else {
                    System.out.println(rs.toJSONString());
                    if ("Service".equals(type)) {
                        throw new BOSException(EasCloud.getErrorMsg((JSONObject)rs));
                    }
                }
            } else {
                System.out.println(rs.toJSONString());
                if ("Service".equals(type)) {
                    throw new BOSException(EasCloud.getErrorMsg((JSONObject)rs));
                }
            }
        }
        params.put("erpId", URLEncoder.encode(_userId, "UTF-8"));
        params.put("erpName", URLEncoder.encode(userInfo.getName(), "UTF-8"));
        String erpPhone = userInfo.getCell();
        params.put("erpPhone", StringUtils.isEmpty((String)erpPhone) ? "unknown" : erpPhone);
        String erpEmail = userInfo.getEmail();
        params.put("erpEmail", StringUtils.isEmpty((String)erpEmail) ? "unknown" : erpEmail);
        String version = baseInfo.getVersion();
        params.put("prodVersion", URLEncoder.encode(StringUtils.isEmpty((String)version) ? "unknown" : version, "UTF-8"));
        params.put("prodCategoryCode", "EAS");
        params.put("prodDeployWay", "Offline");
        params.put("prodInstCode", StringUtils.isEmpty((String)baseInfo.getProductInstanceID()) ? "unknown" : baseInfo.getProductInstanceID());
        params.put("prodSN", StringUtils.isEmpty((String)baseInfo.getSerialNum()) ? "unknown" : baseInfo.getSerialNum());
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        params.put("serviceEndDate", baseInfo.getServiceDate() == null ? "unknown" : sdf.format(baseInfo.getServiceDate()));
        params.put("userRole", "Normal");
        String timeStamp = String.valueOf(new Date().getTime());
        params.put("timestamp", timeStamp);
        String nonce = UUID.randomUUID().toString().replace("-", "");
        params.put("nonce", nonce);
        Iterator ite = params.entrySet().iterator();
        Object[] values = new String[params.size()];
        int i = 0;
        while (ite.hasNext()) {
            Map.Entry value = ite.next();
            values[i++] = (String)value.getValue();
        }
        Arrays.sort(values);
        StringBuilder sb = new StringBuilder();
        for (Object str : values) {
            sb.append((String)str);
        }
        params.put("signature", EasCloud.sha1((String)(SECRET + sb.toString())));
        return params;
    }

    private static String getQueryString(Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        for (String key : params.keySet()) {
            String value = params.get(key);
            if (value != null & value.contains("+")) {
                value = value.replaceAll("\\+", "");
            }
            sb.append(key).append("=").append(value).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private String getEid(String dataCenterId, Context ctx) {
        String eid = EasXtSyncUtil.getInstance((Context)ctx).getEid();
        if (this.isEmpty(eid)) {
            eid = XTServiceConfig.getInstance().getEidByDbCode(dataCenterId);
        }
        return eid;
    }

    private Key getKey(String eid, Context ctx) throws Exception {
        try {
            Key key = this.getKeyFromXtSync(eid, ctx);
            if (key != null) {
                return key;
            }
            String dataCenterId = ctx.getAIS();
            byte[] keyByte = EncryptUtils.getBytesFromFile((String)(System.getProperty("eas.properties.dir") + "/" + dataCenterId + "____" + eid + ".key"));
            return EncryptUtils.restorePrivateKey((byte[])keyByte);
        }
        catch (FileNotFoundException e) {
            this.logger.error(e.getMessage());
            return null;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    private Key getKeyFromXtSync(String eid, Context ctx) {
        try {
            return XtCommunicateUtil.getInstance((Context)ctx).getKeyByEid(eid);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeErrorData(String errCode) {
        LocalErr localErr = new LocalErr();
        localErr.setDesc(errCode);
        this.writeAjaxData(false, localErr, null);
    }

    public void getCloudWebXiaoxiUrl() {
        String eid = "";
        Key key = null;
        try {
            Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
            String dataCenterId = ctx.getAIS();
            eid = this.getEid(dataCenterId, ctx);
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (user == null || user.getPerson() == null) {
                this.writeErrorData("004");
                return;
            }
            String openId = XunTongHelper.getOpenIdByUserId((Context)ctx, (String)user.getId().toString());
            HashMap<String, String> infoMap = new HashMap<String, String>();
            infoMap.put("dataCenterId", dataCenterId);
            infoMap.put("eid", eid);
            infoMap.put("openId", openId);
            this.logger.error(((Object)infoMap).toString());
            if (!this.isEmpty(eid) && !this.isEmpty(openId)) {
                if (key == null) {
                    key = this.getKey(eid, ctx);
                }
                if (key == null) {
                    this.logger.error("\u672a\u627e\u5230\u4e0eeid\u5339\u914d\u7684key");
                    this.writeErrorData("006");
                    return;
                }
                this.logger.error("\u767b\u5f55web\u4e91\u4e4b\u5bb6\u6d88\u606f\u9875\u9762\u4fe1\u606f=====>:");
                String data = "{\"privatevalue\":\"" + openId + "\",\"flag\":\"0\",\"bizNo\":\"EAS\"}";
                this.logger.error("data to sign:" + data);
                String token = EncryptUtils.encryptWithEncodeBase64UTF8((String)data, (Key)key);
                HashMap<String, String> retData = new HashMap<String, String>();
                retData.put("eid", eid);
                retData.put("token", token);
                this.writeAjaxData(true, null, retData);
            } else {
                if (this.isEmpty(eid)) {
                    this.writeErrorData("001");
                    return;
                }
                if (this.isEmpty(openId)) {
                    this.writeErrorData("002");
                    return;
                }
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            LocalErr localErr = this.handleErr(e);
            this.writeAjaxData(false, localErr, null);
        }
    }

    public void cloudHubClicked() {
        Context ctx = (Context)this.getPortalContext().getMetaInfo().get("eas_context");
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (user == null) {
            this.writeAjaxData(true, null, null);
            return;
        }
        String userid = user.getId().toString();
        String existsql = "select fuserid from T_JP_CloudHubClicked where fuserid = ?";
        String insertsql = "insert into T_JP_CloudHubClicked(fuserid) values(?)";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)existsql, (Object[])new String[]{userid});
            if (rs.next()) {
                this.writeAjaxData(true, null, null);
                return;
            }
            DbUtil.execute((Context)ctx, (String)insertsql, (Object[])new String[]{userid});
            this.writeAjaxData(false, null, null);
            return;
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.writeAjaxData(true, null, null);
    }
}

