/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.page.action;

import com.kingdee.bos.Context;
import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.entity.TreeBaseEntity;
import com.kingdee.portal.biz.common.enums.LockTypeEnum;
import com.kingdee.portal.biz.common.enums.StatusEnum;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.exception.handle.ErrHandle;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.page.common.enums.NodeTypeEnum;
import com.kingdee.portal.biz.module.page.common.json.ELinkNodeExt;
import com.kingdee.portal.biz.module.page.dto.PageModel;
import com.kingdee.portal.biz.module.page.entity.Page;
import com.kingdee.portal.biz.module.page.entity.PageCache;
import com.kingdee.portal.biz.module.page.service.OnlineEditPageService;
import com.kingdee.portal.biz.module.page.service.PageCacheService;
import com.kingdee.portal.biz.module.page.service.PageService;
import com.kingdee.portal.biz.module.perm.service.PermService;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class PageAction
extends BaseAction {
    private PageCache pageCache;
    private PageService pageService = (PageService)PortalServiceLocator.getBean((String)"pageService");
    private PageCacheService pageCacheService = (PageCacheService)PortalServiceLocator.getBean((String)"pageCacheService");
    private PermService permService = (PermService)PortalServiceLocator.getBean((String)"permService");
    private OnlineEditPageService onlineEditPageService = (OnlineEditPageService)PortalServiceLocator.getBean((String)"onlineEditPageService");

    public String findBasePageLayoutList() {
        List list = PortalCache.getEnabledPageLayoutTmplList();
        this.writeAjaxData(true, null, list);
        return null;
    }

    public void findSpaceList() {
        try {
            Map spaceMap = this.pageService.findPersonalSpaceMap(this.getPortalContext(), this.getPermMap());
            this.writeAjaxData(true, null, spaceMap);
        }
        catch (PortalBizException pe) {
            this.logger.error(pe.getMessage());
            this.writeAjaxData(false, pe.getLocalErr(this.getPortalContext()), null);
        }
    }

    public void findPageList() {
        try {
            Page firstPage;
            String spaceId = this.getRequest().getParameter("spaceId");
            String pageId = this.getRequest().getParameter("pageId");
            String lockType = this.getRequest().getParameter("lockType");
            this.buildSpaceId(this.getPortalContext(), spaceId);
            int ilevel = 5;
            Map pageMap = this.pageService.findPersonalPageMap(this.getPortalContext(), spaceId, ilevel, this.getPermMap(), 2);
            String defaultPageId = "";
            if (pageId == null && (firstPage = this.pageService.findPageById(this.getPortalContext(), spaceId)) != null) {
                defaultPageId = firstPage.getDefaultPageId();
                pageMap.put("defaultPageId", defaultPageId);
            }
            if (pageId == null) {
                Boolean isMoreThan9 = false;
                List<Page> firstLevelPages = (ArrayList)pageMap.get("firstLevelPages");
                if ("header".equalsIgnoreCase(lockType)) {
                    boolean flag = false;
                    for (Page page : firstLevelPages) {
                        if (!"bc3c44bf-2787-4123-a941-87a473af9367".equalsIgnoreCase(page.getId())) continue;
                        ArrayList<Page> TempFirstLevelPages = new ArrayList<Page>();
                        TempFirstLevelPages.add(page);
                        firstLevelPages = TempFirstLevelPages;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        firstLevelPages = new ArrayList();
                    }
                }
                if (firstLevelPages.size() > 9 && !"Nav".equalsIgnoreCase(lockType)) {
                    isMoreThan9 = true;
                    List TempFirstLevelPages = firstLevelPages.subList(0, 9);
                    firstLevelPages = TempFirstLevelPages;
                }
                List pageList = new ArrayList();
                if ("tabbar".equalsIgnoreCase(lockType)) {
                    pageList = this.pageService.findLockPageList(this.getPortalContext(), spaceId, LockTypeEnum.TABBAR);
                } else if ("header".equalsIgnoreCase(lockType)) {
                    pageList = this.pageService.findLockPageList(this.getPortalContext(), spaceId, LockTypeEnum.HEADER);
                }
                for (Page page : pageList) {
                    firstLevelPages.add(page);
                }
                pageMap.put("firstLevelPages", firstLevelPages);
                pageMap.put("isMoreThan9", isMoreThan9);
                this.writeAjaxData(true, null, pageMap);
            } else {
                List<Page> newPageList = this.buildPageList(pageMap, pageId);
                this.writeAjaxData(true, null, newPageList);
            }
        }
        catch (PortalBizException pe) {
            this.logger.error(pe.getMessage());
            this.writeAjaxData(false, pe.getLocalErr(this.getPortalContext()), null);
        }
    }

    public void findLockPageListBySecondPageID() {
        HashMap<String, List> pageMap = new HashMap<String, List>();
        String spaceId = this.getRequest().getParameter("spaceId");
        if (StringUtils.isEmpty((String)spaceId)) {
            spaceId = "303e5452-1200-4ccf-9a93-f398f48f12f7";
        }
        String secondPageID = this.getRequest().getParameter("secondPageID");
        try {
            List pageList = this.pageService.findLockPageList(this.getPortalContext(), spaceId, secondPageID);
            pageMap.put("firstLevelPages", pageList);
            this.writeAjaxData(true, null, pageMap);
        }
        catch (PortalBizException e) {
            this.logger.error(" Get lock page list ERROR !!! when no portal license!!!", (Throwable)e);
            this.writeAjaxData(false, e.getLocalErr(this.getPortalContext()), null);
        }
    }

    public void findLockPageListNoLicense() {
        HashMap pageMap = new HashMap();
        String spaceId = FilterSpecialCharactersTool.cleanXSS((String)this.getRequest().getParameter("spaceId"));
        String layoutType = FilterSpecialCharactersTool.cleanXSS((String)this.getRequest().getParameter("layoutType"));
        String lockType = FilterSpecialCharactersTool.cleanXSS((String)this.getRequest().getParameter("lockType"));
        if (StringUtils.isEmpty((String)spaceId)) {
            spaceId = "303e5452-1200-4ccf-9a93-f398f48f12f7";
        }
        if (StringUtils.isEmpty((String)lockType)) {
            lockType = "tabbar";
        }
        try {
            List<Page> pageList = new ArrayList();
            if ("header".equalsIgnoreCase(lockType) && "layout_new".equals(layoutType)) {
                Page newPage = this.pageService.findPageById(this.getPortalContext(), "37f1c060-9fe7-4658-95eb-438d23af1c54");
                pageList.add(newPage);
            } else if ("tabbar".equalsIgnoreCase(lockType)) {
                pageList = this.pageService.findLockPageList(this.getPortalContext(), spaceId);
                if (!"layout_new".equals(layoutType)) {
                    this.addAppCenterMenu(pageList);
                }
            }
            pageMap.put("firstLevelPages", pageList);
            this.writeAjaxData(true, null, pageMap);
        }
        catch (PortalBizException e) {
            this.logger.error(" Get lock page list ERROR !!! when no portal license!!!", (Throwable)e);
            this.writeAjaxData(false, e.getLocalErr(this.getPortalContext()), null);
        }
    }

    private void addAppCenterMenu(List<Page> pageList) {
        String appCenterPageID = "9c404817-9a16-49a6-8fd6-20dfe8b4ea4d";
        try {
            if (pageList.size() > 0 && appCenterPageID.equalsIgnoreCase(pageList.get(0).getId())) {
                return;
            }
            for (Page page : pageList) {
                if (!appCenterPageID.equalsIgnoreCase(page.getId())) continue;
                pageList.remove(page);
                pageList.add(0, page);
                return;
            }
            Page appCenter = this.pageService.findPageById(this.getPortalContext(), appCenterPageID);
            if (appCenter != null) {
                pageList.add(0, appCenter);
            }
        }
        catch (PortalBizException e) {
            this.logger.error(" addAppCenterMenu add app center ERROR!!!", (Throwable)e);
        }
    }

    private List<Page> buildPageList(Map<String, Object> pageMap, String pageId) {
        ArrayList<Page> newPageList = new ArrayList<Page>();
        ArrayList subList = new ArrayList();
        List pageList = (List)((Map)pageMap.get("multiTreeNodes")).get(pageId);
        if (pageList != null) {
            for (int j = 0; j < pageList.size(); ++j) {
                String snoedeType = ((Page)pageList.get(j)).getNodeType().toString();
                if (((Page)pageList.get(j)).getNodeLevel() != 3) continue;
                ELinkNodeExt nodeExt = new ELinkNodeExt(((Page)pageList.get(j)).getNodeExt());
                if (snoedeType.equals("FOLDER") || snoedeType.equals("EXTERNAL_LINK") && !nodeExt.getLeaf().booleanValue() || snoedeType.equals("EXTERNAL_LINK_G") && !nodeExt.getLeaf().booleanValue()) {
                    newPageList.add((Page)pageList.get(j));
                    for (int k = j + 1; k < pageList.size(); ++k) {
                        if (!((Page)pageList.get(j)).hasChildNode((TreeBaseEntity)pageList.get(k))) continue;
                        newPageList.add((Page)pageList.get(k));
                    }
                    continue;
                }
                subList.add(pageList.get(j));
            }
            if (subList.size() > 0) {
                for (int n = 0; n < subList.size(); ++n) {
                    newPageList.add((Page)subList.get(n));
                }
            }
        }
        return newPageList;
    }

    private String buildSpaceId(PortalContext ctx, String spaceId) {
        if (spaceId == null || spaceId.equals("")) {
            try {
                Map spaceMap = this.pageService.findPersonalSpaceMap(ctx, this.getPermMap());
                List spaceList = (List)spaceMap.get("spaceList");
                spaceId = ((Page)spaceList.get(0)).getId();
            }
            catch (PortalBizException e) {
                this.logger.error("buildSpaceId===", (Throwable)e);
            }
        }
        return spaceId;
    }

    public void findAllFuncList() {
        try {
            String bizPageId = this.getRequest().getParameter("bizPageId");
            Map map = this.pageService.findBizPageMapWithLevel(this.getPortalContext(), bizPageId, this.getPermMap());
            this.writeAjaxData(true, null, map);
        }
        catch (PortalBizException e) {
            this.logger.error(e.getMessage());
            this.writeAjaxData(false, e.getLocalErr(this.getPortalContext()), null);
        }
    }

    public String findPageCache() {
        boolean success = true;
        LocalErr localErr = null;
        PageCache result = null;
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            if (FilterSpecialCharactersTool.isUUID((String)this.pageCache.getPageId())) {
                result = this.pageCacheService.findPageCache4Show(portalContext, this.pageCache.getPageId(), this.pageCache.getUserId());
            }
        }
        catch (Exception ex) {
            success = false;
            localErr = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    private PageModel getPageModel4Cache(String pageId, String userId) {
        Map pageModelMap = (Map)this.getRequest().getSession().getAttribute("temp_page_edit_model");
        if (pageModelMap == null) {
            return null;
        }
        String pageMdoelKey = pageId + "_" + userId;
        return (PageModel)pageModelMap.get(pageMdoelKey);
    }

    public String findPageCache4Sync() {
        boolean success = true;
        LocalErr localErr = null;
        PageCache result = null;
        PortalContext portalContext = null;
        try {
            portalContext = this.getPortalContext();
            this.onlineEditPageService.syncPersonalPageFormAdmin(portalContext, this.pageCache.getPageId(), this.pageCache.getUserId());
            this.pageCacheService.buildPageCache(portalContext, this.pageCache.getPageId(), this.pageCache.getUserId());
            result = this.pageCacheService.findPageCache4Show(portalContext, this.pageCache.getPageId(), this.pageCache.getUserId());
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String buildPageCache() {
        boolean success = true;
        LocalErr localErr = null;
        Object result = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            this.pageCacheService.buildPageCache(portalContext, this.pageCache.getPageId(), this.pageCache.getUserId());
            PortalCache.clearEnabledSysPageList();
            this.logger.info("buildPageCache success.");
        }
        catch (Exception ex) {
            success = false;
            localErr = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String deletePageCache() {
        boolean success = true;
        LocalErr localErr = null;
        Object result = null;
        PortalContext portalContext = this.getPortalContext();
        try {
            this.pageCacheService.deletePageCache(portalContext, this.pageCache.getPageId(), this.pageCache.getUserId());
            this.logger.info("deletePageCache success.");
        }
        catch (Exception ex) {
            success = false;
            localErr = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public void findSecondPageByMenuID() {
        boolean success = true;
        LocalErr localErr = null;
        String menuId = this.getRequest().getParameter("menuId");
        try {
            Page page = this.pageService.findPageById(this.getPortalContext(), menuId);
            if (page == null || page.getNodeLevel() != 5) {
                this.writeAjaxData(success, localErr, "");
                return;
            }
            String nodePath = page.getNodePath();
            String[] nodes = nodePath.split("/");
            String secondPageID = nodes[4];
            Page secondPage = this.pageService.findPageById(this.getPortalContext(), secondPageID);
            this.writeAjaxData(success, localErr, secondPage);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    public void findNewPageIDByMenuID() {
        boolean success = true;
        LocalErr localErr = null;
        PortalContext portalContext = this.getPortalContext();
        Context ctx = (Context)portalContext.getMetaInfo().get("eas_context");
        String menuId = this.getRequest().getParameter("menuId");
        try {
            Page page = this.pageService.findPageById(this.getPortalContext(), menuId);
            if (page == null || page.getNodeLevel() != 3) {
                this.writeAjaxData(success, localErr, "");
                return;
            }
            String newPageID = this.pageService.findNewPageIDByMenuID(ctx, menuId);
            if (StringUtils.isEmpty((String)newPageID) && !StringUtils.isEmpty((String)(newPageID = this.pageService.createNewPage(portalContext, menuId)))) {
                this.pageService.createNewPageAndMenuID(ctx, menuId, newPageID);
            }
            this.writeAjaxData(success, localErr, newPageID);
        }
        catch (PortalBizException e) {
            e.printStackTrace();
        }
    }

    public void getPlanSwitchList() throws PortalBizException {
        HttpServletRequest request = this.getRequest();
        PortalContext portalContext = this.getPortalContext();
        String pageId = request.getParameter("pageId");
        String inputValue = request.getParameter("inputValue");
        Page page = this.pageService.findPageById(portalContext, pageId);
        if (NodeTypeEnum.PLAN.equals((Object)page.getNodeType())) {
            pageId = page.getParentNodeId();
            page = this.pageService.findPageById(portalContext, pageId);
        }
        String[] userIds = new String[]{"portal_template_user", portalContext.getLoginUser().getId()};
        List pages = this.pageService.findPageListByParentIdAndUserIdsAndStatus(portalContext, pageId, userIds, StatusEnum.ENABLE);
        if (!"00000000-0000-0000-0000-00000000000013B7DE7F".equals(portalContext.getLoginUser().getId())) {
            pages = this.permService.selectPermPageList(portalContext, pages, null, portalContext.getLoginUser().getId());
        }
        if (pages == null) {
            pages = new ArrayList<Page>();
        }
        pages.add(page);
        List dtos = this.pageService.getPagingPlanList(portalContext, pages, this.pagingParam, inputValue);
        int total = pages.size();
        if (!StringUtils.isEmpty((String)inputValue)) {
            total = dtos.size();
        }
        PagingResult pagingResult = new PagingResult();
        pagingResult.setRecords(dtos);
        pagingResult.setTotalCount(total);
        pagingResult.setPagingParam(this.pagingParam);
        this.writePagingResult(pagingResult);
    }

    public PageCache getPageCache() {
        return this.pageCache;
    }

    public void setPageCache(PageCache pageCache) {
        this.pageCache = pageCache;
    }
}

