/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.personal.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.CryptException;
import com.kingdee.bos.util.CryptoTean;
import com.kingdee.eas.base.license.client.LicenseSrvAgentFactory;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.utils.SecurityValidator;
import com.kingdee.eas.basedata.assistant.GlobalRoamingCollection;
import com.kingdee.eas.basedata.assistant.GlobalRoamingFactory;
import com.kingdee.eas.basedata.assistant.GlobalRoamingInfo;
import com.kingdee.eas.basedata.assistant.IGlobalRoaming;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.sso.util.BASE64Util;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.i18n.service.II18nService;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.biz.module.personal.dto.GlobalRoamingDTO;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;

public class PersonalAction
extends BaseAction {
    private EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
    private II18nService i18nService = (II18nService)PortalServiceLocator.getBean((String)"i18nService");
    String regex_mobile = "^((17[0-9])|(14[0-9])|(13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";
    String regex_phone = "^[0-9]+[-][0-9]+|[0-9]+$";
    String regex_email = "^([a-z0-9A-Z]+[-|\\.|_]?)+[a-z0-9A-Z_-]@([a-z0-9A-Z_-]+(-[a-z0-9A-Z_-]+)?\\.)+[a-zA-Z]{2,}$";

    public String updateUserPWD() {
        boolean success = true;
        LocalErr localErr = null;
        Object message = null;
        try {
            PortalContext portalContext = this.getPortalContext();
            String oldPwd = BASE64Util.decodeAsString((String)this.getRequest().getParameter("oldPwd"));
            String newPwd = BASE64Util.decodeAsString((String)this.getRequest().getParameter("newPwd"));
            this.easService.updateLoginUserPWD(portalContext, oldPwd, newPwd);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
            localErr.setStackInfo("");
            this.logger.error(localErr.toString());
        }
        this.writeAjaxData(success, localErr, message);
        return null;
    }

    public String updatePersonMetaInfo() {
        boolean success = true;
        LocalErr localErr = null;
        int result = 0;
        try {
            if (!FilterSpecialCharactersTool.isContainSQLSpecialCharacters((HttpServletRequest)this.getRequest())) {
                PortalContext portalContext = this.getPortalContext();
                String cell = this.getRequest().getParameter("cell");
                String backupEMail = this.getRequest().getParameter("backupEMail");
                String backupCell = this.getRequest().getParameter("backupCell");
                String email = this.getRequest().getParameter("email");
                String officePhone = this.getRequest().getParameter("officePhone");
                String homePhone = this.getRequest().getParameter("homePhone");
                String globalRoaming = this.getRequest().getParameter("globalRoaming");
                String[] phoneInfo = new String[]{cell, backupCell, officePhone, homePhone};
                String[] emailInfo = new String[]{email, backupEMail};
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
                PersonInfo info = ContextUtil.getCurrentUserInfo((Context)ctx).getPerson();
                if ((info == null || info.getId() == null) && StringUtils.isEmpty((String)cell) && "Register".equalsIgnoreCase(LicenseSrvAgentFactory.getLocalInstance((Context)ctx).getControlPolicy()) && !Administrator.isDefaultUser((BOSUuid)ContextUtil.getCurrentUserInfo((Context)ctx).getId())) {
                    localErr = this.handleErr((Exception)((Object)new BOSException("\u5f53\u524d\u7528\u6237\u672a\u7ed1\u5b9a\u804c\u5458\uff0c\u624b\u673a\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165")));
                    success = false;
                } else if (this.checkPersonMetaInfo(phoneInfo, emailInfo)) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("backupCell", backupCell);
                    map.put("backupEMail", backupEMail);
                    map.put("cell", cell);
                    map.put("email", email);
                    map.put("officePhone", officePhone);
                    map.put("homePhone", homePhone);
                    map.put("globalRoaming", globalRoaming);
                    result = this.easService.updatePersonMetaInfoNew(portalContext, map);
                } else {
                    localErr = this.handleErr((Exception)((Object)new BOSException("\u7528\u6237\u4fe1\u606f\u5b58\u5728\u654f\u611f\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165")));
                    success = false;
                }
            } else {
                success = false;
            }
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.writeAjaxData(success, localErr, result);
        return null;
    }

    public String personView() {
        boolean success = true;
        LocalErr localErr = null;
        Map personMap = new HashMap();
        String personId = this.getRequest().getParameter("personId");
        try {
            PortalContext portalContext = this.getPortalContext();
            personMap = this.easService.getPersonBaseInfo(this.getRequest(), portalContext, personId);
        }
        catch (Exception ex) {
            success = false;
            localErr = this.handleErr(ex);
        }
        this.getRequest().setAttribute("person", personMap);
        return "success";
    }

    public String getPwdTip() {
        String pwdTip = "";
        PortalContext portalContext = this.getPortalContext();
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)context);
        try {
            Class<?> cls = Class.forName("com.kingdee.eas.base.permission.helper.SecurityValidatorHelper");
            Object obj = cls.newInstance();
            Method setConextMethod = cls.getMethod("getPwdTip", Context.class, String.class);
            Object obj_pwdTip = setConextMethod.invoke(obj, context, userInfo.getNumber());
            pwdTip = String.valueOf(obj_pwdTip);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("PersonalAction 1 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (InstantiationException e) {
            this.logger.error("PersonalAction 2 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            this.logger.error("PersonalAction 3 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (SecurityException e) {
            this.logger.error("PersonalAction 4 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            this.logger.error("PersonalAction 5 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            this.logger.error("PersonalAction 6 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            this.logger.error("PersonalAction 7 getPwdTip \u6839\u636eEAS\u5b9e\u9645\u7684\u7528\u6237\u540d\u5f97\u5230\uff0c\u5bc6\u7801\u7b56\u7565\u4fe1\u606f:", (Throwable)e);
        }
        this.writeAjaxData(true, null, pwdTip);
        return null;
    }

    public void getUpdatePwReason() {
        UserInfo userInfo;
        PortalContext portalContext = this.getPortalContext();
        Context context = (Context)portalContext.getMetaInfo().get("eas_context");
        com.kingdee.eas.base.permission.util.SecurityValidator securityValidator = new com.kingdee.eas.base.permission.util.SecurityValidator(context, userInfo = ContextUtil.getCurrentUserInfo((Context)context));
        String updatePwReason = securityValidator.getUpdatePwReason();
        if (StringUtils.isEmpty((String)updatePwReason)) {
            UserInfo userInfoCopy = (UserInfo)userInfo.clone();
            String plainPassword = null;
            try {
                String encryptPassword = (String)context.get((Object)"encryptPassword");
                plainPassword = CryptoTean.decrypt((String)userInfo.getNumber(), (String)encryptPassword);
            }
            catch (CryptException e) {
                this.logger.error("password decrypt error:", (Throwable)e);
            }
            userInfoCopy.setPassword(plainPassword);
            boolean isChgPass = SecurityValidator.isRequireChangePassword((UserInfo)userInfoCopy);
            if (isChgPass) {
                updatePwReason = EASResource.getString((String)"com.kingdee.eas.base.permission.PermissionResource", (String)"changePwForSecurity");
            }
        }
        this.writeAjaxData(true, null, updatePwReason);
    }

    public void getGlobalRoaming() {
        try {
            IGlobalRoaming remoteInstance = GlobalRoamingFactory.getRemoteInstance();
            GlobalRoamingCollection globalRoamingCollection = remoteInstance.getGlobalRoamingCollection();
            GlobalRoamingInfo globalRoamingInfo = null;
            ArrayList<GlobalRoamingDTO> globalRoamingList = new ArrayList<GlobalRoamingDTO>();
            for (int i = 0; i < globalRoamingCollection.size(); ++i) {
                globalRoamingInfo = globalRoamingCollection.get(i);
                GlobalRoamingDTO globalRoamingDTO = new GlobalRoamingDTO();
                globalRoamingDTO.setId(globalRoamingInfo.getId().toString());
                globalRoamingDTO.setName(globalRoamingInfo.getName());
                globalRoamingDTO.setNumber(globalRoamingInfo.getNumber());
                globalRoamingDTO.setAreaCode(globalRoamingInfo.getAreaCode());
                globalRoamingList.add(globalRoamingDTO);
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put((Object)"globalRoamingList", globalRoamingList);
            this.writeAjaxData(true, null, jsonObj);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
    }

    private boolean checkPersonMetaInfo(String[] phoneInfos, String[] mailInfos) {
        return this.checkPersonPhoneInfo(phoneInfos) && this.checkPersonMailInfo(mailInfos);
    }

    private boolean checkPersonPhoneInfo(String ... phoneInfos) {
        for (String phoneInfo : phoneInfos) {
            boolean isValid;
            boolean bl = isValid = StringUtils.isEmpty((String)phoneInfo) || Pattern.matches(this.regex_phone, phoneInfo) || Pattern.matches(this.regex_mobile, phoneInfo);
            if (isValid) continue;
            return false;
        }
        return true;
    }

    private boolean checkPersonMailInfo(String ... mailInfos) {
        for (String mailInfo : mailInfos) {
            boolean isValid;
            boolean bl = isValid = StringUtils.isEmpty((String)mailInfo) || Pattern.matches(this.regex_email, mailInfo);
            if (isValid) continue;
            return false;
        }
        return true;
    }
}

