/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.module.personal.action;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.Administrator;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigFactory;
import com.kingdee.eas.base.uiframe.globlelogin.GlobleLoginConfigInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.portal.biz.common.action.BaseAction;
import com.kingdee.portal.biz.common.dao.PagingParam;
import com.kingdee.portal.biz.common.dao.PagingResult;
import com.kingdee.portal.biz.common.exception.DataAccessException;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.module.personal.dao.PrivacyStatementCustomDAO;
import com.kingdee.portal.biz.module.personal.entity.PrivacyStatementCustom;
import com.kingdee.portal.biz.module.personal.service.PrivacyStatementCustomService;
import com.kingdee.util.StringUtils;
import java.sql.Timestamp;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrivacyStatementCustomAction
extends BaseAction {
    private static final long serialVersionUID = 1L;
    private static Logger logger = LoggerFactory.getLogger(PrivacyStatementCustomAction.class);
    private PrivacyStatementCustomService privacyStatementCustomService = (PrivacyStatementCustomService)PortalServiceLocator.getBean((String)"privacyStatementCustomService");
    private PrivacyStatementCustomDAO privacyStatementCustomDAO;
    private static final String ITERATION = "iteration";
    private static final String ADD = "add";
    private static final String UPDATE = "update";
    private static final String VIEW = "view";
    private static final String COPY = "copy";
    public static final String STATUS_ENABLE = "ENABLE";
    public static final String STATUS_DISABLE = "DISABLE";
    protected PagingParam pagingParam;

    public PagingParam getPagingParam() {
        return this.pagingParam;
    }

    public void setPagingParam(PagingParam pagingParam) {
        this.pagingParam = pagingParam;
    }

    public void checkIsSignedById() {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        HttpServletRequest request = this.getRequest();
        String id = request.getParameter("id");
        boolean isSigned = this.privacyStatementCustomService.checkIsSigned(ctx, id);
        this.writeAjaxData(isSigned, null, null);
    }

    public void checkIsCanUpdate() {
    }

    public String editPrivacyContent() throws BOSException, EASBizException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = iUser.getUser(ctx.getUserName());
        if (user != null && user.getId() != null && !"administrator".equals(ctx.getUserName()) && !Administrator.isAdmin((BOSUuid)user.getId())) {
            this.writeAjaxData(false, null, "");
            return null;
        }
        JSONObject result = new JSONObject();
        HttpServletRequest request = this.getRequest();
        String viewContent = request.getParameter("viewContent");
        String type = request.getParameter("type");
        if (ADD.equals(type)) {
            request.setAttribute("operatorStatus", (Object)ADD);
            return ADD;
        }
        String id = request.getParameter("id");
        if (StringUtils.isEmpty((String)id)) {
            this.writeAjaxData(true, null, result);
        }
        PrivacyStatementCustom privacyContent = null;
        request.setAttribute("isView", (Object)VIEW.equalsIgnoreCase(viewContent));
        if (UPDATE.equals(type) || VIEW.equalsIgnoreCase(viewContent)) {
            try {
                if (!VIEW.equalsIgnoreCase(viewContent) && this.privacyStatementCustomService.checkIsSigned(ctx, id)) {
                    this.writeAjaxData(true, null, "");
                    return null;
                }
                privacyContent = this.privacyStatementCustomService.findPrivacyContent(id);
                request.setAttribute("privacyContent", (Object)privacyContent);
                request.setAttribute("operatorStatus", (Object)(UPDATE.equals(type) ? UPDATE : VIEW));
                return UPDATE;
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else if (ITERATION.equals(type)) {
            try {
                if (!this.privacyStatementCustomService.checkIsSigned(ctx, id)) {
                    this.writeAjaxData(true, null, "");
                    return null;
                }
                privacyContent = this.privacyStatementCustomService.findPrivacyContent(id);
                request.setAttribute("privacyContent", (Object)privacyContent);
                request.setAttribute("operatorStatus", (Object)ITERATION);
                return ITERATION;
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else if (COPY.equals(type)) {
            try {
                privacyContent = this.privacyStatementCustomService.findPrivacyContent(id);
                privacyContent.setId("");
                request.setAttribute("privacyContent", (Object)privacyContent);
                request.setAttribute("operatorStatus", (Object)COPY);
                return COPY;
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void savePrivacyContent() throws BOSException, EASBizException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = iUser.getUser(ctx.getUserName());
        if (user != null && user.getId() != null && !"administrator".equals(ctx.getUserName()) && !Administrator.isAdmin((BOSUuid)user.getId())) {
            this.writeAjaxData(false, null, "");
            return;
        }
        PrivacyStatementCustom entity = this.biludEntity();
        if (entity == null) {
            return;
        }
        String checkResult = this.checkEmpty(entity);
        if (checkResult != null) {
            this.writeAjaxData(false, null, checkResult);
            return;
        }
        HttpServletRequest request = this.getRequest();
        String addType = request.getParameter("addType");
        JSONObject result = new JSONObject();
        try {
            if (ADD.equals(addType)) {
                PrivacyStatementCustom privacyCheck = this.privacyStatementCustomService.findPrivacyContent(entity.getNumber(), entity.getVersion());
                if (privacyCheck != null) {
                    this.writeAjaxData(false, null, privacyCheck.getNumber() + "(" + privacyCheck.getVersion() + ") \u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                    return;
                }
                this.privacyStatementCustomService.addPrivacyContent(entity);
                result.put((Object)"contentId", (Object)entity.getId());
            } else if (ITERATION.equals(addType)) {
                PrivacyStatementCustom check = this.privacyStatementCustomService.findPrivacyContent(entity.getNumber(), entity.getVersion());
                if (check != null) {
                    this.writeAjaxData(false, null, check.getNumber() + "(" + check.getVersion() + ") \u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\uff01");
                    return;
                }
                this.privacyStatementCustomService.addPrivacyContent(entity);
                result.put((Object)"contentId", (Object)entity.getId());
            }
            this.writeAjaxData(true, null, result);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
    }

    private void updateSavePrivacyContent(Context ctx, PrivacyStatementCustom entity, String operatorStatus) {
        String checkResult = this.checkEmpty(entity);
        if (checkResult != null) {
            this.writeAjaxData(false, null, checkResult);
            return;
        }
        try {
            JSONObject result = new JSONObject();
            boolean isRepeat = this.privacyStatementCustomService.isRepeatPrivacy(ctx, entity.getNumber(), entity.getVersion(), null);
            if (isRepeat) {
                this.checkNumberAndVersionRepeat(entity.getNumber(), entity.getVersion());
                return;
            }
            String id = this.privacyStatementCustomService.addPrivacyContent2(entity);
            result.put((Object)"contentId", (Object)id);
            this.writeAjaxData(true, null, result);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
    }

    private void checkNumberAndVersionRepeat(String number, String version) {
        this.writeAjaxData(false, null, "\u7f16\u7801\uff1a" + number + "\uff0c\u7248\u672c\uff1a" + version + "\uff0c\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
    }

    private String checkEmpty(PrivacyStatementCustom entity) {
        if (StringUtils.isEmpty((String)entity.getNumber())) {
            return "\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((String)entity.getDisplayName())) {
            return "\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        if (StringUtils.isEmpty((String)entity.getVersion())) {
            return "\u7248\u672c\u4e0d\u80fd\u4e3a\u7a7a!";
        }
        return null;
    }

    public void findPrivacyContentById() {
        String id = this.getRequest().getParameter("id");
        try {
            PrivacyStatementCustom entity = this.privacyStatementCustomService.findPrivacyContent(id);
            JSONObject result = new JSONObject();
            result.put((Object)"entity", (Object)entity);
            this.writeAjaxData(true, null, result);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
    }

    public void deletePrivacyContentByIds() throws BOSException, EASBizException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = iUser.getUser(ctx.getUserName());
        if (user != null && user.getId() != null && !"administrator".equals(ctx.getUserName()) && !Administrator.isAdmin((BOSUuid)user.getId())) {
            this.writeAjaxData(false, null, "");
            return;
        }
        String ids = this.getRequest().getParameter("ids");
        if (StringUtils.isEmpty((String)ids)) {
            this.writeAjaxData(false, null, "\u8bf7\u9009\u62e9\u6570\u636e\uff01");
            return;
        }
        String[] split = ids.split(";");
        try {
            String result = this.privacyStatementCustomService.deletePrivacyContentByIds(ctx, split);
            if (StringUtils.isEmpty((String)result)) {
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, result);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, "\u5220\u9664\u5931\u8d25\uff01");
        }
    }

    public void updatePrivacyStatusById() throws BOSException, EASBizException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = iUser.getUser(ctx.getUserName());
        if (user != null && user.getId() != null && !"administrator".equals(ctx.getUserName()) && !Administrator.isAdmin((BOSUuid)user.getId())) {
            this.writeAjaxData(false, null, "");
            return;
        }
        String id = this.getRequest().getParameter("id");
        String status = this.getRequest().getParameter("type");
        try {
            GlobleLoginConfigInfo info;
            if (STATUS_DISABLE.equalsIgnoreCase(status) && (info = GlobleLoginConfigFactory.getLocalInstance((Context)ctx).getGlobleConfig(ctx)) != null && "2".equalsIgnoreCase(info.getPrivacyStatement())) {
                this.writeAjaxData(false, null, "isOpenPrivacy");
                return;
            }
            String result = this.privacyStatementCustomService.updatePrivacyStatusById(id, status);
            if (StringUtils.isEmpty((String)result)) {
                this.writeAjaxData(true, null, null);
            } else {
                this.writeAjaxData(false, null, result);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, "\u66f4\u65b0\u5931\u8d25\uff01");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void findAllPrivacyContent() {
        try {
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            String numberORdisplayName = this.getRequest().getParameter("numberORdisplayName");
            PagingResult pagingResult = this.privacyStatementCustomService.findPrivacyContentList(ctx, numberORdisplayName);
            this.writePagingResult(pagingResult);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePrivacyContent() throws BOSException, EASBizException {
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
        HttpServletRequest request = this.getRequest();
        IUser iUser = UserFactory.getLocalInstance((Context)ctx);
        UserInfo user = iUser.getUser(ctx.getUserName());
        if (user != null && user.getId() != null && !"administrator".equals(ctx.getUserName()) && !Administrator.isAdmin((BOSUuid)user.getId())) {
            this.writeAjaxData(false, null, "");
            return;
        }
        if (FilterSpecialCharactersTool.isContainXmlSpecialCharacters((HttpServletRequest)request)) {
            return;
        }
        String operatorStatus = request.getParameter("operatorStatus");
        PrivacyStatementCustom entity = this.biludEditEntity();
        try {
            if ((ADD.equalsIgnoreCase(operatorStatus) || COPY.equalsIgnoreCase(operatorStatus)) && StringUtils.isEmpty((String)entity.getId())) {
                this.updateSavePrivacyContent(ctx, entity, operatorStatus);
            } else {
                boolean isRepeat;
                if (!StringUtils.isEmpty((String)entity.getId()) && (isRepeat = this.privacyStatementCustomService.isRepeatPrivacy(ctx, entity.getNumber(), entity.getVersion(), entity.getId()))) {
                    this.checkNumberAndVersionRepeat(entity.getNumber(), entity.getVersion());
                    return;
                }
                this.privacyStatementCustomService.updatePrivacyContent(entity);
                this.writeAjaxData(true, null, null);
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            this.writeAjaxData(false, null, null);
        }
        catch (Exception e) {
            this.writeAjaxData(false, null, null);
            e.printStackTrace();
        }
    }

    public void savePrivacyHTML() {
        String contentId = this.getRequest().getParameter("contentId");
        String content_ = this.getRequest().getParameter("content");
        try {
            if (content_ == null || content_.equals("")) {
                content_ = "<div></div>";
            }
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)this.getRequest());
            this.privacyStatementCustomService.updatePrivacyHTML(ctx, contentId, content_);
            this.writeAjaxData(true, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PrivacyStatementCustom biludEntity() {
        PrivacyStatementCustom dto = new PrivacyStatementCustom();
        HttpServletRequest request = this.getRequest();
        if (FilterSpecialCharactersTool.isContainXmlSpecialCharacters((HttpServletRequest)request)) {
            return null;
        }
        dto.setNumber(request.getParameter("number"));
        dto.setDescription(request.getParameter("description"));
        dto.setDisplayName(request.getParameter("displayName"));
        Timestamp curTime = new Timestamp(new Date().getTime());
        dto.setDisableTime(curTime);
        dto.setEnableTime(curTime);
        String status = request.getParameter("status");
        status = StringUtils.isEmpty((String)status) ? STATUS_DISABLE : STATUS_ENABLE;
        dto.setStatus(status);
        dto.setVersion(request.getParameter("version"));
        dto.setPortalContext(this.getPortalContext());
        return dto;
    }

    private PrivacyStatementCustom biludEditEntity() {
        HttpServletRequest request = this.getRequest();
        PrivacyStatementCustom dto = new PrivacyStatementCustom();
        dto.setNumber(request.getParameter("number"));
        dto.setDisplayName(request.getParameter("displayName"));
        dto.setDescription(request.getParameter("description"));
        dto.setVersion(request.getParameter("version"));
        Timestamp curTime = new Timestamp(new Date().getTime());
        dto.setDisableTime(curTime);
        dto.setEnableTime(curTime);
        dto.setStatus(STATUS_DISABLE);
        dto.setPortalContext(this.getPortalContext());
        if (!StringUtils.isEmpty((String)request.getParameter("id"))) {
            dto.setId(request.getParameter("id"));
        }
        return dto;
    }

    public PrivacyStatementCustomDAO getPrivacyStatementCustomDAO() {
        return this.privacyStatementCustomDAO;
    }

    public void setPrivacyStatementCustomDAO(PrivacyStatementCustomDAO privacyStatementCustomDAO) {
        this.privacyStatementCustomDAO = privacyStatementCustomDAO;
    }
}

