/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.bos.metadata.configure.ConfigMDUtil;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class I18nServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(I18nServlet.class);
    private static final long serialVersionUID = 1L;
    private ServletContext context = null;
    private String[] resArray = null;

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sFileName = this.buildeParam(request);
        if (StringUtil.isEmpty((String)ConfigMDUtil.getContext().getAIS())) {
            ConfigMDUtil.getContext().setAIS((String)PortalContextUtil.getPortalContext((HttpServletRequest)request).getMetaInfo().get("current_data_center"));
        }
        this.writeResponse(response, this.getResContent(sFileName, PortalContextUtil.getPortalContext((HttpServletRequest)request).getLocale()).toString());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void writeResponse(HttpServletResponse response, String result) {
        try {
            response.setContentType("text/html");
            response.getOutputStream().write(result.toString().getBytes("utf-8"));
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    private String buildeParam(HttpServletRequest request) {
        String sFileName = "";
        String res = request.getParameter("r");
        if (res != null) {
            this.resArray = res.split(",");
        }
        sFileName = this.resArray[1].equals("zh_CN") || this.resArray[1].equals("zh_TW") ? "/" + this.resArray[0] + "_" + this.resArray[1] + ".properties" : "/" + this.resArray[0] + ".properties";
        return sFileName;
    }

    private StringBuilder getResContentFromEAS(Locale locale) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getResContent(String sFileName, Locale locale) {
        StringBuilder resContent = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(sFileName)));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                resContent.append(line).append("\n");
            }
        }
        catch (Exception ex) {
            logger.error("\u6ca1\u6709\u627e\u5230i18n\u8d44\u6e90\uff1a" + sFileName, (Throwable)ex);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return resContent;
    }
}

