/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.handle.ErrHandle;
import com.kingdee.portal.biz.common.exception.model.LocalErr;
import com.kingdee.portal.biz.common.util.FilterSpecialCharactersTool;
import com.kingdee.portal.biz.common.util.PortalContextUtil;
import com.kingdee.portal.common.util.PortletUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.ArrayList;
import javax.portlet.Event;
import javax.portlet.PortletException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.pluto.container.PortletContainer;
import org.apache.pluto.container.PortletContainerException;
import org.apache.pluto.container.PortletWindow;
import org.apache.pluto.driver.core.PortalRequestContext;
import org.apache.pluto.driver.core.PortletWindowImpl;
import org.apache.pluto.driver.services.container.EventImpl;
import org.apache.pluto.driver.services.portal.PageConfig;
import org.apache.pluto.driver.services.portal.PortletWindowConfig;
import org.apache.pluto.driver.url.PortalURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortletDriverServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(PortletDriverServlet.class);
    private ServletContext servletContext = null;
    protected PortletContainer container = null;
    private String contentType = "";
    private String charset = "";
    private static final String DEFAULT_PAGE_URI = "/pages/core/pluto-default-theme.jsp";
    private static final String DEFAULT_FRAGMENT_INS_ID = "fragment";
    private static final String ERROR_PORTLET_URI = "/pages/error/portletErr.jsp";

    public String getServletInfo() {
        return "Kingdee Portal Driver Servlet";
    }

    public void init() {
        this.servletContext = this.getServletContext();
        this.container = (PortletContainer)this.servletContext.getAttribute("portletContainer");
        this.charset = this.getServletConfig().getInitParameter("charset");
        if (this.charset != null && this.charset.length() > 0) {
            this.contentType = "text/html; charset=" + this.charset;
        } else {
            this.charset = "utf-8";
            this.contentType = "text/html; charset=utf-8";
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (!this.contentType.equals("")) {
            request.setCharacterEncoding(this.charset);
            response.setContentType(this.contentType);
        }
        try {
            this.invokePortletContainer(request, response);
        }
        catch (Exception ex) {
            LocalErr localErr = this.handleErr(request, ex);
            request.setAttribute("portletErrInfo", (Object)localErr);
            RequestDispatcher dispatcher = request.getRequestDispatcher(ERROR_PORTLET_URI);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private LocalErr handleErr(HttpServletRequest request, Exception ex) {
        PortalContext portalContext = PortalContextUtil.getPortalContext((HttpServletRequest)request);
        LocalErr err = ErrHandle.getLocalErr((Exception)ex, (PortalContext)portalContext);
        LOG.error(err.toString());
        return err;
    }

    private void invokePortletContainer(HttpServletRequest request, HttpServletResponse response) throws Exception {
        PortalRequestContext portalRequestContext = new PortalRequestContext(this.getServletContext(), request, response);
        PortalURL portalURL = null;
        try {
            portalURL = portalRequestContext.getRequestedPortalURL();
        }
        catch (Exception ex) {
            String msg = "Cannot handle request for portal URL. Problem: " + ex.getMessage();
            LOG.error(msg, (Throwable)ex);
            throw new ServletException(msg, (Throwable)ex);
        }
        String actionWindowId = portalURL.getActionWindow();
        String eventWindowId = portalURL.getEventWindow();
        String resourceWindowId = portalURL.getResourceWindow();
        PortletWindowConfig actionWindowConfig = null;
        PortletWindowConfig eventWindowConfig = null;
        PortletWindowConfig resourceWindowConfig = null;
        if (resourceWindowId != null) {
            resourceWindowConfig = PortletWindowConfig.fromId((String)resourceWindowId);
        } else if (actionWindowId != null) {
            actionWindowConfig = PortletWindowConfig.fromId((String)actionWindowId);
        } else if (eventWindowId != null) {
            eventWindowConfig = PortletWindowConfig.fromId((String)eventWindowId);
        }
        if (actionWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, actionWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing action request for window: " + portletWindow.getId().getStringId());
            }
            try {
                this.container.doAction((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action request processed.\n\n");
            }
        } else if (eventWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, eventWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing action request for window: " + portletWindow.getId().getStringId());
            }
            try {
                Event event = this.getEvent(request);
                this.container.doEvent((PortletWindow)portletWindow, request, response, event);
            }
            catch (Exception ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Action request processed.\n\n");
            }
        } else if (resourceWindowConfig != null) {
            PortletWindowImpl portletWindow = new PortletWindowImpl(this.container, resourceWindowConfig, portalURL);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing resource Serving request for window: " + portletWindow.getId().getStringId());
            }
            try {
                this.container.doServeResource((PortletWindow)portletWindow, request, response);
            }
            catch (PortletContainerException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            catch (PortletException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                throw new ServletException((Throwable)ex);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource serving request processed.\n\n");
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing render request.");
            }
            PageConfig pageConfig = this.buildeOnlyPortletPageConfig(request, portalURL);
            request.setAttribute("currentPage", (Object)pageConfig);
            RequestDispatcher dispatcher = request.getRequestDispatcher(DEFAULT_PAGE_URI);
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Render request processed.\n\n");
            }
        }
    }

    private Event getEvent(HttpServletRequest request) {
        String eventKey = request.getParameter("eventKey");
        Event event = null;
        event = eventKey.startsWith("portal-simple-event") ? this.createSimpleEvent(eventKey) : (Event)request.getSession().getAttribute(eventKey);
        return event;
    }

    private Event createSimpleEvent(String eventKey) {
        if (StringUtil.isEmpty((String)eventKey)) {
            throw new IllegalArgumentException("Portlet\u7b80\u5355\u4e8b\u4ef6\u4f20\u9012\u53c2\u6570\u9519\u8bef\u3002\u5fc5\u987b\u540c\u65f6\u5305\u542bnamespace,eventName,eventValue\u7684\u4fe1\u606f\u3002");
        }
        String[] params = eventKey.split("\\$");
        if (params.length < 3 || params.length > 4) {
            throw new IllegalArgumentException("Portlet\u7b80\u5355\u4e8b\u4ef6\u4f20\u9012\u53c2\u6570\u9519\u8bef\u3002\u5fc5\u987b\u540c\u65f6\u5305\u542bnamespace,eventName,eventValue\u7684\u4fe1\u606f\u3002");
        }
        String namespace = "";
        String eventName = "";
        String eventValue = "";
        namespace = params[1];
        eventName = params[2];
        eventValue = params.length == 4 ? params[3] : "";
        QName qName = QName.valueOf("{" + namespace + "}" + eventName);
        EventImpl event = new EventImpl(qName, (Serializable)((Object)eventValue));
        return event;
    }

    private PageConfig buildeOnlyPortletPageConfig(HttpServletRequest request, PortalURL portalURL) {
        String requestURI = PortletUtil.decodeCharacters((String)URLDecoder.decode(request.getRequestURI()));
        LOG.info(">>> request:" + requestURI);
        PortletWindowConfig portletWindowConfig = null;
        String contextPath = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("contextPath"));
        String portletName = FilterSpecialCharactersTool.cleanXSS((String)request.getParameter("portletName"));
        String portletInsId = request.getParameter("portletInsId");
        if (StringUtil.isEmpty((String)portletInsId) || !portletInsId.matches("fragment-[1-9]\\d*")) {
            portletInsId = DEFAULT_FRAGMENT_INS_ID;
        }
        if (StringUtil.isEmpty((String)contextPath) || StringUtil.isEmpty((String)portletName)) {
            String portletWindowId = PortletDriverServlet.getWindowIdByQueryString(request);
            portletWindowConfig = PortletWindowConfig.fromId((String)portletWindowId);
            contextPath = portletWindowConfig.getContextPath();
            portletName = portletWindowConfig.getPortletName();
            portletInsId = portletWindowConfig.getPortletInsId();
            if (StringUtil.isEmpty((String)contextPath) || StringUtil.isEmpty((String)portletName) || StringUtil.isEmpty((String)portletInsId)) {
                LOG.error("Please check uri format :" + requestURI);
                throw new IllegalArgumentException("\u6807\u51c6\u5316Portlet\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u7f3a\u5c11contextPath\u3001PortletName\u3001portletInsId\u4e2d\u7684\u5176\u4e2d\u4e00\u9879");
            }
        } else {
            portletWindowConfig = new PortletWindowConfig();
            portletWindowConfig.setContextPath(contextPath);
            portletWindowConfig.setPortletName(portletName);
            String metaInfo = portletInsId + "|0";
            portletWindowConfig.setMetaInfo(metaInfo);
        }
        String portletId = portletWindowConfig.getId();
        if (portletId.indexOf("$") > -1 || portletId.indexOf(".") > -1 || portletId.indexOf("'") > -1) {
            portletId = portletId.replaceAll("\\$", "%24");
            portletId = portletId.replaceAll("\\{", "%7b");
            portletId = portletId.replaceAll("\\}", "%7d");
        }
        ArrayList<String> portletIds = new ArrayList<String>();
        portletIds.add(portletId);
        PageConfig pageConfig = new PageConfig();
        pageConfig.setName(portletName);
        pageConfig.setPortletIds(portletIds);
        pageConfig.setUri(DEFAULT_PAGE_URI);
        return pageConfig;
    }

    private static String getWindowIdByQueryString(HttpServletRequest request) {
        String windowId = "";
        String uri = URLDecoder.decode(request.getRequestURI());
        if (uri.indexOf("/__ws") > 0) {
            windowId = uri;
            windowId = windowId.substring(windowId.indexOf("/__ws") + 5);
            windowId = windowId.substring(0, windowId.indexOf("_"));
        } else if (uri.indexOf("/__pm") > 0) {
            windowId = uri;
            windowId = windowId.substring(windowId.indexOf("/__pm") + 5);
            windowId = windowId.substring(0, windowId.indexOf("_"));
        }
        windowId = PortletUtil.decodeCharacters((String)windowId);
        return windowId;
    }
}

