/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet;

import com.kingdee.portal.common.util.Constant;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(ResServlet.class);
    private static final long serialVersionUID = 1L;
    private ServletContext context = null;
    private String[] resArray = null;
    private String resName = null;

    public void init(ServletConfig config) throws ServletException {
        this.context = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.buildeParam(request);
        if (this.resName != null && this.resArray != null) {
            String resContent = this.mergeResContent();
            if (!this.isJavascript() && this.isCss()) {
                resContent = resContent.replaceAll("\\{portal_version\\}", Constant.PORTAL_VERSION);
            }
            this.writeResponse(response, resContent);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    private void buildeParam(HttpServletRequest request) {
        String res = request.getParameter("r");
        if (res != null) {
            this.resArray = res.split(",");
        }
        String uri = request.getRequestURI();
        this.resName = uri.substring(uri.lastIndexOf("/") + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getResContent(String resPath) {
        StringBuilder resContent = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(this.context.getResourceAsStream(resPath)));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                resContent.append(line).append("\n");
            }
        }
        catch (IOException ioEx) {
            logger.error("\u6ca1\u6709\u627e\u5230\u8d44\u6e90\uff1a" + resPath);
            ioEx.printStackTrace();
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return resContent;
    }

    private String mergeResContent() {
        StringBuilder resArrayContent = new StringBuilder();
        for (String resPath : this.resArray) {
            StringBuilder resContent = this.getResContent(resPath);
            resArrayContent.append("/********************").append(resPath).append(" start********************/\n");
            resArrayContent.append((CharSequence)resContent);
            resArrayContent.append("\n/********************").append(resPath).append(" end********************/\n");
        }
        return resArrayContent.toString();
    }

    private void writeResponse(HttpServletResponse response, String result) {
        try {
            response.setContentType(this.getContentType());
            response.getOutputStream().write(result.toString().getBytes("utf-8"));
        }
        catch (Exception ex) {
            logger.error("\u4e0d\u80fd\u5199\u6570\u636e\u3002\u5f02\u5e38\u5982\u4e0b\uff1a{}", (Throwable)ex);
        }
    }

    private boolean isJavascript() {
        return this.resName.toLowerCase().endsWith(".js");
    }

    private String getContentType() {
        if (this.isJavascript()) {
            return "application/javascript";
        }
        if (this.isCss()) {
            return "text/css";
        }
        return "*/*";
    }

    private boolean isCss() {
        return this.resName.toLowerCase().endsWith(".css");
    }
}

