/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.servlet.yzj;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.cp.eip.sso.qrcode.exception.AppAuth2Exception;
import com.kingdee.eas.cp.eip.sso.util.AutoLoginConfigPropUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.portal.web.servlet.yzj.util.CloudToEASManager;
import com.kingdee.util.StringUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudToEASServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(CloudToEASServlet.class);
    private final String LOGINFAILPAGE = "/eassso/login";

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doPost(req, resp);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        logger.error("CloudToEASServlet  start-----------------");
        String ticket = req.getParameter("ticket");
        String businessUrl = this.buildBusinessUrl(req);
        String openId = null;
        try {
            openId = CloudToEASManager.getOpenId(ticket);
        }
        catch (AppAuth2Exception e) {
            logger.error("\u83b7\u53d6openid\u5931\u8d25\uff01\u5f02\u5e38\u4fe1\u606f\u5982\u4e0b\uff1a");
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)openId)) {
            resp.sendRedirect("/eassso/login?service=" + URLEncoder.encode(businessUrl, "utf-8"));
            return;
        }
        Context ctx = CloudToEASManager.getContextWithAutoLoginCfg();
        String userName = CloudToEASManager.getUserInfoMapByOpenId(ctx, openId);
        if (StringUtils.isEmpty((String)userName)) {
            logger.error("\u627e\u4e0d\u5230\u5173\u8054\u7528\u6237,openid is " + openId);
            resp.setContentType("text/html;charset=utf-8");
            resp.getOutputStream().write("\u627e\u4e0d\u5230\u5173\u8054\u7528\u6237\uff0c\u7528\u6237\u540c\u6b65\u540e\u518d\u8bd5\uff01".getBytes("utf-8"));
            return;
        }
        if (this.isRelogin(userName, ctx, req)) {
            resp.sendRedirect(URLDecoder.decode(businessUrl, "utf-8"));
            return;
        }
        String ltpatoken = LtpaTokenManager.generate((String)userName, (String)LtpaTokenManager.getDefaultLtpaConfig()).toString();
        String redirectUrl = "/portal/index2sso.jsp?isNotCheckRelogin=true&username=" + URLEncoder.encode(userName, "utf-8") + "&password=" + ltpatoken + "&redirectTo=" + businessUrl;
        logger.error("CloudLoginEASFilter loginEAS redirectUrl===" + redirectUrl);
        resp.sendRedirect(redirectUrl);
    }

    private boolean isRelogin(String userName, Context ctx, HttpServletRequest req) {
        UserInfo loginedUser = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userName != null && loginedUser != null && userName.equals(loginedUser.getNumber())) {
            String dataCenter = req.getParameter("dataCenter");
            String locale = req.getParameter("locale");
            if (StringUtils.isEmpty((String)dataCenter)) {
                dataCenter = AutoLoginConfigPropUtil.getDataCenter();
            }
            if (StringUtils.isEmpty((String)locale)) {
                locale = AutoLoginConfigPropUtil.getLocale();
            }
            logger.error("login usernumber---" + userName + "    dc----" + dataCenter + "    locale----" + locale);
            if (dataCenter.equals(ctx.getAIS()) && locale.equalsIgnoreCase(ctx.getLocale().toString())) {
                return true;
            }
        }
        return false;
    }

    private String buildBusinessUrl(HttpServletRequest req) {
        String pageUrl = req.getParameter("pageUrl");
        String redirectTo = req.getParameter("redirectTo");
        if (!StringUtils.isEmpty((String)pageUrl)) {
            redirectTo = pageUrl;
        }
        if (StringUtils.isEmpty((String)redirectTo)) {
            redirectTo = "//";
        }
        try {
            redirectTo = !redirectTo.contains("?") ? redirectTo + "?" : redirectTo + "&";
            Map paramMap = req.getParameterMap();
            for (Map.Entry entry : paramMap.entrySet()) {
                Object ov = entry.getValue();
                String[] value = new String[1];
                if (ov instanceof String[]) {
                    value = (String[])ov;
                } else {
                    value[0] = ov.toString();
                }
                if (value[0] == null || "ticket".equals(entry.getKey()) || "redirectTo".equals(entry.getKey()) || "pageUrl".equals(entry.getKey())) continue;
                redirectTo = redirectTo + (String)entry.getKey() + "=" + value[0] + "&";
            }
            return URLEncoder.encode(redirectTo.substring(0, redirectTo.length() - 1), "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return "//";
        }
    }
}

