/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.system;

import com.kingdee.portal.biz.cache.PortalCache;
import com.kingdee.portal.biz.common.cache.impl.ServletContextCache;
import com.kingdee.portal.biz.common.context.PortalContext;
import com.kingdee.portal.biz.common.exception.PortalBizException;
import com.kingdee.portal.biz.common.util.PortalServiceLocator;
import com.kingdee.portal.biz.core.datacenter.DSObserver;
import com.kingdee.portal.biz.facade.eas.EASService;
import com.kingdee.portal.common.util.Constant;
import com.kingdee.portal.common.util.FileUtil;
import com.kingdee.portal.common.util.StringUtil;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysManager {
    private static Logger logger = LoggerFactory.getLogger(SysManager.class);
    private static ServletContext sysContext = null;

    public static void initialize(ServletContext context) {
        logger.info("jPortal is initialize ...");
        sysContext = context;
        ServletContextCache.setServletContext((ServletContext)sysContext);
        try {
            Class.forName("com.kingdee.portal.biz.common.exception.conf.ErrConfig");
            Class.forName("com.kingdee.portal.biz.common.exception.conf.PortalErrConfig");
        }
        catch (ClassNotFoundException e) {
            logger.error("initialize===", (Throwable)e);
        }
        SysManager.initSysInfo();
        SysManager.clearResource();
    }

    public static void destroy() {
        logger.info("jPortal is destroy ...");
        sysContext = null;
        SysManager.clearResource();
    }

    public static void logonSuccess(HttpSession session) {
        logger.error(">>>logonSuccess sessionId=");
        PortalContext portalContext = (PortalContext)session.getAttribute("portal_context");
        logger.info(portalContext.getLoginUser().getCode() + " login success.");
        if (StringUtil.isEmpty((String)DSObserver.getSp())) {
            String currentDataCenterCode = (String)portalContext.getMetaInfo().get("current_data_center");
            DSObserver.putDSName((String)currentDataCenterCode);
        }
        SysManager.initCache();
        SysManager.setConstant2Session(session);
    }

    public static void logout(HttpSession session) {
        PortalContext portalContext = (PortalContext)session.getAttribute("portal_context");
        if (portalContext != null) {
            logger.info(portalContext.getLoginUser().getCode() + " is logout.");
            if (StringUtil.isEmpty((String)DSObserver.getSp())) {
                String currentDataCenterCode = (String)portalContext.getMetaInfo().get("current_data_center");
                DSObserver.putDSName((String)currentDataCenterCode);
            }
            SysManager.deleteUserMonitorInfo(portalContext);
            SysManager.removeSession((String)portalContext.getMetaInfo().get("eas_context_id"));
        }
    }

    private static void initSysInfo() {
        Constant.SYSTEM_ROOT_PATH = sysContext.getRealPath("/");
        Constant.TEMP_UPLOAD_PATH = Constant.SYSTEM_ROOT_PATH + Constant.TEMP_UPLOAD_PATH;
    }

    private static void clearResource() {
        FileUtil.deleteAllFile4First((String)Constant.TEMP_UPLOAD_PATH);
    }

    private static synchronized void initCache() {
        if (!PortalCache.isExisted4SysPageList()) {
            PortalCache.freshEnabledSysPageList();
        }
        if (!PortalCache.isExisted4PageLayoutTmplList()) {
            PortalCache.freshEnabledPageLayoutTmplList();
        }
        if (!PortalCache.isExisted4PortletTmplList()) {
            PortalCache.freshEnabledPortletTmplList();
        }
        if (!PortalCache.isExisted4PortalProfileMap()) {
            PortalCache.freshPortalProfileMap();
        }
    }

    private static void setConstant2Session(HttpSession session) {
        session.setAttribute("portal_version", (Object)Constant.PORTAL_VERSION);
        Map portalProfileMap = PortalCache.getPortalProfileMap();
        String portal_skin = (String)portalProfileMap.get("default_page_theme");
        portal_skin = "gray";
        session.setAttribute("portal_skin", (Object)portal_skin);
    }

    private static void removeSession(String sessionId) {
        EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
        easService.removeEASSession(sessionId);
    }

    private static void deleteUserMonitorInfo(PortalContext ctx) {
        EASService easService = (EASService)PortalServiceLocator.getBean((String)"easService");
        try {
            easService.deleteUserMonitor(ctx);
        }
        catch (PortalBizException e) {
            logger.error("deleteUserMonitorInfo===", (Throwable)e);
        }
    }
}

