/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.portal.web.system.filter.cache;

import com.kingdee.bos.bi.model.util.StringUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ClientCacheFilter
implements Filter {
    private int expireTime = 28800;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        this.setExpire(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void init(FilterConfig fConfig) throws ServletException {
        String expireTimeStr = fConfig.getInitParameter("expireTime");
        if (!StringUtil.isEmpty((String)expireTimeStr)) {
            try {
                this.expireTime = new Integer(expireTimeStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setExpire(HttpServletResponse response) {
        response.addHeader("Cache-Control", "max-age=" + this.expireTime);
    }
}

